/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.shared.commands;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import org.dimdev.ddutils.Location;
import org.dimdev.ddutils.TeleportUtils;
import org.dimdev.ddutils.WorldUtils;
import org.dimdev.dimdoors.shared.pockets.PocketGenerator;
import org.dimdev.dimdoors.shared.pockets.PocketTemplate;
import org.dimdev.dimdoors.shared.pockets.SchematicHandler;
import org.dimdev.dimdoors.shared.rifts.registry.RiftRegistry;
import org.dimdev.dimdoors.shared.rifts.targets.IEntityTarget;
import org.dimdev.dimdoors.shared.world.ModDimensions;
import org.dimdev.pocketlib.Pocket;

public class CommandPocket
extends CommandBase {
    public String func_71517_b() {
        return "pocket";
    }

    public String func_71518_a(ICommandSender sender) {
        return "commands.pocket.usage";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        EntityPlayerMP player = CommandPocket.func_71521_c((ICommandSender)sender);
        if (args.length < 2 || args.length > 3) {
            throw new WrongUsageException("commands.pocket.usage", new Object[0]);
        }
        if (!ModDimensions.isDimDoorsPocketDimension(player.field_70170_p)) {
            throw new CommandException("commands.generic.dimdoors.not_in_pocket_dim", new Object[0]);
        }
        String group = args[0];
        String name = args[1];
        if (!SchematicHandler.INSTANCE.getTemplateGroups().contains(group)) {
            throw new CommandException("commands.pocket.group_not_found", new Object[]{group});
        }
        if (!SchematicHandler.INSTANCE.getTemplateNames(group).contains(name)) {
            throw new CommandException("commands.pocket.template_not_found", new Object[]{name});
        }
        boolean setup = args.length < 3 || CommandPocket.func_180527_d((String)args[2]);
        PocketTemplate template = SchematicHandler.INSTANCE.getTemplate(group, name);
        Pocket pocket = PocketGenerator.generatePocketFromTemplate(WorldUtils.getDim(player.field_70170_p), template, null, setup);
        if (RiftRegistry.instance().getPocketEntrance(pocket) != null) {
            IEntityTarget entrance = (IEntityTarget)player.field_70170_p.func_175625_s(RiftRegistry.instance().getPocketEntrance(pocket).getPos());
            entrance.receiveEntity((Entity)player, 0.0f, 0.0f);
        } else {
            int size = (pocket.getSize() + 1) * 16;
            TeleportUtils.teleport((Entity)player, new Location(player.field_70170_p, pocket.getOrigin().func_177982_a(size / 2, size / 2, size / 2)));
        }
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        ArrayList<String> list = new ArrayList<String>();
        switch (args.length) {
            case 1: {
                list = new ArrayList<String>(SchematicHandler.INSTANCE.getTemplateGroups());
                break;
            }
            case 2: {
                list = new ArrayList<String>(SchematicHandler.INSTANCE.getTemplateNames(args[0]));
                break;
            }
            case 3: {
                list.add("true");
                list.add("false");
            }
        }
        return list.stream().filter(s -> s.toLowerCase().startsWith(args[args.length - 1].toLowerCase())).collect(Collectors.toList());
    }
}

