/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.shared.blocks;

import java.util.Random;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.Particle;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.dimdev.ddutils.blocks.BlockSpecialAir;
import org.dimdev.dimdoors.DimDoors;
import org.dimdev.dimdoors.client.RiftParticle;
import org.dimdev.dimdoors.shared.ModConfig;
import org.dimdev.dimdoors.shared.blocks.IRiftProvider;
import org.dimdev.dimdoors.shared.tileentities.TileEntityFloatingRift;
import org.dimdev.dimdoors.shared.world.ModDimensions;

public class BlockFloatingRift
extends BlockSpecialAir
implements ITileEntityProvider,
IRiftProvider<TileEntityFloatingRift> {
    public static final String ID = "rift";

    public BlockFloatingRift() {
        this.setRegistryName(new ResourceLocation("dimdoors", ID));
        this.func_149663_c(ID);
        this.func_149675_a(true);
        this.func_149752_b(6000000.0f);
        this.func_149715_a(0.5f);
    }

    public TileEntityFloatingRift createNewTileEntity(World world, int meta) {
        return new TileEntityFloatingRift();
    }

    public MapColor func_180659_g(IBlockState state, IBlockAccess world, BlockPos pos) {
        return MapColor.field_151646_E;
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntityFloatingRift rift = (TileEntityFloatingRift)world.func_175625_s(pos);
        rift.unregister();
        super.func_180663_b(world, pos, state);
    }

    @Override
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess world, BlockPos pos) {
        EntityPlayer player;
        if (ModConfig.rifts.riftBoundingBoxInCreative && (player = DimDoors.proxy.getLocalPlayer()) != null && player.func_184812_l_()) {
            return blockState.func_185900_c(world, pos);
        }
        return null;
    }

    @Override
    public TileEntityFloatingRift getRift(World world, BlockPos pos, IBlockState state) {
        return (TileEntityFloatingRift)world.func_175625_s(pos);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (!(tileEntity instanceof TileEntityFloatingRift)) {
            return;
        }
        TileEntityFloatingRift rift = (TileEntityFloatingRift)tileEntity;
        boolean outsidePocket = !ModDimensions.isDimDoorsPocketDimension(world);
        double speed = 0.1;
        if (rift.closing) {
            FMLClientHandler.instance().getClient().field_71452_i.func_78873_a((Particle)new RiftParticle(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.5, (double)pos.func_177952_p() + 0.5, rand.nextGaussian() * speed, rand.nextGaussian() * speed, rand.nextGaussian() * speed, outsidePocket ? 0.8f : 0.4f, 0.55f, 2000, 2000));
        }
        FMLClientHandler.instance().getClient().field_71452_i.func_78873_a((Particle)new RiftParticle(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.5, (double)pos.func_177952_p() + 0.5, rand.nextGaussian() * speed, rand.nextGaussian() * speed, rand.nextGaussian() * speed, outsidePocket ? 0.0f : 0.7f, 0.55f, rift.stabilized ? 750 : 2000, rift.stabilized ? 750 : 2000));
    }
}

