/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.client;

import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.dimdev.ddutils.RGBA;
import org.dimdev.dimdoors.client.RiftCrackRenderer;
import org.dimdev.dimdoors.client.tesseract.Tesseract;
import org.dimdev.dimdoors.shared.ModConfig;
import org.dimdev.dimdoors.shared.tileentities.TileEntityFloatingRift;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class TileEntityFloatingRiftRenderer
extends TileEntitySpecialRenderer<TileEntityFloatingRift> {
    private static final ResourceLocation tesseract_path = new ResourceLocation("dimdoors:textures/other/tesseract.png");
    private static final Tesseract tesseract = new Tesseract();
    public static long showRiftCoreUntil = 0L;

    public void render(TileEntityFloatingRift rift, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        if (ModConfig.graphics.showRiftCore) {
            this.renderTesseract(rift, x, y, z, partialTicks);
        } else {
            long timeLeft = showRiftCoreUntil - System.currentTimeMillis();
            if (timeLeft >= 0L) {
                this.renderTesseract(rift, x, y, z, partialTicks);
            }
        }
        this.renderCrack(rift, x, y, z);
    }

    private void renderCrack(TileEntityFloatingRift rift, double x, double y, double z) {
        GL11.glPushMatrix();
        GlStateManager.func_179140_f();
        GlStateManager.func_179129_p();
        GlStateManager.func_179090_x();
        GlStateManager.func_179147_l();
        RiftCrackRenderer.drawCrack(rift.riftYaw, rift.getCurve(), ModConfig.graphics.riftSize * (double)rift.size / 150.0, x + 0.5, y + 1.5, z + 0.5);
        GlStateManager.func_179084_k();
        GlStateManager.func_179098_w();
        GlStateManager.func_179089_o();
        GlStateManager.func_179145_e();
        GL11.glPopMatrix();
    }

    private void renderTesseract(TileEntityFloatingRift rift, double x, double y, double z, float partialTicks) {
        double radian = this.updateTesseractAngle(rift, partialTicks) * (Math.PI / 180);
        RGBA color = rift.getColor();
        if (color == null) {
            color = new RGBA(1.0f, 0.5f, 1.0f, 1.0f);
        }
        GlStateManager.func_179140_f();
        GlStateManager.func_179094_E();
        GlStateManager.func_179129_p();
        this.func_147499_a(tesseract_path);
        GlStateManager.func_179137_b((double)(x + 0.5), (double)(y + 0.5), (double)(z + 0.5));
        GlStateManager.func_179139_a((double)0.25, (double)0.25, (double)0.25);
        tesseract.draw(color, radian);
        GlStateManager.func_179089_o();
        GlStateManager.func_179121_F();
        GlStateManager.func_179145_e();
    }

    private double updateTesseractAngle(TileEntityFloatingRift rift, float partialTicks) {
        rift.renderAngle = (rift.renderAngle + (double)(5.0f * partialTicks)) % 360.0;
        return rift.renderAngle;
    }
}

