/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.ddutils.lsystem;

import java.awt.Point;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.poly2tri.Poly2Tri;
import org.poly2tri.geometry.polygon.Polygon;
import org.poly2tri.geometry.polygon.PolygonPoint;
import org.poly2tri.triangulation.TriangulationPoint;
import org.poly2tri.triangulation.delaunay.DelaunayTriangle;

public final class LSystem {
    public static ArrayList<PolygonInfo> curves = new ArrayList();
    public static final String[] TERDRAGON = new String[]{"F>+F----F++++F-", "60", "F"};
    public static final String[] DRAGON = new String[]{"X>X+YF:Y>FX-Y", "90", "FX"};
    public static final String[] TWINDRAGON = new String[]{"X>X+YF:Y>FX-Y", "90", "FX--FX"};
    public static final String[] VORTEX = new String[]{"X>X+YF:Y>FX-Y", "90", "FX---FX"};

    public static void generateLSystem(String key, String[] args, int steps) {
        String[] rules = args[0].split(":");
        HashMap<String, String> lSystemsRule = new HashMap<String, String>();
        for (String rule : rules) {
            String[] parts = rule.split(">");
            lSystemsRule.put(parts[0], parts[1]);
        }
        int angle = Integer.parseInt(args[1]);
        String output = LSystem.generate(args[2], steps, lSystemsRule);
        List<Point> polygon = LSystem.getBoundary(LSystem.convertToPoints(angle, output, steps));
        curves.add(new PolygonInfo(LSystem.tesselate(polygon)));
    }

    public static List<Point> getBoundary(ArrayList<double[]> input) {
        int maxY = Integer.MIN_VALUE;
        int maxX = Integer.MIN_VALUE;
        int minY = Integer.MAX_VALUE;
        int minX = Integer.MAX_VALUE;
        HashSet<Point> singles = new HashSet<Point>();
        ArrayList<Point> output = new ArrayList<Point>();
        for (double[] point : input) {
            int xCoord = (int)Math.round(point[0]);
            int yCoord = (int)Math.round(point[1]);
            if (xCoord > maxX) {
                maxX = xCoord;
            }
            if (xCoord < minX) {
                minX = xCoord;
            }
            if (yCoord > maxY) {
                maxY = yCoord;
            }
            if (yCoord < minY) {
                minY = yCoord;
            }
            singles.add(new Point(xCoord, yCoord));
        }
        Point startPoint = new Point(minX, minY);
        Point prevPoint = (Point)startPoint.clone();
        while (startPoint.y < maxY && !singles.contains(startPoint)) {
            ++startPoint.y;
        }
        Point firstPoint = (Point)startPoint.clone();
        Point direction = LSystem.getVector(prevPoint, startPoint);
        do {
            direction = LSystem.rotateCounterClockwise(direction);
            Point target = new Point(startPoint.x + direction.x, startPoint.y + direction.y);
            if (!singles.contains(target)) continue;
            if (target.equals(firstPoint)) {
                output.remove(output.get(output.size() - 1));
                break;
            }
            direction = LSystem.getVector(startPoint, target);
            if (output.size() > 1 && output.get(output.size() - 2).equals(target)) {
                output.remove(output.size() - 1);
            } else {
                if (output.contains(target) && !target.equals(output.get(0))) {
                    int index = output.indexOf(target);
                    while (output.size() > index) {
                        output.remove(output.size() - 1);
                    }
                }
                output.add(target);
            }
            startPoint = target;
        } while ((!((Point)output.get(output.size() - 1)).equals(firstPoint) || output.size() <= 1) && output.size() < singles.size());
        return output;
    }

    public static Point getVector(Point origin, Point destination) {
        int[] normals = new int[]{origin.x - destination.x, origin.y - destination.y};
        for (int i = 0; i < normals.length; ++i) {
            if (normals[i] > 0) {
                normals[i] = 1;
                continue;
            }
            if (normals[i] == 0) {
                normals[i] = 0;
                continue;
            }
            if (normals[i] >= 0) continue;
            normals[i] = -1;
        }
        return new Point(normals[0], normals[1]);
    }

    public static Point rotateCounterClockwise(Point previous) {
        Point point = new Point();
        point.x = (int)((double)previous.x * Math.cos(Math.toRadians(90.0)) - (double)previous.y * Math.sin(Math.toRadians(90.0)));
        point.y = (int)((double)previous.x * Math.sin(Math.toRadians(90.0)) + (double)previous.y * Math.cos(Math.toRadians(90.0)));
        return point;
    }

    public static ArrayList<double[]> convertToPoints(double angle, String system, int generations) {
        int rotation = generations % 2 == 0 ? 2 : 4;
        double[] currentState = new double[]{(generations + rotation) % 4 * 90, 0.0, 0.0};
        ArrayList<double[]> output = new ArrayList<double[]>();
        ArrayDeque<Object> state = new ArrayDeque<Object>();
        char[] cArray = system.toCharArray();
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            Character ch = Character.valueOf(cArray[i]);
            double motion = 1.0;
            if (ch.charValue() == 'F') {
                currentState[1] = currentState[1] - Math.cos(Math.toRadians(currentState[0])) * motion;
                currentState[2] = currentState[2] - Math.sin(Math.toRadians(currentState[0])) * motion;
                output.add(new double[]{currentState[1], currentState[2]});
            }
            if (ch.charValue() == '[') {
                state.push(currentState.clone());
            }
            if (ch.charValue() == '-') {
                currentState = new double[]{(currentState[0] - angle) % 360.0, currentState[1], currentState[2]};
            }
            if (ch.charValue() == '+') {
                currentState[0] = (currentState[0] + angle) % 360.0;
            }
            if (ch.charValue() != ']') continue;
            currentState = (double[])state.pop();
        }
        return output;
    }

    public static String generate(String start, int steps, HashMap<String, String> lSystemsRule) {
        while (steps > 0) {
            StringBuilder output = new StringBuilder();
            char[] cArray = start.toCharArray();
            int n = cArray.length;
            for (int i = 0; i < n; ++i) {
                Character ch = Character.valueOf(cArray[i]);
                String data = lSystemsRule.get(ch.toString());
                if (data == null) {
                    data = ch.toString();
                }
                output.append(data);
            }
            --steps;
            start = output.toString();
        }
        return start;
    }

    public static ArrayList<Point> tesselate(List<Point> polygon) {
        ArrayList<Point> points = new ArrayList<Point>();
        ArrayList<PolygonPoint> polyPoints = new ArrayList<PolygonPoint>();
        for (Point p : polygon) {
            polyPoints.add(new PolygonPoint(p.x, p.y));
        }
        Polygon poly = new Polygon(polyPoints);
        Poly2Tri.triangulate(poly);
        ArrayList tris = (ArrayList)poly.getTriangles();
        for (DelaunayTriangle tri : tris) {
            for (TriangulationPoint tpoint : tri.points) {
                points.add(new Point((int)tpoint.getX(), (int)tpoint.getY()));
            }
        }
        return points;
    }

    static {
        LSystem.generateLSystem("terdragon", TERDRAGON, 4);
        LSystem.generateLSystem("terdragon", TERDRAGON, 5);
        LSystem.generateLSystem("terdragon", TERDRAGON, 7);
        LSystem.generateLSystem("vortex", VORTEX, 9);
        LSystem.generateLSystem("vortex", VORTEX, 10);
        LSystem.generateLSystem("vortex", VORTEX, 11);
        LSystem.generateLSystem("twindragon", TWINDRAGON, 7);
        LSystem.generateLSystem("twindragon", TWINDRAGON, 8);
        LSystem.generateLSystem("twindragon", TWINDRAGON, 9);
        LSystem.generateLSystem("twindragon", TWINDRAGON, 10);
        LSystem.generateLSystem("dragon", DRAGON, 8);
        LSystem.generateLSystem("dragon", DRAGON, 9);
        LSystem.generateLSystem("dragon", DRAGON, 10);
        LSystem.generateLSystem("dragon", DRAGON, 11);
    }

    public static class PolygonInfo {
        public final ArrayList<Point> points;
        public int maxX;
        public final int maxY;
        public final int minX;
        public final int minY;

        public PolygonInfo(ArrayList<Point> points) {
            int maxY = 0;
            int maxX = 0;
            int minY = 0;
            int minX = 0;
            this.points = points;
            if (points.size() > 0) {
                Point firstPoint = points.get(0);
                minX = firstPoint.x;
                minY = firstPoint.y;
                maxX = firstPoint.x;
                maxY = firstPoint.y;
                for (Point point : points) {
                    if (point.x < minX) {
                        minX = point.x;
                    }
                    if (point.y < minY) {
                        minY = point.y;
                    }
                    if (point.x > maxX) {
                        maxX = point.x;
                    }
                    if (point.y <= maxY) continue;
                    maxY = point.y;
                }
            }
            this.minX = minX;
            this.minY = minY;
            this.maxX = maxX;
            this.maxY = maxY;
        }
    }
}

