/*
 * Decompiled with CFR 0.152.
 */
package p455w0rd.danknull.integration;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mezz.jei.JustEnoughItems;
import mezz.jei.api.IJeiRuntime;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.ISubtypeRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.gui.IGuiIngredient;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredientBlacklist;
import mezz.jei.api.ingredients.IModIngredientRegistration;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandlerHelper;
import mezz.jei.config.ServerInfo;
import mezz.jei.network.packets.PacketJei;
import mezz.jei.startup.StackHelper;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ContainerWorkbench;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.translation.I18n;
import p455w0rd.danknull.DankNull;
import p455w0rd.danknull.container.ContainerDankNullItem;
import p455w0rd.danknull.init.ModBlocks;
import p455w0rd.danknull.init.ModItems;
import p455w0rd.danknull.integration.jei.DankNullUpgradeWrapper;
import p455w0rd.danknull.integration.jei.PacketVanllaRecipeTransfer;
import p455w0rd.danknull.inventory.PlayerSlot;
import p455w0rd.danknull.items.ItemDankNull;
import p455w0rd.danknull.recipes.RecipeDankNullUpgrade;
import p455w0rdslib.LibGlobals;

@JEIPlugin
public class JEI
implements IModPlugin {
    public static IIngredientBlacklist blacklist;

    public static void blacklistItem(ItemStack stack) {
        if (LibGlobals.Mods.JEI.isLoaded() && blacklist != null && !JEI.isItemBlacklisted(stack)) {
            blacklist.addIngredientToBlacklist((Object)stack);
        }
    }

    public static boolean isItemBlacklisted(ItemStack stack) {
        if (LibGlobals.Mods.JEI.isLoaded()) {
            return blacklist.isIngredientBlacklisted((Object)stack);
        }
        return false;
    }

    public static void whitelistItem(ItemStack stack) {
        if (LibGlobals.Mods.JEI.isLoaded() && JEI.isItemBlacklisted(stack)) {
            blacklist.removeIngredientFromBlacklist((Object)stack);
        }
    }

    public static void handleItemBlacklisting(ItemStack stack, boolean shouldBlacklist) {
        if (shouldBlacklist) {
            if (!JEI.isItemBlacklisted(stack)) {
                JEI.blacklistItem(stack);
            }
            return;
        }
        if (JEI.isItemBlacklisted(stack)) {
            JEI.whitelistItem(stack);
        }
    }

    public void register(@Nonnull IModRegistry registry) {
        blacklist = registry.getJeiHelpers().getIngredientBlacklist();
        ArrayList<ItemStack> dankNulls = new ArrayList<ItemStack>();
        dankNulls.addAll(Arrays.asList(new ItemStack((Item)ModItems.REDSTONE_DANKNULL), new ItemStack((Item)ModItems.LAPIS_DANKNULL), new ItemStack((Item)ModItems.IRON_DANKNULL), new ItemStack((Item)ModItems.GOLD_DANKNULL), new ItemStack((Item)ModItems.DIAMOND_DANKNULL), new ItemStack((Item)ModItems.EMERALD_DANKNULL)));
        registry.addIngredientInfo(dankNulls, VanillaTypes.ITEM, new String[]{"jei.danknull.desc"});
        registry.addIngredientInfo((Object)new ItemStack((Item)ModItems.REDSTONE_DANKNULL), VanillaTypes.ITEM, new String[]{"jei.danknull.desc0"});
        registry.addIngredientInfo((Object)new ItemStack((Item)ModItems.LAPIS_DANKNULL), VanillaTypes.ITEM, new String[]{"jei.danknull.desc1"});
        registry.addIngredientInfo((Object)new ItemStack((Item)ModItems.IRON_DANKNULL), VanillaTypes.ITEM, new String[]{"jei.danknull.desc2"});
        registry.addIngredientInfo((Object)new ItemStack((Item)ModItems.GOLD_DANKNULL), VanillaTypes.ITEM, new String[]{"jei.danknull.desc3"});
        registry.addIngredientInfo((Object)new ItemStack((Item)ModItems.DIAMOND_DANKNULL), VanillaTypes.ITEM, new String[]{"jei.danknull.desc4"});
        registry.addIngredientInfo((Object)new ItemStack((Item)ModItems.EMERALD_DANKNULL), VanillaTypes.ITEM, new String[]{"jei.danknull.desc5"});
        registry.addIngredientInfo((Object)new ItemStack((Block)ModBlocks.DANKNULL_DOCK), VanillaTypes.ITEM, new String[]{"jei.danknull_dock.desc"});
        registry.handleRecipes(RecipeDankNullUpgrade.class, recipe -> new DankNullUpgradeWrapper(registry.getJeiHelpers(), (RecipeDankNullUpgrade)((Object)recipe)), "minecraft.crafting");
    }

    public void onRuntimeAvailable(IJeiRuntime runtime) {
    }

    public void registerIngredients(IModIngredientRegistration registry) {
    }

    public void registerItemSubtypes(ISubtypeRegistry registry) {
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
    }

    public static final class VanillaRecipeTransferHandlerServer {
        public static void setItems(EntityPlayer player, Map<Integer, ItemStack> slotIdMap, List<Integer> craftingSlots, List<Integer> inventorySlots, boolean maxTransfer) {
            Container container = player.field_71070_bA;
            HashMap slotMap = new HashMap(slotIdMap.size());
            HashMap slotMapReverse = new HashMap(slotIdMap.size());
            for (Map.Entry<Integer, ItemStack> entry : slotIdMap.entrySet()) {
                Slot slot = container.func_75139_a(entry.getKey().intValue());
                ItemStack slotStack = slot.func_75211_c();
                if (slotStack.func_190926_b()) continue;
                ItemStack itemStack = slotStack.func_77946_l();
                itemStack.func_190920_e(1);
                slotMap.put(entry.getKey(), itemStack);
                slotMapReverse.put(itemStack, entry.getKey());
            }
            int maxRemovedSets = maxTransfer ? 64 : 1;
            for (Map.Entry entry : slotMap.entrySet()) {
                ItemStack stack = (ItemStack)entry.getValue();
                if (stack.func_77985_e()) {
                    Integer n = (Integer)entry.getKey();
                    Integer slotNumber = craftingSlots.get(n);
                    Slot craftSlot = container.func_75139_a(slotNumber.intValue());
                    int maxStackSize = Math.min(craftSlot.func_178170_b(stack), stack.func_77976_d());
                    maxRemovedSets = Math.min(maxRemovedSets, maxStackSize);
                    continue;
                }
                maxRemovedSets = 1;
            }
            boolean needsDankNull = false;
            if (slotMap.isEmpty()) {
                List<PlayerSlot> list = ItemDankNull.getDankNullsForPlayer(player);
                for (PlayerSlot playerSlot : list) {
                    needsDankNull = true;
                    ++maxRemovedSets;
                }
            }
            if (maxRemovedSets <= 0) {
                return;
            }
            if (!VanillaRecipeTransferHandlerServer.removeSetsFromInventory(container, slotIdMap.values(), craftingSlots, inventorySlots)) {
                return;
            }
            ArrayList<ItemStack> arrayList = new ArrayList<ItemStack>();
            for (Integer n : craftingSlots) {
                Slot craftingSlot = container.func_75139_a(n.intValue());
                if (!craftingSlot.func_75216_d()) continue;
                ItemStack craftingItem = craftingSlot.func_75209_a(Integer.MAX_VALUE);
                arrayList.add(craftingItem);
            }
            for (Map.Entry entry : slotIdMap.entrySet()) {
                Integer craftNumber = (Integer)entry.getKey() - 1;
                Integer slotNumber = craftingSlots.get(craftNumber);
                Slot slot = container.func_75139_a(slotNumber.intValue());
                ItemStack stack = (ItemStack)entry.getValue();
                if (stack.func_190926_b()) continue;
                stack.func_190920_e(stack.func_190916_E() * 1);
                if (slot.func_75214_a(stack)) {
                    slot.func_75215_d(stack);
                    continue;
                }
                arrayList.add(stack);
            }
            if (needsDankNull) {
                // empty if block
            }
            for (ItemStack itemStack : arrayList) {
                int added = VanillaRecipeTransferHandlerServer.addStack(container, inventorySlots, itemStack);
                if (added >= itemStack.func_190916_E() || player.field_71071_by.func_70441_a(itemStack)) continue;
                player.func_71019_a(itemStack, false);
            }
            if (container instanceof ContainerDankNullItem) {
                container.func_75142_b();
            }
        }

        public static void setItems(EntityPlayer player, Map<Integer, ItemStack> recipe, boolean maxTransfer) {
            Container container = player.field_71070_bA;
            HashMap recipeSlotsStatus = Maps.newHashMap();
            ArrayList craftingSlotNumbers = Lists.newArrayList((Object[])new Integer[]{1, 2, 3, 4, 5, 6, 7, 8, 9});
            ArrayList inventorySlotNumbers = Lists.newArrayList();
            for (int i = 10; i < 46; ++i) {
                inventorySlotNumbers.add(i);
            }
            ArrayList<ItemStack> clearedCraftingItems = new ArrayList<ItemStack>();
            for (Integer craftingSlotNumber : craftingSlotNumbers) {
                Slot slot = container.func_75139_a(craftingSlotNumber.intValue());
                if (!slot.func_75216_d()) continue;
                ItemStack itemStack = slot.func_75211_c().func_77946_l();
                clearedCraftingItems.add(itemStack);
                slot.func_75215_d(ItemStack.field_190927_a);
            }
            for (ItemStack oldCraftingItem : clearedCraftingItems) {
                if (player.field_71071_by.func_70441_a(oldCraftingItem)) continue;
                player.func_71019_a(oldCraftingItem, false);
            }
            for (int i = 0; i < inventorySlotNumbers.size(); ++i) {
                Slot slot = container.func_75139_a(((Integer)inventorySlotNumbers.get(i)).intValue());
                if (!slot.func_75216_d()) continue;
                for (Map.Entry<Integer, ItemStack> entry : recipe.entrySet()) {
                    if (recipeSlotsStatus.containsKey(entry.getKey())) continue;
                    if (entry.getValue().func_190926_b()) {
                        recipeSlotsStatus.put(entry.getKey(), ItemStack.field_190927_a);
                        continue;
                    }
                    if (!ItemStack.func_179545_c((ItemStack)slot.func_75211_c(), (ItemStack)entry.getValue()) || !ItemStack.func_77970_a((ItemStack)slot.func_75211_c(), (ItemStack)entry.getValue())) continue;
                    recipeSlotsStatus.put(entry.getKey(), entry.getValue());
                    slot.func_75211_c().func_190918_g(entry.getValue().func_190916_E());
                }
            }
            boolean recipeIsFulfilled = true;
            for (Map.Entry entry : recipe.entrySet()) {
                if (recipeSlotsStatus.containsKey(entry.getKey()) && ItemStack.func_179545_c((ItemStack)((ItemStack)recipeSlotsStatus.get(entry.getKey())), (ItemStack)((ItemStack)entry.getValue())) && ItemStack.func_77970_a((ItemStack)((ItemStack)recipeSlotsStatus.get(entry.getKey())), (ItemStack)((ItemStack)entry.getValue()))) continue;
                recipeIsFulfilled = false;
            }
            if (!recipeIsFulfilled) {
                for (int i = 0; i < inventorySlotNumbers.size(); ++i) {
                }
            }
            for (Map.Entry<Integer, ItemStack> entry : recipe.entrySet()) {
                Integer n = entry.getKey() - 1;
                Integer slotNumber = (Integer)Lists.newArrayList((Object[])new Integer[]{1, 2, 3, 4, 5, 6, 7, 8, 9}).get(n);
                Slot slot = container.func_75139_a(slotNumber.intValue());
                ItemStack stack = entry.getValue();
                if (stack.func_190926_b()) continue;
                stack.func_190920_e(stack.func_190916_E() * 1);
                if (slot.func_75214_a(stack)) {
                    slot.func_75215_d(stack);
                    continue;
                }
                clearedCraftingItems.add(stack);
            }
            container.func_75142_b();
        }

        private static int removeSetsFromInventory(Container container, Collection<ItemStack> required, List<Integer> craftingSlots, List<Integer> inventorySlots, int maxRemovedSets) {
            int removedSets = 0;
            while (removedSets < maxRemovedSets) {
                if (!VanillaRecipeTransferHandlerServer.removeSetsFromInventory(container, required, craftingSlots, inventorySlots)) continue;
                ++removedSets;
            }
            return removedSets;
        }

        private static boolean removeSetsFromInventory(Container container, Iterable<ItemStack> required, List<Integer> craftingSlots, List<Integer> inventorySlots) {
            HashMap<Slot, ItemStack> originalSlotContents = new HashMap<Slot, ItemStack>();
            for (ItemStack matchingStack : required) {
                ItemStack requiredStack;
                if (matchingStack.func_190926_b() || (requiredStack = matchingStack.func_77946_l()).func_190926_b()) continue;
                Slot slot = VanillaRecipeTransferHandlerServer.getSlotWithStack(container, requiredStack, craftingSlots, inventorySlots);
                boolean tryDankNull = false;
                if (slot == null || slot.func_75211_c().func_190926_b()) {
                    for (Map.Entry slotEntry : originalSlotContents.entrySet()) {
                        ItemStack stack = (ItemStack)slotEntry.getValue();
                        ((Slot)slotEntry.getKey()).func_75215_d(stack);
                    }
                    tryDankNull = true;
                }
                if (!tryDankNull) {
                    if (!originalSlotContents.containsKey(slot)) {
                        originalSlotContents.put(slot, slot.func_75211_c().func_77946_l());
                    }
                    ItemStack removed = slot.func_75209_a(requiredStack.func_190916_E());
                    requiredStack.func_190918_g(removed.func_190916_E());
                    continue;
                }
                Iterator<Object> iterator = inventorySlots.iterator();
                while (iterator.hasNext()) {
                    int slotNum = (Integer)iterator.next();
                    Slot slot1 = container.func_75139_a(slotNum);
                    if (slot1 != null && !slot1.func_75216_d()) continue;
                }
            }
            return true;
        }

        @Nullable
        private static Slot getSlotWithStack(Container container, ItemStack stack, List<Integer> craftingSlots, List<Integer> inventorySlots) {
            Slot slot = VanillaRecipeTransferHandlerServer.getSlotWithStack(container, craftingSlots, stack);
            if (slot == null) {
                slot = VanillaRecipeTransferHandlerServer.getSlotWithStack(container, inventorySlots, stack);
            }
            return slot;
        }

        private static int addStack(Container container, Collection<Integer> slotIndexes, ItemStack stack) {
            Slot slot;
            boolean added = false;
            for (Integer slotIndex : slotIndexes) {
                if (slotIndex < 0 || slotIndex >= container.field_75151_b.size()) continue;
                slot = container.func_75139_a(slotIndex.intValue());
                ItemStack itemStack = slot.func_75211_c();
            }
            if (0 >= stack.func_190916_E()) {
                return 0;
            }
            for (Integer slotIndex : slotIndexes) {
                ItemStack inventoryStack;
                if (slotIndex < 0 || slotIndex >= container.field_75151_b.size() || !(inventoryStack = (slot = container.func_75139_a(slotIndex.intValue())).func_75211_c()).func_190926_b()) continue;
                ItemStack stackToAdd = stack.func_77946_l();
                stackToAdd.func_190920_e(stack.func_190916_E() - 0);
                slot.func_75215_d(stackToAdd);
                return stack.func_190916_E();
            }
            return 0;
        }

        @Nullable
        private static Slot getSlotWithStack(Container container, Iterable<Integer> slotNumbers, ItemStack itemStack) {
            for (Integer slotNumber : slotNumbers) {
                Slot slot;
                ItemStack slotStack;
                if (slotNumber < 0 || slotNumber >= container.field_75151_b.size() || !ItemStack.func_179545_c((ItemStack)itemStack, (ItemStack)(slotStack = (slot = container.func_75139_a(slotNumber.intValue())).func_75211_c())) || !ItemStack.func_77970_a((ItemStack)itemStack, (ItemStack)slotStack)) continue;
                return slot;
            }
            return null;
        }
    }

    public static class VanillaRecipeTransferHandler
    implements IRecipeTransferHandler<ContainerWorkbench> {
        private final StackHelper stackHelper;
        private final IRecipeTransferHandlerHelper handlerHelper;

        public VanillaRecipeTransferHandler(StackHelper stackHelper, IRecipeTransferHandlerHelper handlerHelper) {
            this.stackHelper = stackHelper;
            this.handlerHelper = handlerHelper;
        }

        public Class<ContainerWorkbench> getContainerClass() {
            return ContainerWorkbench.class;
        }

        public IRecipeTransferError transferRecipe(ContainerWorkbench container, IRecipeLayout recipeLayout, EntityPlayer player, boolean maxTransfer, boolean doTransfer) {
            ItemStack stack;
            if (!ServerInfo.isJeiOnServer()) {
                String tooltipMessage = I18n.func_74838_a((String)"jei.tooltip.error.recipe.transfer.no.server");
                return this.handlerHelper.createUserErrorWithTooltip(tooltipMessage);
            }
            ArrayList dankNullStacks = Lists.newArrayList();
            HashMap<Integer, Slot> inventorySlots = new HashMap<Integer, Slot>();
            for (int i = 10; i < 46; ++i) {
                Slot slot = container.func_75139_a(i);
                inventorySlots.put(slot.field_75222_d, slot);
                if (!slot.func_75216_d() || !ItemDankNull.isDankNull(slot.func_75211_c())) continue;
                dankNullStacks.add(slot.func_75211_c());
            }
            HashMap<Integer, Slot> craftingSlots = new HashMap<Integer, Slot>();
            for (int i = 1; i < 10; ++i) {
                Slot slot = container.func_75139_a(i);
                craftingSlots.put(slot.field_75222_d, slot);
            }
            int inputCount = 0;
            IGuiItemStackGroup itemStackGroup = recipeLayout.getItemStacks();
            for (IGuiIngredient ingredient : itemStackGroup.getGuiIngredients().values()) {
                if (!ingredient.isInput() || ingredient.getAllIngredients().isEmpty()) continue;
                ++inputCount;
            }
            if (inputCount > craftingSlots.size()) {
                DankNull.LOGGER.error(String.format("Error transferring recipe for container {%s}", container.getClass()));
                return this.handlerHelper.createInternalError();
            }
            HashMap<Integer, ItemStack> availableItemStacks = new HashMap<Integer, ItemStack>();
            int filledCraftSlotCount = 0;
            int emptySlotCount = 0;
            for (Slot slot : craftingSlots.values()) {
                stack = slot.func_75211_c();
                if (stack.func_190926_b()) continue;
                if (!slot.func_82869_a(player)) {
                    DankNull.LOGGER.error(String.format("Error transferring recipe for container {%s}. Player can't move item out of Crafting Slot number {%d}", container.getClass(), slot.field_75222_d));
                    return this.handlerHelper.createInternalError();
                }
                ++filledCraftSlotCount;
                availableItemStacks.put(slot.field_75222_d, stack.func_77946_l());
            }
            for (Slot slot : inventorySlots.values()) {
                stack = slot.func_75211_c();
                if (!stack.func_190926_b()) {
                    availableItemStacks.put(slot.field_75222_d, stack.func_77946_l());
                    continue;
                }
                ++emptySlotCount;
            }
            if (filledCraftSlotCount - inputCount > emptySlotCount) {
                String message = I18n.func_74838_a((String)"jei.tooltip.error.recipe.transfer.inventory.full");
                return this.handlerHelper.createUserErrorWithTooltip(message);
            }
            StackHelper.MatchingItemsResult matchingItemsResult = this.stackHelper.getMatchingItems(availableItemStacks, itemStackGroup.getGuiIngredients());
            HashMap recipe = Maps.newHashMap();
            for (int i = 1; i < itemStackGroup.getGuiIngredients().size(); ++i) {
                int slotNum = (Integer)itemStackGroup.getGuiIngredients().keySet().toArray()[i];
                recipe.put(slotNum, ((IGuiIngredient)itemStackGroup.getGuiIngredients().get(slotNum)).getDisplayedIngredient());
            }
            boolean matchingDankNulls = false;
            boolean foundInDankNull = false;
            if (matchingItemsResult.missingItems.size() > 0) {
                for (IGuiIngredient filteredIngredient : itemStackGroup.getGuiIngredients().values()) {
                    ItemStack itemStack = (ItemStack)filteredIngredient.getDisplayedIngredient();
                }
                String message = I18n.func_74838_a((String)"jei.tooltip.error.recipe.transfer.missing");
                return this.handlerHelper.createUserErrorForSlots(message, (Collection)matchingItemsResult.missingItems);
            }
            ArrayList craftingSlotIndexes = new ArrayList(craftingSlots.keySet());
            Collections.sort(craftingSlotIndexes);
            ArrayList inventorySlotIndexes = new ArrayList(inventorySlots.keySet());
            Collections.sort(inventorySlotIndexes);
            for (Map.Entry entry : matchingItemsResult.matchingItems.entrySet()) {
                int craftNumber = (Integer)entry.getKey();
                int slotNumber = (Integer)craftingSlotIndexes.get(craftNumber);
                if (slotNumber >= 0 && slotNumber < container.field_75151_b.size()) continue;
                DankNull.LOGGER.error(String.format("Slot {%d} outside of the inventory's size {%d}", slotNumber, container.field_75151_b.size()));
                return this.handlerHelper.createInternalError();
            }
            if (doTransfer) {
                PacketVanllaRecipeTransfer packet = new PacketVanllaRecipeTransfer(recipe, maxTransfer);
                JustEnoughItems.getProxy().sendPacketToServer((PacketJei)packet);
            }
            return null;
        }
    }
}

