/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.item.tiletransporter;

import com.lothrazar.cyclicmagic.ModCyclic;
import com.lothrazar.cyclicmagic.item.tiletransporter.ItemChestSackEmpty;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IThreadListener;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketChestSack
implements IMessage,
IMessageHandler<PacketChestSack, IMessage> {
    private BlockPos pos;

    public PacketChestSack() {
    }

    public PacketChestSack(BlockPos mouseover) {
        this.pos = mouseover;
    }

    public void fromBytes(ByteBuf buf) {
        NBTTagCompound tags = ByteBufUtils.readTag((ByteBuf)buf);
        int x = tags.func_74762_e("x");
        int y = tags.func_74762_e("y");
        int z = tags.func_74762_e("z");
        this.pos = new BlockPos(x, y, z);
    }

    public void toBytes(ByteBuf buf) {
        NBTTagCompound tags = new NBTTagCompound();
        tags.func_74768_a("x", this.pos.func_177958_n());
        tags.func_74768_a("y", this.pos.func_177956_o());
        tags.func_74768_a("z", this.pos.func_177952_p());
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)tags);
    }

    public IMessage onMessage(PacketChestSack message, MessageContext ctx) {
        PacketChestSack.checkThreadAndEnqueue(message, ctx);
        return null;
    }

    private static void checkThreadAndEnqueue(final PacketChestSack message, final MessageContext ctx) {
        if (ctx.side.isServer() && message != null && message.pos != null) {
            IThreadListener thread = ModCyclic.proxy.getThreadFromContext(ctx);
            thread.func_152344_a(new Runnable(){

                @Override
                public void run() {
                    BlockPos position = message.pos;
                    EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
                    World world = player.func_130014_f_();
                    TileEntity tile = world.func_175625_s(position);
                    ItemChestSackEmpty.gatherTileEntity(position, (EntityPlayer)player, world, tile);
                }
            });
        }
    }
}

