/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.block.tank;

import com.lothrazar.cyclicmagic.block.tank.FluidHandler;
import com.lothrazar.cyclicmagic.util.UtilChat;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemBlockFluidTank
extends ItemBlock {
    public ItemBlockFluidTank(Block block) {
        super(block);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        FluidStack fstack = ItemBlockFluidTank.copyFluidFromStack(stack);
        return fstack != null && fstack.amount > 0;
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        return 11393254;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        try {
            FluidStack fstack = ItemBlockFluidTank.copyFluidFromStack(stack);
            float qty = fstack.amount;
            float ratio = qty / 64000.0f;
            return 1.0f - ratio;
        }
        catch (Throwable throwable) {
            return 1.0;
        }
    }

    public static FluidStack copyFluidFromStack(ItemStack stack) {
        if (stack.func_77978_p() != null) {
            FluidHandler handler = new FluidHandler(stack);
            FluidStack fstack = handler.getFluid();
            if (fstack == null) {
                return null;
            }
            return handler.getFluid();
        }
        return null;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable NBTTagCompound nbt) {
        return new FluidHandler(stack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack item, World player, List<String> tooltip, ITooltipFlag advanced) {
        FluidStack fstack = ItemBlockFluidTank.copyFluidFromStack(item);
        if (fstack != null && fstack.amount > 0) {
            int amt = fstack.amount;
            String rsc = fstack.getLocalizedName();
            tooltip.add(amt + " " + rsc);
        } else {
            tooltip.add(UtilChat.lang("tile.block_storeempty.tooltip"));
        }
    }
}

