/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.block.peat.farm;

import com.lothrazar.cyclicmagic.block.core.TileEntityBaseMachineFluid;
import com.lothrazar.cyclicmagic.block.peat.farm.BlockPeatFarm;
import com.lothrazar.cyclicmagic.capability.EnergyStore;
import com.lothrazar.cyclicmagic.data.ITileRedstoneToggle;
import com.lothrazar.cyclicmagic.liquid.FluidTankFixDesync;
import com.lothrazar.cyclicmagic.util.UtilShape;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class TileEntityPeatFarm
extends TileEntityBaseMachineFluid
implements ITileRedstoneToggle,
ITickable,
IFluidHandler {
    public static final int TANK_FULL = 20000;
    public static final int TIMER_FULL = 5;
    private int needsRedstone = 1;
    private int blockPointer = 0;
    Block baked = null;
    Block unbaked = null;
    List<BlockPos> outer = null;

    public TileEntityPeatFarm() {
        super(12);
        this.tank = new FluidTankFixDesync(20000, this);
        this.tank.setFluidAllowed(FluidRegistry.WATER);
        this.initEnergy(new EnergyStore(64000, 64000, 64000), 0);
        this.timer = 5;
        this.setSlotsForInsert(0, this.func_70302_i_());
    }

    private void init() {
        if (this.baked == null) {
            this.baked = Block.func_149684_b((String)"cyclicmagic:peat_baked");
        }
        if (this.unbaked == null) {
            this.unbaked = Block.func_149684_b((String)"cyclicmagic:peat_unbaked");
        }
        if (this.outer == null) {
            this.outer = this.getShape();
            List<BlockPos> waterShape = UtilShape.squareHorizontalHollow(this.field_174879_c, 6);
            this.outer.addAll(waterShape);
        }
    }

    @Override
    public boolean func_94041_b(int index, ItemStack stack) {
        return Block.func_149634_a((Item)stack.func_77973_b()) == this.unbaked;
    }

    public void func_73660_a() {
        this.init();
        if (!this.isRunning()) {
            this.blockPointer = 0;
            return;
        }
        this.energyStorage.extractEnergy(BlockPeatFarm.FUEL_COST, false);
        if (this.energyStorage.getEnergyStored() == 0) {
            return;
        }
        --this.timer;
        if (this.timer > 0) {
            return;
        }
        if (this.blockPointer < this.outer.size()) {
            boolean placeWater;
            BlockPos target = this.outer.get(this.blockPointer);
            boolean bl = placeWater = (target.func_177958_n() - this.field_174879_c.func_177958_n()) % 3 == 0 && (target.func_177952_p() - this.field_174879_c.func_177952_p()) % 3 == 0;
            if (placeWater) {
                this.tryPlaceWater(target);
            } else {
                this.tryPlacePeat(target);
            }
            this.timer = 5;
            ++this.blockPointer;
        } else {
            this.blockPointer = 0;
        }
    }

    private void tryPlacePeat(BlockPos target) {
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            if (!this.func_70301_a(i).func_77969_a(new ItemStack(this.unbaked))) continue;
            this.tryHarvest(target);
            if (!this.field_145850_b.func_180495_p(target).func_177230_c().func_176200_f((IBlockAccess)this.field_145850_b, target)) continue;
            this.field_145850_b.func_175656_a(target, this.unbaked.func_176223_P());
            this.decrStackSize(i);
            return;
        }
    }

    private void tryPlaceWater(BlockPos target) {
        if (this.field_145850_b.func_180495_p(target).func_177230_c().func_176200_f((IBlockAccess)this.field_145850_b, target) && this.tank.getFluidAmount() >= 1000 && this.tank.drain(1000, true) != null) {
            this.tank.drain(1000, false);
            this.field_145850_b.func_175656_a(target, Blocks.field_150358_i.func_176223_P());
        }
    }

    private void tryHarvest(BlockPos target) {
        if (this.field_145850_b.func_180495_p(target).func_177230_c() == this.baked) {
            this.field_145850_b.func_175655_b(target, true);
        }
    }

    private List<BlockPos> getShape() {
        List<BlockPos> outer = UtilShape.squareHorizontalHollow(this.field_174879_c, 7);
        outer.addAll(UtilShape.squareHorizontalHollow(this.field_174879_c, 5));
        return outer;
    }

    @Override
    public int[] getFieldOrdinals() {
        return super.getFieldArray(Fields.values().length);
    }

    @Override
    public int func_174890_g() {
        return this.getFieldOrdinals().length;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.needsRedstone = compound.func_74762_e("redstone");
        this.blockPointer = compound.func_74762_e("blockPointer");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74768_a("redstone", this.needsRedstone);
        compound.func_74768_a("blockPointer", this.blockPointer);
        return super.func_189515_b(compound);
    }

    @Override
    public void toggleNeedsRedstone() {
        int val = this.needsRedstone + 1;
        if (val > 1) {
            val = 0;
        }
        this.func_174885_b(Fields.REDSTONE.ordinal(), val);
    }

    @Override
    public boolean onlyRunIfPowered() {
        return this.needsRedstone == 1;
    }

    @Override
    public int func_174887_a_(int id) {
        switch (Fields.values()[id]) {
            case REDSTONE: {
                return this.needsRedstone;
            }
            case TIMER: {
                return this.timer;
            }
        }
        return -1;
    }

    @Override
    public void func_174885_b(int id, int value) {
        switch (Fields.values()[id]) {
            case REDSTONE: {
                this.needsRedstone = value;
                break;
            }
            case TIMER: {
                this.timer = value;
            }
        }
    }

    public static enum Fields {
        REDSTONE,
        TIMER;

    }
}

