/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.block.core;

import com.lothrazar.cyclicmagic.ModCyclic;
import com.lothrazar.cyclicmagic.block.core.BlockBaseFacing;
import com.lothrazar.cyclicmagic.block.core.BlockBaseHasTile;
import com.lothrazar.cyclicmagic.module.MultiContent;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public abstract class BlockBaseFacingOmni
extends BlockBaseHasTile {
    public static final PropertyDirection PROPERTYFACING = BlockDirectional.field_176387_N;
    public PlacementType placeType = PlacementType.PLAYER_FACING;

    public BlockBaseFacingOmni(Material materialIn) {
        super(materialIn);
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)PROPERTYFACING, (Comparable)EnumFacing.func_82600_a((int)(meta & 7)));
    }

    public EnumFacing getFacingFromState(IBlockState state) {
        EnumFacing facing = EnumFacing.NORTH;
        try {
            if (state != null && state.func_177230_c() instanceof BlockBaseFacing) {
                facing = ((EnumFacing)state.func_177229_b((IProperty)PROPERTYFACING)).func_176734_d();
            }
        }
        catch (Exception e) {
            ModCyclic.logger.error("Could not get EnumFacing ", e);
        }
        return facing;
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)PROPERTYFACING)).func_176745_a();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{PROPERTYFACING});
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing blockFaceClickedOn, float hitX, float hitY, float hitZ, int meta, @Nullable EntityLivingBase placer) {
        if (pos == null || placer == null) {
            return this.func_176223_P().func_177226_a((IProperty)PROPERTYFACING, (Comparable)EnumFacing.UP);
        }
        EnumFacing fac = null;
        switch (this.placeType) {
            case SIDE_BLOCK: {
                if (blockFaceClickedOn.func_176740_k() == EnumFacing.Axis.Y) {
                    fac = blockFaceClickedOn;
                    break;
                }
                fac = blockFaceClickedOn.func_176734_d();
                break;
            }
            default: {
                fac = EnumFacing.func_190914_a((BlockPos)pos, (EntityLivingBase)placer);
            }
        }
        if (fac != EnumFacing.UP && fac != EnumFacing.DOWN && !MultiContent.unInvertedPlacement) {
            fac = fac.func_176734_d();
        }
        return this.func_176223_P().func_177226_a((IProperty)PROPERTYFACING, (Comparable)fac);
    }

    public static EnumFacing getCurrentFacing(World world, BlockPos pos) {
        try {
            EnumFacing f = (EnumFacing)world.func_180495_p(pos).func_177229_b((IProperty)PROPERTYFACING);
            if (f != EnumFacing.UP && f != EnumFacing.DOWN) {
                f = f.func_176734_d();
            }
            return f;
        }
        catch (Exception e) {
            return EnumFacing.NORTH;
        }
    }

    public static enum PlacementType {
        PLAYER_FACING,
        SIDE_BLOCK;

    }
}

