/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.network.message;

import io.netty.buffer.ByteBuf;
import net.blay09.mods.cookingforblockheads.registry.RecipeType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class MessageCraftRecipe
implements IMessage {
    private ItemStack outputItem;
    private RecipeType recipeType;
    private NonNullList<ItemStack> craftMatrix;
    private boolean stack;

    public MessageCraftRecipe() {
    }

    public MessageCraftRecipe(ItemStack outputItem, RecipeType recipeType, NonNullList<ItemStack> craftMatrix, boolean stack) {
        this.outputItem = outputItem;
        this.recipeType = recipeType;
        this.craftMatrix = craftMatrix;
        this.stack = stack;
    }

    public void fromBytes(ByteBuf buf) {
        this.outputItem = ByteBufUtils.readItemStack((ByteBuf)buf);
        this.recipeType = RecipeType.fromId(buf.readByte());
        int ingredientCount = buf.readByte();
        this.craftMatrix = NonNullList.func_191196_a();
        for (int i = 0; i < ingredientCount; ++i) {
            this.craftMatrix.add((Object)ByteBufUtils.readItemStack((ByteBuf)buf));
        }
        this.stack = buf.readBoolean();
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.outputItem);
        buf.writeByte(this.recipeType.ordinal());
        buf.writeByte(this.craftMatrix.size());
        for (ItemStack itemstack : this.craftMatrix) {
            ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)itemstack);
        }
        buf.writeBoolean(this.stack);
    }

    public NonNullList<ItemStack> getCraftMatrix() {
        return this.craftMatrix;
    }

    public boolean isStack() {
        return this.stack;
    }

    public RecipeType getRecipeType() {
        return this.recipeType;
    }

    public ItemStack getOutputItem() {
        return this.outputItem;
    }
}

