/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.network.packets.chunkRequest;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import pregenerator.ChunkPregenerator;
import pregenerator.base.api.network.IReadableBuffer;
import pregenerator.base.api.network.IWriteableBuffer;
import pregenerator.base.api.network.PregenPacket;
import pregenerator.impl.network.packets.chunkRequest.EntityAnswerPacket;
import pregenerator.impl.tracking.ChunkEntry;
import pregenerator.impl.tracking.CollectorMap;
import pregenerator.impl.tracking.ServerTracker;
import pregenerator.impl.tracking.WorldTracker;

public class EntityRequestPacket
extends PregenPacket {
    int dim;
    boolean tiles;

    public EntityRequestPacket() {
    }

    public EntityRequestPacket(int dim, boolean tiles) {
        this.dim = dim;
        this.tiles = tiles;
    }

    @Override
    public void read(IReadableBuffer buffer) {
        this.dim = buffer.readInt();
        this.tiles = buffer.readBoolean();
    }

    @Override
    public void write(IWriteableBuffer buffer) {
        buffer.writeInt(this.dim);
        buffer.writeBoolean(this.tiles);
    }

    @Override
    public void handle(final EntityPlayer player) {
        MinecraftServer server = ChunkPregenerator.getServer();
        if (!server.func_152345_ab()) {
            server.func_152344_a(new Runnable(){

                @Override
                public void run() {
                    EntityRequestPacket.this.process(player);
                }
            });
            return;
        }
        this.process(player);
    }

    public void process(EntityPlayer player) {
        WorldTracker tracker = ServerTracker.INSTANCE.getWorld(this.dim);
        if (tracker == null) {
            EntityAnswerPacket answer = new EntityAnswerPacket(this.tiles);
            answer.setType(-1);
            ChunkPregenerator.networking.sendPacketToPlayer(answer, player);
            return;
        }
        if (this.tiles) {
            List<TileEntity> tileList = tracker.getTileList();
            if (tileList.isEmpty()) {
                EntityAnswerPacket answer = new EntityAnswerPacket(this.tiles);
                answer.setType(-1);
                ChunkPregenerator.networking.sendPacketToPlayer(answer, player);
                return;
            }
            CollectorMap<TileEntity> collect = new CollectorMap<TileEntity>();
            collect.addAll(tileList);
            ArrayList<EntityAnswerPacket> packets = new ArrayList<EntityAnswerPacket>();
            EntityAnswerPacket current = new EntityAnswerPacket(this.tiles);
            int bytesLeft = 30000;
            for (Map.Entry entry : collect.entrySet()) {
                ResourceLocation res = (ResourceLocation)ChunkEntry.registry.func_177774_c(entry.getKey());
                int value = entry.getValue().size();
                if (res == null) continue;
                String s = res.toString();
                int bytes = 8 + s.length() * 2;
                if (bytes >= bytesLeft) {
                    packets.add(current);
                    current = new EntityAnswerPacket(this.tiles);
                    bytesLeft = 30000;
                }
                current.addEntry(s, value);
                bytesLeft -= bytes;
            }
            if (current.hasData()) {
                packets.add(current);
            }
            for (int i = 0; i < packets.size(); ++i) {
                EntityAnswerPacket packet = (EntityAnswerPacket)packets.get(i);
                packet.setType(packets.size() - (i + 1));
                ChunkPregenerator.networking.sendPacketToPlayer(packet, player);
            }
        } else {
            List<Entity> tileList = tracker.getEntityList();
            if (tileList.isEmpty()) {
                EntityAnswerPacket answer = new EntityAnswerPacket(this.tiles);
                answer.setType(-1);
                ChunkPregenerator.networking.sendPacketToPlayer(answer, player);
                return;
            }
            CollectorMap<Object> collect = new CollectorMap<Object>();
            collect.addAll(tileList);
            collect.removeAll(EntityPlayer.class);
            if (collect.isEmpty()) {
                EntityAnswerPacket answer = new EntityAnswerPacket(this.tiles);
                answer.setType(-1);
                ChunkPregenerator.networking.sendPacketToPlayer(answer, player);
                return;
            }
            ArrayList<EntityAnswerPacket> packets = new ArrayList<EntityAnswerPacket>();
            EntityAnswerPacket current = new EntityAnswerPacket(this.tiles);
            int bytesLeft = 30000;
            for (Map.Entry entry : collect.entrySet()) {
                ResourceLocation location = EntityList.func_191306_a(entry.getKey());
                String s = location == null ? null : location.toString();
                int value = entry.getValue().size();
                if (s == null) continue;
                int bytes = 8 + s.length() * 2;
                if (bytes >= bytesLeft) {
                    packets.add(current);
                    current = new EntityAnswerPacket(this.tiles);
                    bytesLeft = 30000;
                }
                current.addEntry(s, value);
                bytesLeft -= bytes;
            }
            if (current.hasData()) {
                packets.add(current);
            }
            for (int i = 0; i < packets.size(); ++i) {
                EntityAnswerPacket packet = (EntityAnswerPacket)packets.get(i);
                packet.setType(packets.size() - (i + 1));
                ChunkPregenerator.networking.sendPacketToPlayer(packet, player);
            }
        }
    }
}

