/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.command.structure;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import pregenerator.ChunkPregenerator;
import pregenerator.impl.command.CompleterHelper;
import pregenerator.impl.command.base.BasePregenCommand;
import pregenerator.impl.command.base.CommandContainer;
import pregenerator.impl.misc.FilePos;
import pregenerator.impl.misc.Tuple;
import pregenerator.impl.processor.ChunkCalculator;
import pregenerator.impl.processor.PrepaireProgress;
import pregenerator.impl.processor.deleter.DeleteProcess;
import pregenerator.impl.processor.deleter.IDeletionTask;
import pregenerator.impl.structure.MapGenStructureDataPregen;
import pregenerator.impl.structure.StructureManager;

public class DeleteStructureSubCommand
extends BasePregenCommand {
    public DeleteStructureSubCommand() {
        super(6);
        this.addDescription(0, "Dimension: The Dimension the Structure is in (if not listed its not deleteable)");
        this.addDescription(1, "Type: The Structure that should be deleted (if not listed its not deleteable)");
        this.addDescription(2, "X Block Position: The Ruff X Block Position of the Structure");
        this.addDescription(3, "Z Block Position: The Ruff Z Block Position of the Structure");
        this.addDescription(4, "(Optional) Delete: If the Structure Should be removed from the World");
        this.addSuggestion("deleteStructure 0 Village 0 0", "Deletes the closest Village to 0 0 from the Files but leaves it in the World");
        this.addSuggestion("deleteStructure 0 Village 0 0 delete", "Deletes the closest Village to 0 0 and removes it from the World");
    }

    @Override
    public String getName() {
        return "deleteStructure";
    }

    @Override
    public String getDescription() {
        return "Deletes a Structure and optionally regenerates the Chunks for Complete removal";
    }

    @Override
    public int getRequiredParameterCount() {
        return 4;
    }

    @Override
    public void execute(CommandContainer container, String[] args) {
        if (args.length >= 4) {
            boolean doRemove;
            int dimension = DeleteStructureSubCommand.getDimension(container, args[2]);
            String type = args[3];
            FilePos position = DeleteStructureSubCommand.getBlockPos(args[0], args[1], container.getPlayerPos());
            boolean bl = doRemove = args.length >= 5 ? args[4].equalsIgnoreCase("delete") : false;
            if (!DeleteStructureSubCommand.isDimensionValid(dimension)) {
                container.sendChatMessage("Dimension " + dimension + " is not Registered!");
                return;
            }
            if (!StructureManager.instance.validateType(dimension, type)) {
                container.sendChatMessage("Type: " + type + " doesn't exist in Dimension " + dimension);
                return;
            }
            MapGenStructureDataPregen structure = StructureManager.instance.getStructure(dimension, type);
            if (structure == null) {
                container.sendChatMessage("Structure Manager for " + type + " not Found!");
                return;
            }
            Tuple<FilePos, FilePos> result = structure.deleteStructure(position);
            if (result != null) {
                FilePos resultPos = result.getFirst();
                container.sendChatMessage("Deleted Structure at: [" + resultPos + "]");
                if (doRemove) {
                    FilePos resultEnd = result.getSecond();
                    container.onProcessStarted();
                    container.getDeleter().startTask(new RemoveStructure(dimension, resultPos, resultEnd));
                    container.sendChatMessage("Structure Deletion Process starts in 5 seconds.");
                }
            } else {
                container.sendChatMessage("Structure not found nearby: [" + position + "]");
            }
        } else {
            this.throwErrors(container, args.length);
        }
    }

    @Override
    public List<String> getAutoCompleteOption(String[] args, int argLayer, int commandIndex) {
        if (commandIndex == 0) {
            return DeleteStructureSubCommand.getBestMatch(args, CompleterHelper.STRUCTURE_DIMENSION);
        }
        if (commandIndex == 1) {
            return DeleteStructureSubCommand.getBestMatch(args, CompleterHelper.getStructures(DeleteStructureSubCommand.parseNumber(args[argLayer - 1], 0), false));
        }
        if (commandIndex == 2) {
            return DeleteStructureSubCommand.getBestMatch(args, StructureManager.instance.getXPositions(DeleteStructureSubCommand.parseNumber(args[argLayer - 2], 0), args[argLayer - 1]));
        }
        if (commandIndex == 3) {
            return DeleteStructureSubCommand.getBestMatch(args, StructureManager.instance.getZPositions(DeleteStructureSubCommand.parseNumber(args[argLayer - 3], 0), args[argLayer - 2], DeleteStructureSubCommand.parseNumber(args[argLayer - 1], 0)));
        }
        if (commandIndex == 4) {
            return DeleteStructureSubCommand.getBestMatch(args, "delete");
        }
        return new ArrayList<String>();
    }

    public static class RemoveStructure
    extends IDeletionTask {
        int dim;
        FilePos start;
        FilePos end;

        public RemoveStructure(int dim, FilePos start, FilePos end) {
            this.dim = dim;
            this.start = start;
            this.end = end;
        }

        @Override
        public Future<DeleteProcess> createTask(final PrepaireProgress progress) {
            long x = this.end.x - this.start.x;
            long z = this.end.z - this.start.z;
            progress.setMax(x * z);
            final boolean loaded = DimensionManager.getWorld((int)this.dim) != null;
            final WorldServer world = this.getWorld(this.dim);
            final File file = world.getChunkSaveLocation();
            if (!loaded) {
                DimensionManager.unloadWorld((int)this.dim);
            }
            return ChunkPregenerator.SERVICE.submit(new Callable<DeleteProcess>(){

                @Override
                public DeleteProcess call() throws Exception {
                    DeleteProcess process = new DeleteProcess(file, ChunkCalculator.createArea(start.x, start.z, end.x, end.z, progress));
                    if (loaded) {
                        process.setChunkHost(world);
                    }
                    return process;
                }
            });
        }
    }
}

