/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.client.preview.world;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Collection;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.TimeUnit;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.structure.StructureStart;
import pregenerator.impl.client.preview.data.IFileProvider;
import pregenerator.impl.client.preview.data.SubProcessor;
import pregenerator.impl.client.preview.data.Tasks;
import pregenerator.impl.client.preview.texture.MoveableTexture;
import pregenerator.impl.client.preview.world.ChunkCache;
import pregenerator.impl.client.preview.world.WorldSeed;
import pregenerator.impl.client.preview.world.data.Evaluator;
import pregenerator.impl.client.preview.world.data.IChunkData;
import pregenerator.impl.misc.FilePos;
import pregenerator.impl.misc.Tuple;
import pregenerator.impl.processor.generator.ChunkProcessor;
import pregenerator.impl.storage.PregenTask;
import pregenerator.impl.structure.MapGenStructureDataPregen;
import pregenerator.impl.structure.StructureManager;

public class WorldInstance {
    static final FilePos CENTER = new FilePos(0, 0);
    Cache<FilePos, IChunkData> cachedChunks = CacheBuilder.newBuilder().maximumSize(64L).expireAfterAccess(30L, TimeUnit.SECONDS).build();
    Map<String, Set<StructureStart>> structureCache = new LinkedHashMap<String, Set<StructureStart>>();
    Set<FilePos> slimeChunks = new LinkedHashSet<FilePos>();
    Deque<IChunkData> toSave = new ConcurrentLinkedDeque<IChunkData>();
    Deque<Tuple<IChunkData, Integer>> toRender = new ConcurrentLinkedDeque<Tuple<IChunkData, Integer>>();
    Evaluator evaluator = new Evaluator();
    final int dimension;
    int radius = 100;
    ChunkCache cache;
    boolean isFocus = false;
    IFileProvider.FileType type;
    boolean square = true;
    int lastState = -1;

    public WorldInstance(int dimension, boolean shape, ChunkCache cache) {
        this.square = shape;
        this.dimension = dimension;
        this.cache = cache;
        this.isFocus = true;
        this.type = WorldSeed.isUsingCompression() ? IFileProvider.FileType.Compressed_Chunk_Data : IFileProvider.FileType.Chunk_Data;
    }

    public void setRadius(int radius) {
        this.radius = radius;
    }

    public void toggleShape() {
        this.square = !this.square;
    }

    public boolean isSquare() {
        return this.square;
    }

    public boolean isSaveToUse() {
        return this.lastState != 0;
    }

    public void setFocus(int focusDim, int view) {
        boolean bl = this.isFocus = focusDim == this.dimension;
        if (this.isFocus) {
            this.reload(view);
        } else {
            this.toRender.clear();
        }
    }

    public int getRadius() {
        return this.radius;
    }

    public IChunkData getChunk(int x, int z) {
        if (this.cache.hasIndex(x, z)) {
            IChunkData data = (IChunkData)this.cachedChunks.getIfPresent((Object)new FilePos(x, z));
            return data != null ? data : this.cache.getChunk(x, z, this.cachedChunks);
        }
        return null;
    }

    public boolean isFocus() {
        return this.isFocus;
    }

    public void reload(int view) {
        this.cache.addTask(new Tasks.MassFetchTask(this.toRender, view));
    }

    public void update(final int view, SubProcessor process) {
        for (int i = 0; i < 100 && !this.toSave.isEmpty(); ++i) {
            IChunkData data = this.toSave.removeFirst();
            data.storeInHeightMap(this.cache);
            if (data.isSlimeChunk()) {
                this.slimeChunks.add(new FilePos(data.getX(), data.getZ()));
            }
            this.cache.addTask(data);
            this.evaluator.addChunk(data);
            if (!this.isFocus) continue;
            this.toRender.addLast(new Tuple<IChunkData, Integer>(data, view));
        }
        process.addTask(new Runnable(){

            @Override
            public void run() {
                WorldInstance.this.process(view);
            }
        });
    }

    private void process(int view) {
        for (IChunkData data : this.evaluator.tick(ChunkProcessor.INSTANCE.isStopped(), this.cache)) {
            this.cache.addTask(data);
            if (!this.isFocus) continue;
            this.toRender.addLast(new Tuple<IChunkData, Integer>(data, view));
        }
    }

    public void render(MoveableTexture texture) {
        int toUpdate = Math.max(1000, this.toRender.size() / 10);
        for (int i = 0; i < toUpdate && !this.toRender.isEmpty(); ++i) {
            Tuple<IChunkData, Integer> value = this.toRender.removeFirst();
            IChunkData data = value.getFirst();
            if (data.getX() < -this.radius || data.getX() >= this.radius || data.getZ() < -this.radius || data.getZ() >= this.radius) continue;
            data.addToTexture(texture, value.getSecond(), this.radius * 16);
        }
    }

    public void addChunk(Chunk data) {
        if (this.square ? data.field_76635_g < -this.radius || data.field_76635_g >= this.radius || data.field_76647_h < -this.radius || data.field_76647_h >= this.radius : CENTER.getSqDistance(data.field_76635_g, data.field_76647_h) > (double)this.radius) {
            return;
        }
        this.toSave.add(this.type.createData(data));
    }

    public PregenTask createTask(int state) {
        this.lastState = Math.max(this.lastState, state);
        return new PregenTask(this.square ? 0 : 1, this.dimension, 0, 0, this.radius, 0, state);
    }

    public Collection<FilePos> getSlimeChunks() {
        return this.slimeChunks;
    }

    public Map<String, Set<StructureStart>> getStructures() {
        LinkedHashMap<String, Set<StructureStart>> results = new LinkedHashMap<String, Set<StructureStart>>();
        for (MapGenStructureDataPregen mapGenStructureDataPregen : StructureManager.instance.getStructureHolders(this.dimension)) {
            try {
                results.put(mapGenStructureDataPregen.field_76190_i, new LinkedHashSet<StructureStart>(mapGenStructureDataPregen.getStarts()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        for (Map.Entry entry : this.structureCache.entrySet()) {
            LinkedHashSet resultEntry = (LinkedHashSet)results.get(entry.getKey());
            if (resultEntry == null) {
                resultEntry = new LinkedHashSet();
                results.put((String)entry.getKey(), resultEntry);
            }
            resultEntry.addAll((Collection)entry.getValue());
        }
        this.structureCache = results;
        return results;
    }
}

