/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.world.structure.generation.thewall.wallparts;

import net.minecraft.block.BlockStoneSlab;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import team.cqr.cqrepoured.config.CQRConfig;
import team.cqr.cqrepoured.world.structure.generation.generation.GeneratableDungeon;
import team.cqr.cqrepoured.world.structure.generation.generation.part.BlockDungeonPart;
import team.cqr.cqrepoured.world.structure.generation.generation.part.IDungeonPartBuilder;
import team.cqr.cqrepoured.world.structure.generation.generation.preparable.PreparableBlockInfo;
import team.cqr.cqrepoured.world.structure.generation.thewall.wallparts.IWallPart;

public class WallPartRailingTower
implements IWallPart {
    @Override
    public int getTopY() {
        return CQRConfig.wall.topY - 12;
    }

    @Override
    public void generateWall(int chunkX, int chunkZ, World world, Chunk chunk, GeneratableDungeon.Builder dungeonBuilder) {
        int y;
        int startX = chunkX * 16 + 8;
        int startZ = chunkZ * 16;
        int startY = this.getTopY();
        BlockDungeonPart.Builder partBuilder = new BlockDungeonPart.Builder();
        IBlockState stateBlock = Blocks.field_150334_T.func_176223_P().func_177226_a((IProperty)BlockStoneSlab.field_176556_M, (Comparable)BlockStoneSlab.EnumType.STONE).func_177226_a((IProperty)BlockStoneSlab.field_176555_b, (Comparable)Boolean.valueOf(true));
        IBlockState stateAir = Blocks.field_150350_a.func_176223_P();
        int[] xValues = new int[]{0, 1, 6, 7};
        int[] zValues = new int[]{2, 3, 12, 13};
        for (y = 0; y < 8; ++y) {
            for (int z : zValues) {
                for (int x : xValues) {
                    if (this.isBiggerPart(x)) {
                        if (y < 3 && z != 3 && z != 12) continue;
                        partBuilder.add(new PreparableBlockInfo(new BlockPos(x * 2, y, z), stateBlock, null));
                        partBuilder.add(new PreparableBlockInfo(new BlockPos(x * 2 + 1, y, z), stateBlock, null));
                        continue;
                    }
                    if (y < 4 || y > 6 || z != 3 && z != 12) continue;
                    partBuilder.add(new PreparableBlockInfo(new BlockPos(x * 2, y, z), stateBlock, null));
                    partBuilder.add(new PreparableBlockInfo(new BlockPos(x * 2 + 1, y, z), stateBlock, null));
                }
            }
        }
        for (y = 6; y <= 9; ++y) {
            for (int z = 6; z <= 9; ++z) {
                for (int x = 4; x <= 11; ++x) {
                    if (y >= 9 && z != 7 && z != 8) continue;
                    partBuilder.add(new PreparableBlockInfo(new BlockPos(x, y, z), stateAir, null));
                }
            }
        }
        dungeonBuilder.add((IDungeonPartBuilder)partBuilder, dungeonBuilder.getPlacement(new BlockPos(startX, startY, startZ)));
    }

    private boolean isBiggerPart(int xAsChunkRelativeCoord) {
        return (xAsChunkRelativeCoord & 1) == 0;
    }
}

