/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.world.structure.generation.structurefile;

import java.util.Iterator;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.ObjectIntIdentityMap;

public class BlockStatePalette
implements Iterable<IBlockState> {
    public static final IBlockState DEFAULT_BLOCK_STATE = Blocks.field_150350_a.func_176223_P();
    private final ObjectIntIdentityMap<IBlockState> ids = new ObjectIntIdentityMap(16);
    private int lastId;

    public BlockStatePalette() {
    }

    public BlockStatePalette(NBTTagList nbtList) {
        nbtList.forEach(nbt -> this.idFor(NBTUtil.func_190008_d((NBTTagCompound)((NBTTagCompound)nbt))));
    }

    public int idFor(IBlockState state) {
        int i = this.ids.func_148747_b((Object)state);
        if (i == -1) {
            i = this.lastId++;
            this.ids.func_148746_a((Object)state, i);
        }
        return i;
    }

    @Nullable
    public IBlockState stateFor(int id) {
        IBlockState iblockstate = (IBlockState)this.ids.func_148745_a(id);
        return iblockstate == null ? DEFAULT_BLOCK_STATE : iblockstate;
    }

    @Override
    public Iterator<IBlockState> iterator() {
        return this.ids.iterator();
    }

    public void addMapping(IBlockState state, int id) {
        this.ids.func_148746_a((Object)state, id);
    }

    public int size() {
        return this.ids.func_186804_a();
    }

    public NBTTagList writeToNBT() {
        NBTTagList nbtList = new NBTTagList();
        this.ids.forEach(state -> nbtList.func_74742_a((NBTBase)NBTUtil.func_190009_a((NBTTagCompound)new NBTTagCompound(), (IBlockState)state)));
        return nbtList;
    }
}

