/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.world.structure.generation.lootchests;

import com.google.common.cache.LoadingCache;
import com.google.common.collect.Queues;
import com.google.common.io.Files;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import meldexun.reflectionutil.ReflectionConstructor;
import meldexun.reflectionutil.ReflectionField;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.LootTableManager;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.ForgeEventFactory;
import org.apache.commons.io.FileUtils;
import team.cqr.cqrepoured.CQRMain;
import team.cqr.cqrepoured.config.CQRConfig;
import team.cqr.cqrepoured.init.CQRLoottables;
import team.cqr.cqrepoured.world.structure.generation.lootchests.WeightedItemStack;

public class LootTableLoader {
    private static final ReflectionField<ThreadLocal<Deque<?>>> LOOT_CONTEXT = new ReflectionField(ForgeHooks.class, "lootContext", "lootContext");
    private static final ReflectionConstructor<?> LOOT_TABLE_CONTEXT = new ReflectionConstructor("net.minecraftforge.common.ForgeHooks$LootTableContext", ResourceLocation.class, Boolean.TYPE);
    private static final ReflectionField<Gson> GSON_INSTANCE = new ReflectionField(LootTableManager.class, "field_186526_b", "GSON_INSTANCE");
    private static final ReflectionField<LoadingCache<ResourceLocation, LootTable>> FIELD_REGISTERED_LOOT_TABLES = new ReflectionField(LootTableManager.class, "field_186527_c", "registeredLootTables");
    private static LootTable loadingLootTable;

    private static List<WeightedItemStack> getItemList(Properties propFile) {
        ArrayList<WeightedItemStack> items = new ArrayList<WeightedItemStack>();
        Enumeration<Object> fileEntries = propFile.elements();
        while (fileEntries.hasMoreElements()) {
            WeightedItemStack stack;
            String entry = (String)fileEntries.nextElement();
            if (entry.startsWith("#") || (stack = LootTableLoader.createWeightedItemStack(entry)) == null) continue;
            items.add(stack);
        }
        return items;
    }

    private static WeightedItemStack createWeightedItemStack(String entry) {
        StringTokenizer tokenizer = new StringTokenizer(entry, ",");
        int tokenCount = tokenizer.countTokens();
        if (tokenCount >= 5) {
            int chance;
            int maxCount;
            int minCount;
            int damage;
            boolean enchant = false;
            int minLvl = 1;
            int maxLvl = 10;
            boolean treasure = false;
            int enchChance = 0;
            String item = ((String)tokenizer.nextElement()).trim();
            if (item.isEmpty()) {
                CQRMain.logger.error("Can't parse argument 1 (item) of:\n{}", (Object)entry);
                return null;
            }
            try {
                damage = Integer.parseInt(((String)tokenizer.nextElement()).trim());
            }
            catch (NumberFormatException e) {
                CQRMain.logger.error("Can't parse argument 2 (item damage) of:\n{}", (Object)entry);
                return null;
            }
            try {
                minCount = Integer.parseInt(((String)tokenizer.nextElement()).trim());
            }
            catch (NumberFormatException e) {
                CQRMain.logger.error("Can't parse argument 3 (min item count) of:\n{}", (Object)entry);
                return null;
            }
            try {
                maxCount = Integer.parseInt(((String)tokenizer.nextElement()).trim());
            }
            catch (NumberFormatException e) {
                CQRMain.logger.error("Can't parse argument 4 (max item count) of:\n{}", (Object)entry);
                return null;
            }
            try {
                chance = Integer.parseInt(((String)tokenizer.nextElement()).trim());
            }
            catch (NumberFormatException e) {
                CQRMain.logger.error("Can't parse argument 5 (item chance) of:\n{}", (Object)entry);
                return null;
            }
            if (tokenCount >= 6) {
                enchant = Boolean.parseBoolean(((String)tokenizer.nextElement()).trim());
                try {
                    minLvl = Integer.parseInt(((String)tokenizer.nextElement()).trim());
                }
                catch (NumberFormatException e) {
                    CQRMain.logger.error("Can't parse argument 7 (min enchant level) of:\n{}", (Object)entry);
                    return null;
                }
                try {
                    maxLvl = Integer.parseInt(((String)tokenizer.nextElement()).trim());
                }
                catch (NumberFormatException e) {
                    CQRMain.logger.error("Can't parse argument 8 (max enchant level) of:\n{}", (Object)entry);
                    return null;
                }
                if (tokenCount >= 9) {
                    treasure = Boolean.parseBoolean(((String)tokenizer.nextElement()).trim());
                    if (tokenCount >= 10) {
                        try {
                            enchChance = Integer.parseInt(((String)tokenizer.nextElement()).trim());
                        }
                        catch (NumberFormatException e) {
                            CQRMain.logger.error("Can't parse argument 10 (enchanting chance) of:\n{}", (Object)entry);
                            return null;
                        }
                    }
                }
            }
            return new WeightedItemStack(item, damage, minCount, maxCount, chance, enchant, minLvl, maxLvl, treasure, enchChance);
        }
        CQRMain.logger.error("Config string {} is invalid! Not enough arguments!", (Object)entry);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static LootTable fillLootTable(ResourceLocation name, LootTable defaultLootTable) {
        File jsonFile = new File(CQRMain.CQ_CHEST_FOLDER, name.func_110623_a() + ".json");
        File propFile = new File(CQRMain.CQ_CHEST_FOLDER, name.func_110623_a() + ".properties");
        if (jsonFile.exists()) {
            try (FileInputStream inputStream2 = new FileInputStream(jsonFile);){
                void newLootTable2;
                String s = Files.toString((File)jsonFile, (Charset)StandardCharsets.UTF_8);
                ThreadLocal<Deque<?>> lootContext = LOOT_CONTEXT.get(null);
                ArrayDeque que = lootContext.get();
                if (que == null) {
                    que = Queues.newArrayDeque();
                    lootContext.set(que);
                }
                que.push(LOOT_TABLE_CONTEXT.newInstance(name, true));
                try {
                    LootTable newLootTable22 = (LootTable)GSON_INSTANCE.get(null).fromJson(s, LootTable.class);
                }
                finally {
                    que.pop();
                }
                if (newLootTable2 != null) {
                    loadingLootTable = newLootTable2;
                }
                void lootTable3 = newLootTable2;
                return lootTable3;
            }
            catch (JsonSyntaxException | IOException e) {
                CQRMain.logger.error("Failed to read json loot table {}", (Object)jsonFile.getName(), (Object)e);
                return defaultLootTable;
            }
        }
        if (!propFile.exists()) return defaultLootTable;
        try (FileInputStream inputStream = new FileInputStream(propFile);){
            Properties properties = new Properties();
            properties.load(inputStream);
            List<WeightedItemStack> items = LootTableLoader.getItemList(properties);
            LootTable newLootTable = new LootTable(new LootPool[0]);
            if (CQRConfig.general.singleLootPoolPerLootTable) {
                LootEntry[] entries = new LootEntry[items.size()];
                int i = 0;
                while (true) {
                    if (i >= items.size()) {
                        LootTable lootTable2 = new LootTable(new LootPool[]{new LootPool(entries, new LootCondition[0], new RandomValueRange((float)Math.min(CQRConfig.general.minItemsPerLootChest, CQRConfig.general.maxItemsPerLootChest), (float)Math.min(Math.max(CQRConfig.general.minItemsPerLootChest, CQRConfig.general.maxItemsPerLootChest), items.size())), new RandomValueRange(0.0f), name.func_110623_a() + "_pool")});
                        return lootTable2;
                    }
                    entries[i] = items.get(i).getAsLootEntry(i);
                    ++i;
                }
            }
            for (int i = 0; i < items.size(); ++i) {
                newLootTable.addPool(items.get(i).getAsSingleLootPool(i));
            }
            LootTable lootTable = newLootTable;
            return lootTable;
        }
        catch (IOException e) {
            CQRMain.logger.error("Failed to read prop loot table {}", (Object)propFile.getName(), (Object)e);
        }
        return defaultLootTable;
    }

    public static void freezeLootTable() {
        if (loadingLootTable != null) {
            loadingLootTable.freeze();
            loadingLootTable = null;
        }
    }

    public static void registerCustomLootTables(WorldServer worldServer) {
        Collection files = FileUtils.listFiles((File)new File(CQRMain.CQ_CHEST_FOLDER, "chests"), (String[])new String[]{"json", "properties"}, (boolean)false);
        Set<ResourceLocation> cqrChestLootTables = CQRLoottables.getChestLootTables();
        LootTableManager lootTableManager = worldServer.func_184146_ak();
        LoadingCache<ResourceLocation, LootTable> registeredLootTables = FIELD_REGISTERED_LOOT_TABLES.get(lootTableManager);
        for (File file : files) {
            String s = file.getName();
            ResourceLocation name = new ResourceLocation("cqrepoured", "chests/" + s.substring(0, s.lastIndexOf(46)));
            if (cqrChestLootTables.contains(name)) continue;
            LootTable table = new LootTable(new LootPool[0]);
            table = ForgeEventFactory.loadLootTable((ResourceLocation)name, (LootTable)table, (LootTableManager)lootTableManager);
            registeredLootTables.put((Object)name, (Object)table);
        }
    }
}

