/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.world.structure.generation.inhabitants;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import org.apache.commons.io.FileUtils;
import team.cqr.cqrepoured.CQRMain;
import team.cqr.cqrepoured.config.CQRConfig;
import team.cqr.cqrepoured.faction.Faction;
import team.cqr.cqrepoured.faction.FactionRegistry;
import team.cqr.cqrepoured.util.DungeonGenUtils;
import team.cqr.cqrepoured.world.structure.generation.inhabitants.DungeonInhabitant;
import team.cqr.cqrepoured.world.structure.generation.inhabitants.EDefaultInhabitants;

public class DungeonInhabitantManager {
    public static final DungeonInhabitant DEFAULT_DUNGEON_INHABITANT = new DungeonInhabitant(EDefaultInhabitants.DEFAULT);
    private static final DungeonInhabitantManager INSTANCE = new DungeonInhabitantManager();
    private final Random random = new Random();
    private final Map<String, DungeonInhabitant> inhabitantMapping = new HashMap<String, DungeonInhabitant>();
    private final List<List<String>> distantMapping = new ArrayList<List<String>>();

    private DungeonInhabitantManager() {
    }

    public static DungeonInhabitantManager instance() {
        return INSTANCE;
    }

    public void loadDungeonInhabitants() {
        this.inhabitantMapping.clear();
        this.loadDefaultInhabitants();
        this.loadInhabitantConfigs();
        this.loadDistantMapping();
        this.inhabitantMapping.put("DEFAULT", DEFAULT_DUNGEON_INHABITANT);
    }

    private void loadDefaultInhabitants() {
        for (EDefaultInhabitants defInha : EDefaultInhabitants.values()) {
            DungeonInhabitant inha = new DungeonInhabitant(defInha);
            this.inhabitantMapping.put(inha.getName().toUpperCase(), inha);
        }
    }

    private void loadInhabitantConfigs() {
        for (File file : FileUtils.listFiles((File)CQRMain.CQ_INHABITANT_FOLDER, (String[])new String[]{"cfg", "prop", "properties"}, (boolean)true)) {
            try {
                FileInputStream inputStream = new FileInputStream(file);
                Throwable throwable = null;
                try {
                    Properties prop = new Properties();
                    prop.load(inputStream);
                    try {
                        DungeonInhabitant inha = new DungeonInhabitant(prop);
                        this.inhabitantMapping.put(inha.getName().toUpperCase(), inha);
                    }
                    catch (Exception e) {
                        CQRMain.logger.warn(String.format("Failed to create DungeonInhabitant object from file: %s", file.getName()), (Throwable)e);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (inputStream == null) continue;
                    if (throwable != null) {
                        try {
                            ((InputStream)inputStream).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    ((InputStream)inputStream).close();
                }
            }
            catch (IOException e) {
                CQRMain.logger.error(String.format("Failed to load file %s", file.getName()), (Throwable)e);
            }
        }
    }

    private void loadDistantMapping() {
        for (String s : CQRConfig.general.defaultInhabitantConfig) {
            String[] entries = s.split(",");
            ArrayList<String> tmpList = new ArrayList<String>();
            for (String s1 : entries) {
                if (!this.inhabitantMapping.containsKey(s1 = s1.trim()) || s1.equalsIgnoreCase(DEFAULT_DUNGEON_INHABITANT.getName())) continue;
                tmpList.add(s1);
            }
            if (tmpList.isEmpty()) continue;
            tmpList.trimToSize();
            this.distantMapping.add(tmpList);
        }
    }

    public DungeonInhabitant getInhabitant(String name) {
        return this.inhabitantMapping.getOrDefault(name, DEFAULT_DUNGEON_INHABITANT);
    }

    public DungeonInhabitant getInhabitantByDistance(World world, int blockX, int blockZ) {
        double z1;
        if (this.distantMapping.isEmpty()) {
            return (DungeonInhabitant)this.inhabitantMapping.values().toArray()[this.random.nextInt(this.inhabitantMapping.size())];
        }
        double x1 = (double)blockX - (double)DungeonGenUtils.getSpawnX(world);
        int distToSpawn = (int)Math.sqrt(x1 * x1 + (z1 = (double)blockZ - (double)DungeonGenUtils.getSpawnZ(world)) * z1);
        int index = distToSpawn / CQRConfig.mobs.mobTypeChangeDistance;
        if (index >= this.distantMapping.size()) {
            index = this.random.nextInt(this.distantMapping.size());
        }
        List<String> tmpList = this.distantMapping.get(index);
        return this.getInhabitant(tmpList.get(this.random.nextInt(tmpList.size())));
    }

    public DungeonInhabitant getInhabitantByDistanceIfDefault(String name, World world, int blockX, int blockZ) {
        DungeonInhabitant dungeonInhabitant = this.getInhabitant(name);
        if (dungeonInhabitant != DEFAULT_DUNGEON_INHABITANT) {
            return dungeonInhabitant;
        }
        return this.getInhabitantByDistance(world, blockX, blockZ);
    }

    public List<DungeonInhabitant> getListOfFactionInhabitants(Faction faction, World world) {
        ArrayList<DungeonInhabitant> result = new ArrayList<DungeonInhabitant>();
        for (DungeonInhabitant inha : this.inhabitantMapping.values()) {
            if (inha.getName().equalsIgnoreCase(DEFAULT_DUNGEON_INHABITANT.getName())) continue;
            if (inha.getFactionOverride() != null) {
                if (!faction.equals(FactionRegistry.instance(world).getFactionInstance(inha.getFactionOverride()))) continue;
                result.add(inha);
                continue;
            }
            Entity entity = EntityList.func_188429_b((ResourceLocation)inha.getEntityID(), (World)world);
            if (entity == null || !FactionRegistry.instance(world).getFactionOf(entity).equals(faction)) continue;
            result.add(inha);
        }
        return result;
    }
}

