/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.world.structure.generation.generators.stronghold;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import team.cqr.cqrepoured.CQRMain;
import team.cqr.cqrepoured.config.CQRConfig;
import team.cqr.cqrepoured.util.data.FileIOUtil;
import team.cqr.cqrepoured.world.structure.generation.dungeons.DungeonStrongholdOpen;
import team.cqr.cqrepoured.world.structure.generation.generation.part.PlateauDungeonPart;
import team.cqr.cqrepoured.world.structure.generation.generators.AbstractDungeonGenerator;
import team.cqr.cqrepoured.world.structure.generation.generators.stronghold.open.StrongholdFloorOpen;
import team.cqr.cqrepoured.world.structure.generation.inhabitants.DungeonInhabitant;
import team.cqr.cqrepoured.world.structure.generation.inhabitants.DungeonInhabitantManager;
import team.cqr.cqrepoured.world.structure.generation.structurefile.CQStructure;
import team.cqr.cqrepoured.world.structure.generation.structurefile.Offset;

public class GeneratorStrongholdOpen
extends AbstractDungeonGenerator<DungeonStrongholdOpen> {
    private List<String> blacklistedRooms = new ArrayList<String>();
    private Tuple<Integer, Integer> structureBounds;
    private PlacementSettings settings = new PlacementSettings();
    private StrongholdFloorOpen[] floors;
    private int dunX;
    private int dunZ;

    public GeneratorStrongholdOpen(World world, BlockPos pos, DungeonStrongholdOpen dungeon, Random rand) {
        super(world, pos, dungeon, rand);
        this.structureBounds = new Tuple((Object)dungeon.getRoomSizeX(), (Object)dungeon.getRoomSizeZ());
        this.settings.func_186214_a(Mirror.NONE);
        this.settings.func_186220_a(Rotation.NONE);
        this.settings.func_186225_a(Blocks.field_189881_dj);
        this.settings.func_189946_a(1.0f);
        this.floors = new StrongholdFloorOpen[dungeon.getRandomFloorCount(this.random)];
        this.searchStructureBounds();
        this.computeNotFittingStructures();
    }

    private void computeNotFittingStructures() {
        for (File f : ((DungeonStrongholdOpen)this.dungeon).getRoomFolder().listFiles(FileIOUtil.getNBTFileFilter())) {
            CQStructure struct = this.loadStructureFromFile(f);
            if (struct == null || struct.getSize().func_177958_n() == ((Integer)this.structureBounds.func_76341_a()).intValue() && struct.getSize().func_177952_p() == ((Integer)this.structureBounds.func_76340_b()).intValue()) continue;
            this.blacklistedRooms.add(f.getParent() + "/" + f.getName());
        }
    }

    @Override
    public DungeonStrongholdOpen getDungeon() {
        return (DungeonStrongholdOpen)this.dungeon;
    }

    private void searchStructureBounds() {
    }

    @Override
    public void preProcess() {
        this.dunX = this.pos.func_177958_n();
        this.dunZ = this.pos.func_177952_p();
        BlockPos initPos = this.pos;
        int rgd = this.getDungeon().getRandomRoomCountForFloor(this.random);
        if (rgd < 2) {
            rgd = 2;
        }
        if (rgd % 2 != 0) {
            ++rgd;
        }
        if ((rgd = MathHelper.func_76143_f((double)Math.sqrt(rgd))) % 2 == 0) {
            ++rgd;
        }
        StrongholdFloorOpen prevFloor = null;
        for (int i = 0; i < this.floors.length; ++i) {
            boolean isFirst = i == 0;
            StrongholdFloorOpen floor = null;
            floor = isFirst ? new StrongholdFloorOpen(this, rgd, rgd / 2, rgd / 2, this.random) : new StrongholdFloorOpen(this, rgd, (Integer)prevFloor.getExitStairIndexes().func_76341_a(), (Integer)prevFloor.getExitStairIndexes().func_76340_b(), this.random);
            File stair = null;
            if (isFirst) {
                stair = ((DungeonStrongholdOpen)this.dungeon).getEntranceStair(this.random);
                if (stair == null) {
                    CQRMain.logger.error("No entrance stair rooms for Stronghold Open Dungeon: {}", (Object)this.getDungeon().getDungeonName());
                    return;
                }
            } else {
                stair = ((DungeonStrongholdOpen)this.dungeon).getStairRoom(this.random);
                if (stair == null) {
                    CQRMain.logger.error("No stair rooms for Stronghold Open Dungeon: {}", (Object)this.getDungeon().getDungeonName());
                    return;
                }
            }
            floor.setIsFirstFloor(isFirst);
            int dY = initPos.func_177956_o() - this.loadStructureFromFile(stair).getSize().func_177956_o();
            if (dY <= ((DungeonStrongholdOpen)this.dungeon).getRoomSizeY() + 2) {
                this.floors[i - 1].setExitIsBossRoom(true);
            } else {
                initPos = initPos.func_177973_b(new Vec3i(0, this.loadStructureFromFile(stair).getSize().func_177956_o(), 0));
                if (!isFirst) {
                    initPos = initPos.func_177982_a(0, ((DungeonStrongholdOpen)this.dungeon).getRoomSizeY(), 0);
                }
                if (i + 1 == this.floors.length) {
                    floor.setExitIsBossRoom(true);
                }
                if (isFirst) {
                    floor.setEntranceStairPosition(stair, initPos.func_177958_n(), initPos.func_177956_o(), initPos.func_177952_p());
                } else {
                    floor.setEntranceStairPosition(stair, (Integer)prevFloor.getExitCoordinates().func_76341_a(), initPos.func_177956_o(), (Integer)prevFloor.getExitCoordinates().func_76340_b());
                }
                floor.preProcess(this.world, this.dungeonBuilder, null);
                initPos = new BlockPos(((Integer)floor.getExitCoordinates().func_76341_a()).intValue(), initPos.func_177956_o(), ((Integer)floor.getExitCoordinates().func_76340_b()).intValue());
            }
            prevFloor = floor;
            this.floors[i] = floor;
        }
    }

    @Override
    public void buildStructure() {
        File building = ((DungeonStrongholdOpen)this.dungeon).getEntranceBuilding(this.random);
        DungeonInhabitant mobType = DungeonInhabitantManager.instance().getInhabitantByDistanceIfDefault(((DungeonStrongholdOpen)this.dungeon).getDungeonMob(), this.world, this.pos.func_177958_n(), this.pos.func_177952_p());
        if (building == null || ((DungeonStrongholdOpen)this.dungeon).getEntranceBuildingFolder().listFiles(FileIOUtil.getNBTFileFilter()).length <= 0) {
            CQRMain.logger.error("No entrance buildings for Open Stronghold dungeon: {}", (Object)this.getDungeon().getDungeonName());
            return;
        }
        CQStructure structure = this.loadStructureFromFile(building);
        if (((DungeonStrongholdOpen)this.dungeon).doBuildSupportPlatform()) {
            PlateauDungeonPart.Builder partBuilder = new PlateauDungeonPart.Builder(this.pos.func_177958_n() + 4 + structure.getSize().func_177958_n() / 2, this.pos.func_177952_p() + 4 + structure.getSize().func_177952_p() / 2, this.pos.func_177958_n() - 4 - structure.getSize().func_177958_n() / 2, this.pos.func_177956_o(), this.pos.func_177952_p() - 4 - structure.getSize().func_177952_p() / 2, CQRConfig.general.supportHillWallSize);
            partBuilder.setSupportHillBlock(((DungeonStrongholdOpen)this.dungeon).getSupportBlock());
            partBuilder.setSupportHillTopBlock(((DungeonStrongholdOpen)this.dungeon).getSupportTopBlock());
            this.dungeonBuilder.add(partBuilder);
        }
        structure.addAll(this.dungeonBuilder, this.pos, Offset.CENTER);
        for (StrongholdFloorOpen floor : this.floors) {
            floor.generate(this.world, this.dungeonBuilder, mobType);
        }
        for (StrongholdFloorOpen floor : this.floors) {
            if (floor == null) {
                CQRMain.logger.error("Floor is null! Not generating it!");
                continue;
            }
            try {
                floor.generatePost(this.world, this.dungeonBuilder, mobType);
            }
            catch (NullPointerException ex) {
                CQRMain.logger.error("Error whilst trying to construct wall in open stronghold at: X {}  Y {}  Z {}", (Object)this.pos.func_177958_n(), (Object)this.pos.func_177956_o(), (Object)this.pos.func_177952_p());
            }
        }
    }

    @Override
    public void postProcess() {
        if (((DungeonStrongholdOpen)this.dungeon).isCoverBlockEnabled()) {
            // empty if block
        }
    }

    public int getDunX() {
        return this.dunX;
    }

    public int getDunZ() {
        return this.dunZ;
    }

    public PlacementSettings getPlacementSettings() {
        return this.settings;
    }

    public BlockPos getPos() {
        return this.pos;
    }
}

