/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.world.structure.generation.generators.castleparts.rooms;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import team.cqr.cqrepoured.block.BlockSpawner;
import team.cqr.cqrepoured.init.CQRBlocks;
import team.cqr.cqrepoured.tileentity.TileEntitySpawner;
import team.cqr.cqrepoured.util.BlockStateGenArray;
import team.cqr.cqrepoured.util.DungeonGenUtils;
import team.cqr.cqrepoured.util.GearedMobFactory;
import team.cqr.cqrepoured.util.SpawnerFactory;
import team.cqr.cqrepoured.world.structure.generation.dungeons.DungeonRandomizedCastle;
import team.cqr.cqrepoured.world.structure.generation.generators.castleparts.rooms.CastleRoomBase;
import team.cqr.cqrepoured.world.structure.generation.generators.castleparts.rooms.decoration.DecorationSelector;
import team.cqr.cqrepoured.world.structure.generation.generators.castleparts.rooms.decoration.IRoomDecor;
import team.cqr.cqrepoured.world.structure.generation.generators.castleparts.rooms.decoration.RoomDecorTypes;
import team.cqr.cqrepoured.world.structure.generation.generators.castleparts.rooms.decoration.objects.RoomDecorChest;
import team.cqr.cqrepoured.world.structure.generation.generators.castleparts.rooms.decoration.objects.RoomDecorNone;
import team.cqr.cqrepoured.world.structure.generation.generators.castleparts.rooms.segments.CastleMainStructWall;

public abstract class CastleRoomDecoratedBase
extends CastleRoomBase {
    protected static final int MAX_DECO_ATTEMPTS = 3;
    protected static final int LIGHT_LEVEL = 4;
    protected DecorationSelector decoSelector = new DecorationSelector();
    protected Map<BlockPos, EnumFacing> possibleChestLocs = new HashMap<BlockPos, EnumFacing>();

    CastleRoomDecoratedBase(int sideLength, int height, int floor, Random rand) {
        super(sideLength, height, floor, rand);
    }

    @Override
    public void decorate(World world, BlockStateGenArray genArray, DungeonRandomizedCastle dungeon, GearedMobFactory mobFactory) {
        this.setupDecoration(genArray, dungeon);
        if (this.shouldBuildEdgeDecoration()) {
            this.addEdgeDecoration(world, genArray, dungeon);
        }
        if (this.shouldBuildWallDecoration()) {
            this.addWallDecoration(world, genArray, dungeon);
        }
        if (this.shouldBuildMidDecoration()) {
            this.addMidDecoration(world, genArray, dungeon);
        }
        if (this.shouldAddSpawners()) {
            this.addSpawners(world, genArray, dungeon, mobFactory);
        }
        if (this.shouldAddChests()) {
            this.addChests(world, genArray, dungeon);
        }
        this.fillEmptySpaceWithAir(genArray);
    }

    abstract boolean shouldBuildEdgeDecoration();

    abstract boolean shouldBuildWallDecoration();

    abstract boolean shouldBuildMidDecoration();

    abstract boolean shouldAddSpawners();

    abstract boolean shouldAddChests();

    protected void addEdgeDecoration(World world, BlockStateGenArray genArray, DungeonRandomizedCastle dungeon) {
        if (this.decoSelector.edgeDecorRegistered()) {
            for (EnumFacing side : EnumFacing.field_176754_o) {
                if (!this.walls.containsKey(side) || !((CastleMainStructWall)this.walls.get(side)).isEnabled()) continue;
                List<BlockPos> edge = this.getDecorationEdge(side);
                for (BlockPos pos : edge) {
                    int attempts;
                    if (this.usedDecoPositions.contains(pos)) continue;
                    for (attempts = 0; attempts < 3; ++attempts) {
                        IRoomDecor decor = this.decoSelector.randomEdgeDecor(genArray.getRandom());
                        if (!decor.wouldFit(pos, side, this.possibleDecoPositions, this.usedDecoPositions, this)) continue;
                        decor.build(world, genArray, this, dungeon, pos, side, this.usedDecoPositions);
                        if (!(decor instanceof RoomDecorNone)) break;
                        this.usedDecoPositions.add(pos);
                        this.possibleChestLocs.put(pos, side);
                        break;
                    }
                    if (attempts < 3) continue;
                    genArray.addBlockState(pos, Blocks.field_150350_a.func_176223_P(), BlockStateGenArray.GenerationPhase.MAIN, BlockStateGenArray.EnumPriority.MEDIUM);
                    this.usedDecoPositions.add(pos);
                    this.possibleChestLocs.put(pos, side);
                }
            }
        }
    }

    protected void addMidDecoration(World world, BlockStateGenArray genArray, DungeonRandomizedCastle dungeon) {
        if (this.decoSelector.midDecorRegistered()) {
            List<BlockPos> area = this.getDecorationMiddle();
            for (BlockPos pos : area) {
                int attempts;
                if (this.usedDecoPositions.contains(pos)) continue;
                for (attempts = 0; attempts < 3; ++attempts) {
                    EnumFacing side;
                    IRoomDecor decor = this.decoSelector.randomMidDecor(genArray.getRandom());
                    if (!decor.wouldFit(pos, side = EnumFacing.NORTH, this.possibleDecoPositions, this.usedDecoPositions, this)) continue;
                    decor.build(world, genArray, this, dungeon, pos, side, this.usedDecoPositions);
                    break;
                }
                if (attempts < 3) continue;
                genArray.addBlockState(pos, Blocks.field_150350_a.func_176223_P(), BlockStateGenArray.GenerationPhase.MAIN, BlockStateGenArray.EnumPriority.MEDIUM);
                this.usedDecoPositions.add(pos);
            }
        }
    }

    protected void addSpawners(World world, BlockStateGenArray genArray, DungeonRandomizedCastle dungeon, GearedMobFactory mobFactory) {
        List<BlockPos> spawnPositions = this.getDecorationLayer(0);
        spawnPositions.removeAll(this.usedDecoPositions);
        int spawnerCount = dungeon.randomizeRoomSpawnerCount(this.random);
        for (int i = 0; i < spawnerCount && !spawnPositions.isEmpty(); ++i) {
            BlockPos pos = spawnPositions.get(this.random.nextInt(spawnPositions.size()));
            Entity mobEntity = mobFactory.getGearedEntityByFloor(this.floor, world);
            BlockSpawner spawnerBlock = CQRBlocks.SPAWNER;
            IBlockState state = spawnerBlock.func_176223_P();
            TileEntitySpawner spawner = (TileEntitySpawner)spawnerBlock.createTileEntity(world, state);
            if (spawner == null) continue;
            spawner.inventory.setStackInSlot(0, SpawnerFactory.getSoulBottleItemStackForEntity(mobEntity));
            NBTTagCompound spawnerCompound = spawner.func_189515_b(new NBTTagCompound());
            genArray.addBlockState(pos, state, spawnerCompound, BlockStateGenArray.GenerationPhase.POST, BlockStateGenArray.EnumPriority.MEDIUM);
            this.usedDecoPositions.add(pos);
            spawnPositions.remove(pos);
        }
    }

    protected void addWallDecoration(World world, BlockStateGenArray genArray, DungeonRandomizedCastle dungeon) {
        int torchPercent = 12;
        for (EnumFacing side : EnumFacing.field_176754_o) {
            if (!this.walls.containsKey(side) || !((CastleMainStructWall)this.walls.get(side)).isEnabled()) continue;
            List<BlockPos> edge = this.getWallDecorationEdge(side);
            for (BlockPos pos : edge) {
                if (this.usedDecoPositions.contains(pos)) continue;
                switch (this.random.nextInt(2)) {
                    case 0: {
                        if (!RoomDecorTypes.TORCH.wouldFit(pos, side, this.possibleDecoPositions, this.usedDecoPositions, this) || !DungeonGenUtils.percentageRandom(torchPercent, this.random)) break;
                        RoomDecorTypes.TORCH.build(world, genArray, this, dungeon, pos, side, this.usedDecoPositions);
                        break;
                    }
                    case 1: {
                        if (!RoomDecorTypes.PAINTING.wouldFit(pos, side, this.possibleDecoPositions, this.usedDecoPositions) || !DungeonGenUtils.percentageRandom(dungeon.getPaintingChance(), this.random)) break;
                        RoomDecorTypes.PAINTING.buildRandom(world, pos, genArray, side, this.possibleDecoPositions, this.usedDecoPositions);
                        break;
                    }
                }
            }
        }
    }

    protected void addChests(World world, BlockStateGenArray genArray, DungeonRandomizedCastle dungeon) {
        if (this.getChestIDs() != null && !this.possibleChestLocs.isEmpty() && DungeonGenUtils.percentageRandom(50, this.random)) {
            RoomDecorChest chest = new RoomDecorChest();
            BlockPos pos = (BlockPos)this.possibleChestLocs.keySet().toArray()[this.random.nextInt(this.possibleChestLocs.size())];
            chest.build(world, genArray, this, dungeon, pos, this.possibleChestLocs.get(pos), this.usedDecoPositions);
        }
    }
}

