/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.world.structure.generation.generators.castleparts.rooms;

import java.util.Random;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import team.cqr.cqrepoured.util.BlockStateGenArray;
import team.cqr.cqrepoured.util.DungeonGenUtils;
import team.cqr.cqrepoured.util.GearedMobFactory;
import team.cqr.cqrepoured.world.structure.generation.dungeons.DungeonRandomizedCastle;
import team.cqr.cqrepoured.world.structure.generation.generators.castleparts.rooms.CastleRoomDecoratedBase;
import team.cqr.cqrepoured.world.structure.generation.generators.castleparts.rooms.EnumRoomType;

public class CastleRoomBossLandingMain
extends CastleRoomDecoratedBase {
    private static final int ROOMS_LONG = 2;
    private static final int ROOMS_SHORT = 1;
    private static final int LANDING_LENGTH_X = 3;
    private static final int LANDING_LENGTH_Z = 2;
    private static final int STAIR_OPENING_LENGTH_Z = 2;
    private static final int BOSS_ROOM_WIDTH = 17;
    private EnumFacing doorSide;
    private int numRotations;
    private int endX;
    private int lenX;
    private int endZ;
    private int lenZ;
    private int connectingWallLength;
    private int stairOpeningXStartIdx;
    private int stairOpeningXEndIdx;
    private int stairsDownZIdx;
    private int stairOpeningZStartIdx;
    private int stairOpeningZEndIdx;

    public CastleRoomBossLandingMain(int sideLength, int height, EnumFacing doorSide, int floor, Random rand) {
        super(sideLength, height, floor, rand);
        this.roomType = EnumRoomType.LANDING_BOSS;
        this.doorSide = doorSide;
        this.numRotations = DungeonGenUtils.getCWRotationsBetween(EnumFacing.NORTH, this.doorSide);
        this.defaultCeiling = true;
        this.endX = 2 * sideLength;
        this.lenX = this.endX + 1;
        this.endZ = 1 * sideLength - 1;
        this.lenZ = this.endZ + 1;
        this.stairOpeningXStartIdx = sideLength - 2;
        this.stairOpeningXEndIdx = this.stairOpeningXStartIdx + 3 - 1;
        this.stairsDownZIdx = 2;
        this.stairOpeningZStartIdx = 3;
        this.stairOpeningZEndIdx = this.stairOpeningZStartIdx + 2;
        int gapToBossRoom = 19 - this.lenX;
        this.connectingWallLength = 0;
        if (gapToBossRoom > 0) {
            this.connectingWallLength = (int)Math.ceil((double)gapToBossRoom / 2.0);
        }
    }

    @Override
    public void generateRoom(BlockPos castleOrigin, BlockStateGenArray genArray, DungeonRandomizedCastle dungeon) {
        for (int x = 0; x <= this.endX; ++x) {
            for (int y = 0; y < this.height; ++y) {
                for (int z = 0; z <= this.endZ; ++z) {
                    IBlockState blockToBuild = this.getBlockToBuild(dungeon, x, y, z);
                    Vec3i offset = DungeonGenUtils.rotateMatrixOffsetCW(new Vec3i(x, y, z), this.lenX, this.lenZ, this.numRotations);
                    genArray.addBlockState(this.roomOrigin.func_177971_a(offset), blockToBuild, BlockStateGenArray.GenerationPhase.MAIN, BlockStateGenArray.EnumPriority.MEDIUM);
                    if (blockToBuild.func_177230_c() == Blocks.field_150350_a) continue;
                    this.usedDecoPositions.add(this.roomOrigin.func_177971_a(offset));
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private IBlockState getBlockToBuild(DungeonRandomizedCastle dungeon, int x, int y, int z) {
        IBlockState blockToBuild = Blocks.field_150350_a.func_176223_P();
        if (z == 0) {
            if (x < this.connectingWallLength) return dungeon.getMainBlockState();
            if (x > this.endX - this.connectingWallLength) return dungeon.getMainBlockState();
            if (y == this.height - 1) {
                return dungeon.getMainBlockState();
            }
            if (y != 0) return blockToBuild;
            return Blocks.field_150371_ca.func_176223_P();
        }
        if (y == 0) {
            if (x < this.stairOpeningXStartIdx) return Blocks.field_150371_ca.func_176223_P();
            if (x > this.stairOpeningXEndIdx) return Blocks.field_150371_ca.func_176223_P();
            if (z < this.stairsDownZIdx) {
                return Blocks.field_150371_ca.func_176223_P();
            }
            if (z != this.stairsDownZIdx) return Blocks.field_150350_a.func_176223_P();
            EnumFacing stairFacing = DungeonGenUtils.rotateFacingNTimesAboutY(EnumFacing.NORTH, this.numRotations);
            return dungeon.getStairBlockState().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)stairFacing);
        }
        if (y != this.height - 1) return blockToBuild;
        return dungeon.getMainBlockState();
    }

    @Override
    public void decorate(World world, BlockStateGenArray genArray, DungeonRandomizedCastle dungeon, GearedMobFactory mobFactory) {
        this.addEdgeDecoration(world, genArray, dungeon);
        this.addWallDecoration(world, genArray, dungeon);
        this.addSpawners(world, genArray, dungeon, mobFactory);
    }

    @Override
    boolean shouldBuildEdgeDecoration() {
        return false;
    }

    @Override
    boolean shouldBuildWallDecoration() {
        return true;
    }

    @Override
    boolean shouldBuildMidDecoration() {
        return false;
    }

    @Override
    boolean shouldAddSpawners() {
        return true;
    }

    @Override
    boolean shouldAddChests() {
        return false;
    }

    @Override
    public boolean canBuildDoorOnSide(EnumFacing side) {
        return true;
    }

    @Override
    public boolean reachableFromSide(EnumFacing side) {
        return true;
    }
}

