/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.world.structure.generation.generation.preparable;

import io.netty.buffer.ByteBuf;
import java.util.function.Supplier;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import team.cqr.cqrepoured.init.CQRBlocks;
import team.cqr.cqrepoured.tileentity.TileEntityMap;
import team.cqr.cqrepoured.world.structure.generation.generation.DungeonPlacement;
import team.cqr.cqrepoured.world.structure.generation.generation.generatable.GeneratableBlockInfo;
import team.cqr.cqrepoured.world.structure.generation.generation.generatable.GeneratableMapInfo;
import team.cqr.cqrepoured.world.structure.generation.generation.generatable.GeneratablePosInfo;
import team.cqr.cqrepoured.world.structure.generation.generation.preparable.PreparablePosInfo;
import team.cqr.cqrepoured.world.structure.generation.structurefile.BlockStatePalette;

public class PreparableMapInfo
extends PreparablePosInfo {
    private final EnumFacing facing;
    private final byte scale;
    private final EnumFacing orientation;
    private final boolean lockOrientation;
    private final int originX;
    private final int originZ;
    private final int offsetX;
    private final int offsetZ;
    private final boolean fillMap;
    private final int fillRadius;

    public PreparableMapInfo(BlockPos pos, EnumFacing facing, TileEntityMap tileEntityMap) {
        this(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), facing, tileEntityMap);
    }

    public PreparableMapInfo(int x, int y, int z, EnumFacing facing, TileEntityMap tileEntityMap) {
        this(x, y, z, facing, (byte)tileEntityMap.getScale(), tileEntityMap.getOrientation(), tileEntityMap.lockOrientation(), tileEntityMap.getOriginX(), tileEntityMap.getOriginZ(), tileEntityMap.getOffsetX(), tileEntityMap.getOffsetZ(), tileEntityMap.fillMap(), tileEntityMap.getFillRadius());
    }

    public PreparableMapInfo(BlockPos pos, EnumFacing facing, byte scale, EnumFacing orientation, boolean lockOrientation, int originX, int originZ, int offsetX, int offsetZ, boolean fillMap, int fillRadius) {
        this(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), facing, scale, orientation, lockOrientation, originX, originZ, offsetX, offsetZ, fillMap, fillRadius);
    }

    public PreparableMapInfo(int x, int y, int z, EnumFacing facing, byte scale, EnumFacing orientation, boolean lockOrientation, int originX, int originZ, int offsetX, int offsetZ, boolean fillMap, int fillRadius) {
        super(x, y, z);
        this.facing = facing;
        this.scale = scale;
        this.orientation = orientation;
        this.lockOrientation = lockOrientation;
        this.originX = originX;
        this.originZ = originZ;
        this.offsetX = offsetX;
        this.offsetZ = offsetZ;
        this.fillMap = fillMap;
        this.fillRadius = fillRadius;
    }

    @Override
    protected GeneratablePosInfo prepare(World world, DungeonPlacement placement, BlockPos pos) {
        EnumFacing transformedFacing = placement.getRotation().func_185831_a(placement.getMirror().func_185803_b(this.facing));
        EntityItemFrame entity = new EntityItemFrame(world, pos.func_185334_h(), transformedFacing);
        switch (this.orientation) {
            case EAST: {
                entity.func_82336_g(entity.func_82333_j() + 3);
                break;
            }
            case SOUTH: {
                entity.func_82336_g(entity.func_82333_j() + 2);
                break;
            }
            case WEST: {
                entity.func_82336_g(entity.func_82333_j() + 1);
                break;
            }
        }
        int x1 = this.offsetX * (128 << this.scale);
        int z1 = this.offsetZ * (128 << this.scale);
        int x2 = this.originX;
        int z2 = this.originZ;
        switch (placement.getMirror()) {
            case LEFT_RIGHT: {
                if (!this.lockOrientation) {
                    if (this.orientation.func_176740_k() == EnumFacing.Axis.Z) {
                        entity.func_82336_g(entity.func_82333_j() + 2);
                    }
                    z1 = -z1;
                } else {
                    if (this.orientation.func_176740_k() == EnumFacing.Axis.X) {
                        z1 = -z1;
                    }
                    if (this.orientation.func_176740_k() == EnumFacing.Axis.Z) {
                        x1 = -x1;
                    }
                }
                z2 = -z2;
                break;
            }
            case FRONT_BACK: {
                if (!this.lockOrientation) {
                    if (this.orientation.func_176740_k() == EnumFacing.Axis.X) {
                        entity.func_82336_g(entity.func_82333_j() + 2);
                    }
                    x1 = -x1;
                } else {
                    if (this.orientation.func_176740_k() == EnumFacing.Axis.X) {
                        z1 = -z1;
                    }
                    if (this.orientation.func_176740_k() == EnumFacing.Axis.Z) {
                        x1 = -x1;
                    }
                }
                x2 = -x2;
                break;
            }
        }
        int x3 = x1;
        int z3 = z1;
        int x4 = x2;
        int z4 = z2;
        switch (placement.getRotation()) {
            case COUNTERCLOCKWISE_90: {
                if (!this.lockOrientation) {
                    entity.func_82336_g(entity.func_82333_j() + 1);
                    x1 = z3;
                    z1 = -x3;
                }
                x2 = z4;
                z2 = -x4;
                break;
            }
            case CLOCKWISE_90: {
                if (!this.lockOrientation) {
                    entity.func_82336_g(entity.func_82333_j() + 3);
                    x1 = -z3;
                    z1 = x3;
                }
                x2 = -z4;
                z2 = x4;
                break;
            }
            case CLOCKWISE_180: {
                if (!this.lockOrientation) {
                    entity.func_82336_g(entity.func_82333_j() + 2);
                    x1 = -x3;
                    z1 = -z3;
                }
                x2 = -x4;
                z2 = -z4;
                break;
            }
        }
        return new GeneratableMapInfo(pos, entity, pos.func_177958_n() + x2, pos.func_177952_p() + z2, pos.func_177958_n() + x1 + x2, pos.func_177952_p() + z1 + z2, this.scale, this.fillMap, this.fillRadius);
    }

    @Override
    protected GeneratablePosInfo prepareDebug(World world, DungeonPlacement placement, BlockPos pos) {
        IBlockState state = CQRBlocks.MAP_PLACEHOLDER.func_176223_P().func_177226_a((IProperty)BlockHorizontal.field_185512_D, (Comparable)this.facing);
        state = state.func_185902_a(placement.getMirror()).func_185907_a(placement.getRotation());
        TileEntityMap tileEntity = new TileEntityMap();
        tileEntity.set(this.scale, this.orientation, this.lockOrientation, this.originX, this.originZ, this.offsetX, this.offsetZ, this.fillMap, this.fillRadius);
        return new GeneratableBlockInfo(pos, state, tileEntity);
    }

    public EnumFacing getFacing() {
        return this.facing;
    }

    public int getScale() {
        return this.scale;
    }

    public EnumFacing getOrientation() {
        return this.orientation;
    }

    public boolean isLockOrientation() {
        return this.lockOrientation;
    }

    public int getOriginX() {
        return this.originX;
    }

    public int getOriginZ() {
        return this.originZ;
    }

    public int getOffsetX() {
        return this.offsetX;
    }

    public int getOffsetZ() {
        return this.offsetZ;
    }

    public boolean isFillMap() {
        return this.fillMap;
    }

    public int getFillRadius() {
        return this.fillRadius;
    }

    public static class Serializer
    implements PreparablePosInfo.Registry.ISerializer<PreparableMapInfo> {
        @Override
        public void write(PreparableMapInfo preparable, ByteBuf buf, BlockStatePalette palette, NBTTagList nbtList) {
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74774_a("facing", (byte)preparable.facing.func_176736_b());
            compound.func_74774_a("scale", preparable.scale);
            compound.func_74774_a("orientation", (byte)preparable.orientation.func_176736_b());
            compound.func_74757_a("lockOrientation", preparable.lockOrientation);
            compound.func_74774_a("originX", (byte)preparable.originX);
            compound.func_74774_a("originZ", (byte)preparable.originZ);
            compound.func_74774_a("offsetX", (byte)preparable.offsetX);
            compound.func_74774_a("offsetZ", (byte)preparable.offsetZ);
            compound.func_74757_a("fillMap", preparable.fillMap);
            compound.func_74777_a("fillRadius", (short)preparable.fillRadius);
            ByteBufUtils.writeVarInt((ByteBuf)buf, (int)nbtList.func_74745_c(), (int)5);
            nbtList.func_74742_a((NBTBase)compound);
        }

        @Override
        public PreparableMapInfo read(int x, int y, int z, ByteBuf buf, BlockStatePalette palette, NBTTagList nbtList) {
            NBTTagCompound compound = nbtList.func_150305_b(ByteBufUtils.readVarInt((ByteBuf)buf, (int)5));
            EnumFacing facing = EnumFacing.func_176731_b((int)compound.func_74762_e("facing"));
            byte scale = compound.func_74771_c("scale");
            EnumFacing orientation = EnumFacing.func_176731_b((int)compound.func_74762_e("orientation"));
            boolean lockOrientation = compound.func_74767_n("lockOrientation");
            byte originX = compound.func_74771_c("originX");
            byte originZ = compound.func_74771_c("originZ");
            byte offsetX = compound.func_74771_c("offsetX");
            byte offsetZ = compound.func_74771_c("offsetZ");
            boolean fillMap = compound.func_74767_n("fillMap");
            short fillRadius = compound.func_74765_d("fillRadius");
            return new PreparableMapInfo(x, y, z, facing, scale, orientation, lockOrientation, originX, originZ, offsetX, offsetZ, fillMap, fillRadius);
        }

        @Override
        @Deprecated
        public PreparableMapInfo read(int x, int y, int z, NBTTagIntArray nbtIntArray, BlockStatePalette palette, NBTTagList nbtList) {
            int[] intArray = nbtIntArray.func_150302_c();
            NBTTagCompound compound = nbtList.func_150305_b(intArray[0]);
            EnumFacing facing = EnumFacing.func_176731_b((int)compound.func_74762_e("facing"));
            byte scale = compound.func_74771_c("scale");
            EnumFacing orientation = EnumFacing.func_176731_b((int)compound.func_74762_e("orientation"));
            boolean lockOrientation = compound.func_74767_n("lockOrientation");
            byte originX = compound.func_74771_c("originX");
            byte originZ = compound.func_74771_c("originZ");
            byte offsetX = compound.func_74771_c("offsetX");
            byte offsetZ = compound.func_74771_c("offsetZ");
            boolean fillMap = compound.func_74767_n("fillMap");
            short fillRadius = compound.func_74765_d("fillRadius");
            return new PreparableMapInfo(x, y, z, facing, scale, orientation, lockOrientation, originX, originZ, offsetX, offsetZ, fillMap, fillRadius);
        }
    }

    public static class Factory
    implements PreparablePosInfo.Registry.IFactory<TileEntityMap> {
        @Override
        public PreparablePosInfo create(World world, int x, int y, int z, IBlockState state, Supplier<TileEntityMap> tileEntitySupplier) {
            return new PreparableMapInfo(x, y, z, (EnumFacing)state.func_177229_b((IProperty)BlockHorizontal.field_185512_D), tileEntitySupplier.get());
        }
    }
}

