/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.world.structure.generation.generation.generatable;

import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import team.cqr.cqrepoured.util.BlockPlacingHelper;
import team.cqr.cqrepoured.world.structure.generation.generation.GeneratableDungeon;
import team.cqr.cqrepoured.world.structure.generation.generation.generatable.IGeneratable;

public abstract class GeneratablePosInfo
implements IGeneratable,
BlockPlacingHelper.IBlockInfo {
    private static final BlockPos.MutableBlockPos MUTABLE = new BlockPos.MutableBlockPos();
    private final int x;
    private final int y;
    private final int z;

    protected GeneratablePosInfo(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    protected GeneratablePosInfo(BlockPos pos) {
        this(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    @Override
    public void generate(World world, GeneratableDungeon dungeon) {
        Chunk chunk = world.func_72964_e(this.x >> 4, this.z >> 4);
        if (this.y < 0 || this.y > 256) {
            return;
        }
        ExtendedBlockStorage blockStorage = chunk.func_76587_i()[this.y >> 4];
        if (blockStorage == null) {
            blockStorage = new ExtendedBlockStorage(this.y >> 4 << 4, world.field_73011_w.func_191066_m());
            if (this.place(world, chunk, blockStorage, dungeon)) {
                chunk.func_76587_i()[this.y >> 4] = blockStorage;
            }
        } else {
            this.place(world, chunk, blockStorage, dungeon);
        }
    }

    @Override
    public boolean place(World world, Chunk chunk, ExtendedBlockStorage blockStorage, GeneratableDungeon dungeon) {
        return this.place(world, chunk, blockStorage, (BlockPos)MUTABLE.func_181079_c(this.x, this.y, this.z), dungeon);
    }

    protected abstract boolean place(World var1, Chunk var2, ExtendedBlockStorage var3, BlockPos var4, GeneratableDungeon var5);

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }

    public int getChunkX() {
        return this.x >> 4;
    }

    public int getChunkY() {
        return this.y >> 4;
    }

    public int getChunkZ() {
        return this.z >> 4;
    }
}

