/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.world.structure.generation.generation.generatable;

import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import team.cqr.cqrepoured.util.BlockPlacingHelper;
import team.cqr.cqrepoured.world.structure.generation.generation.GeneratableDungeon;
import team.cqr.cqrepoured.world.structure.generation.generation.generatable.GeneratablePosInfo;

public class GeneratableBlockInfo
extends GeneratablePosInfo {
    private final IBlockState state;
    @Nullable
    private final TileEntity tileEntity;

    public GeneratableBlockInfo(int x, int y, int z, IBlockState state, @Nullable TileEntity tileEntity) {
        super(x, y, z);
        this.state = state;
        this.tileEntity = tileEntity;
    }

    public GeneratableBlockInfo(BlockPos pos, IBlockState state, @Nullable TileEntity tileEntity) {
        this(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), state, tileEntity);
    }

    @Override
    protected boolean place(World world, Chunk chunk, ExtendedBlockStorage blockStorage, BlockPos pos, GeneratableDungeon dungeon) {
        IBlockState oldState = blockStorage.func_177485_a(pos.func_177958_n() & 0xF, pos.func_177956_o() & 0xF, pos.func_177952_p() & 0xF);
        int oldLight = oldState.getLightValue((IBlockAccess)world, pos);
        if (!BlockPlacingHelper.setBlockState(world, chunk, blockStorage, pos, this.state, this.tileEntity, 16)) {
            return false;
        }
        if (oldLight > 0 && blockStorage.func_76674_d(pos.func_177958_n() & 0xF, pos.func_177956_o() & 0xF, pos.func_177952_p() & 0xF) > 0) {
            dungeon.markRemovedLight(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), oldLight);
        }
        return true;
    }

    public IBlockState getState() {
        return this.state;
    }

    @Nullable
    public TileEntity getTileEntity() {
        return this.tileEntity;
    }
}

