/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.util.tool;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.stream.IntStream;
import javax.imageio.ImageIO;
import javax.imageio.stream.FileImageOutputStream;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.crash.CrashReport;
import net.minecraft.init.Blocks;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ReportedException;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.layer.IntCache;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.DimensionManager;
import team.cqr.cqrepoured.util.DungeonGenUtils;
import team.cqr.cqrepoured.util.tool.DummyWorld;
import team.cqr.cqrepoured.util.tool.Progress;
import team.cqr.cqrepoured.world.structure.generation.WorldDungeonGenerator;
import team.cqr.cqrepoured.world.structure.generation.dungeons.DungeonBase;

public class DungeonMapTask {
    private static final Object2IntMap<Biome> biomeColorCache = new Object2IntOpenHashMap();
    private static final BufferedImage[] icons = (BufferedImage[])IntStream.range(0, 20).mapToObj(i -> {
        Minecraft mc = Minecraft.func_71410_x();
        IResourceManager resourceManager = mc.func_110442_L();
        try (IResource resource = resourceManager.func_110536_a(new ResourceLocation("cqrepoured", "textures/gui/map/d" + i + ".png"));){
            BufferedImage bufferedImage = TextureUtil.func_177053_a((InputStream)resource.func_110527_b());
            return bufferedImage;
        }
        catch (IOException e) {
            CrashReport crash = new CrashReport("Failed loading dungeon icons", (Throwable)e);
            throw new ReportedException(crash);
        }
    }).toArray(BufferedImage[]::new);
    private final int radiusChunks;
    private final int sizeChunks;
    private final int radiusBlocks;
    private final int sizeBlocks;
    private final long seed;
    private final boolean generateBiomes;
    private DummyWorld world;
    private BufferedImage image;
    private final Progress progress = new Progress(4);
    private volatile boolean cancelled;

    public DungeonMapTask(int radiusChunks, long seed, boolean generateBiomes) {
        this.radiusChunks = radiusChunks;
        this.sizeChunks = this.radiusChunks * 2 + 1;
        this.radiusBlocks = this.radiusChunks << 4;
        this.sizeBlocks = this.sizeChunks << 4;
        this.seed = seed;
        this.generateBiomes = generateBiomes;
    }

    public CompletableFuture<Void> run() {
        this.world = DummyWorld.create(this.seed, WorldType.field_77137_b.func_77127_a(), 0);
        this.image = new BufferedImage(this.sizeBlocks, this.sizeBlocks, 1);
        return ((CompletableFuture)((CompletableFuture)((CompletableFuture)CompletableFuture.runAsync(this::exportBiomes).thenRunAsync(this::exportGrid)).thenRunAsync(this::exportDungeons)).thenRunAsync(this::exportImage)).handleAsync((v, t) -> {
            WorldServer world;
            if (t != null) {
                this.progress.setErrored();
            }
            if ((world = DimensionManager.getWorld((int)0)) != null) {
                DimensionManager.setWorld((int)0, null, (MinecraftServer)world.func_73046_m());
            }
            DungeonMapTask.hardResetIntCache();
            return null;
        });
    }

    private void exportBiomes() {
        if (this.cancelled) {
            return;
        }
        if (this.generateBiomes) {
            DataBuffer dataBuffer = this.image.getRaster().getDataBuffer();
            for (int x = 0; x < this.sizeBlocks; ++x) {
                if (this.cancelled) {
                    return;
                }
                for (int z = 0; z < this.sizeBlocks; ++z) {
                    int i = z * this.sizeBlocks + x;
                    Biome biome = this.world.getBiome(x - this.radiusBlocks, z - this.radiusBlocks);
                    int color = DungeonMapTask.color((World)this.world, biome);
                    dataBuffer.setElem(i, color);
                }
                this.progress.setProgress((double)x / (double)(this.sizeBlocks - 1));
            }
        }
        this.progress.finishStage();
    }

    private void exportGrid() {
        int z;
        int x;
        if (this.cancelled) {
            return;
        }
        DataBuffer dataBuffer = this.image.getRaster().getDataBuffer();
        int spawnX = DungeonGenUtils.getSpawnX((World)this.world) >> 4 << 4;
        int spawnZ = DungeonGenUtils.getSpawnZ((World)this.world) >> 4 << 4;
        int gridSize = 320;
        for (x = 0; x < this.sizeBlocks; ++x) {
            if (this.cancelled) {
                return;
            }
            boolean gridX = Math.floorMod(x - this.radiusBlocks - spawnX - 8 + 1 - 320, gridSize) <= 1;
            for (z = 0; z < this.sizeBlocks; ++z) {
                int i = z * this.sizeBlocks + x;
                if (!gridX && Math.floorMod(z - this.radiusBlocks - spawnZ - 8 + 1 - 320, gridSize) > 1) continue;
                dataBuffer.setElem(i, 986895);
            }
            this.progress.setProgress((double)x / (double)(this.sizeBlocks - 1));
        }
        for (x = 0; x < 16; ++x) {
            int ix = x + this.radiusBlocks + spawnX;
            if (ix < 0 || ix > this.sizeBlocks) continue;
            for (z = 0; z < 16; ++z) {
                int iz = z + this.radiusBlocks + spawnZ;
                if (iz < 0 || iz > this.sizeBlocks) continue;
                dataBuffer.setElem(iz * this.sizeBlocks + ix, 0xFF0000);
            }
        }
        this.progress.finishStage();
    }

    private void exportDungeons() {
        if (this.cancelled) {
            return;
        }
        DataBuffer dataBuffer = this.image.getRaster().getDataBuffer();
        int scale = 4;
        for (int x = -this.radiusChunks; x <= this.radiusChunks; ++x) {
            if (this.cancelled) {
                return;
            }
            for (int z = -this.radiusChunks; z <= this.radiusChunks; ++z) {
                DungeonBase dungeon = WorldDungeonGenerator.getDungeonAt((World)this.world, x, z);
                if (dungeon == null) continue;
                BufferedImage icon = icons[dungeon.getIconID()];
                int width = icon.getWidth();
                int height = icon.getHeight();
                for (int ix = -width / 2; ix < width - width / 2; ++ix) {
                    for (int iy = -height / 2; iy < height - height / 2; ++iy) {
                        int newColor = icon.getRGB(ix + width / 2, iy + height / 2);
                        for (int i = 0; i < scale; ++i) {
                            int k = (x + this.radiusChunks << 4) + 8 + ix * scale + i;
                            if (k < 0 || k >= this.sizeBlocks) continue;
                            for (int j = 0; j < scale; ++j) {
                                int l = (z + this.radiusChunks << 4) + 8 + iy * scale + j;
                                if (l < 0 || l >= this.sizeBlocks) continue;
                                dataBuffer.setElem(l * this.sizeBlocks + k, newColor);
                            }
                        }
                    }
                    Graphics2D graphics = this.image.createGraphics();
                    graphics.setColor(Color.BLACK);
                    graphics.setFont(new Font("Arial", 1, 24));
                    graphics.drawString(dungeon.getDungeonName(), (x + this.radiusChunks << 4) + 8 - 9 * scale, (z + this.radiusChunks << 4) + 8 - 10 * scale);
                }
            }
            this.progress.setProgress((double)(x + this.radiusChunks) / (double)this.sizeChunks);
        }
        this.progress.finishStage();
    }

    private void exportImage() {
        if (this.cancelled) {
            return;
        }
        final double d = (double)(this.image.getWidth() * this.image.getHeight()) * 0.045;
        try (FileImageOutputStream out = new FileImageOutputStream(new File("CQR-MapTool/dungeon_map.png")){

            @Override
            public void write(int b) throws IOException {
                super.write(b);
                DungeonMapTask.this.progress.setProgress((double)this.streamPos / d);
            }

            @Override
            public void write(byte[] b, int off, int len) throws IOException {
                super.write(b, off, len);
                DungeonMapTask.this.progress.setProgress((double)this.streamPos / d);
            }
        };){
            ImageIO.write((RenderedImage)this.image, "png", out);
        }
        catch (IOException e) {
            throw new CancellationException("Failed exporting dungeon map!");
        }
        this.progress.finishStage();
    }

    public Progress getProgress() {
        return this.progress;
    }

    public void cancel() {
        this.progress.setCancelled();
        this.cancelled = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void hardResetIntCache() {
        Class<IntCache> clazz = IntCache.class;
        synchronized (IntCache.class) {
            IntCache.field_76451_a = 256;
            IntCache.field_76449_b.clear();
            IntCache.field_76447_d.clear();
            IntCache.field_76450_c.clear();
            IntCache.field_76448_e.clear();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private static int color(World world, Biome biome) {
        return (Integer)biomeColorCache.computeIfAbsent((Object)biome, k -> {
            Set types = BiomeDictionary.getTypes((Biome)k);
            IntArrayList colors = new IntArrayList();
            if (types.contains(BiomeDictionary.Type.VOID)) {
                colors.add(986895);
            }
            if (types.contains(BiomeDictionary.Type.END)) {
                colors.add(DungeonMapTask.color(world, Blocks.field_150377_bs));
            }
            if (types.contains(BiomeDictionary.Type.NETHER)) {
                colors.add(DungeonMapTask.color(world, Blocks.field_150424_aL));
            }
            if (types.contains(BiomeDictionary.Type.MUSHROOM)) {
                colors.add(DungeonMapTask.color(world, Blocks.field_150420_aW));
            }
            if (types.contains(BiomeDictionary.Type.WATER)) {
                colors.add(DungeonMapTask.color(world, (Block)Blocks.field_150355_j));
            }
            if (types.contains(BiomeDictionary.Type.BEACH)) {
                colors.add(DungeonMapTask.color(world, (Block)Blocks.field_150354_m));
            }
            if (types.contains(BiomeDictionary.Type.SNOWY)) {
                colors.add(DungeonMapTask.color(world, Blocks.field_150433_aE));
            }
            if (types.contains(BiomeDictionary.Type.MESA)) {
                colors.add(DungeonMapTask.color(world, Blocks.field_180395_cM));
            }
            if (types.contains(BiomeDictionary.Type.SANDY)) {
                colors.add(DungeonMapTask.color(world, (Block)Blocks.field_150354_m));
            }
            if (types.contains(BiomeDictionary.Type.SWAMP)) {
                colors.add(6258432);
            }
            if (types.contains(BiomeDictionary.Type.SAVANNA)) {
                colors.add(12558080);
            }
            if (types.contains(BiomeDictionary.Type.CONIFEROUS)) {
                colors.add(19456);
            }
            if (types.contains(BiomeDictionary.Type.JUNGLE)) {
                colors.add(52224);
            }
            if (types.contains(BiomeDictionary.Type.FOREST)) {
                colors.add(31744);
            }
            if (types.contains(BiomeDictionary.Type.MOUNTAIN)) {
                colors.add(DungeonMapTask.color(world, Blocks.field_150348_b));
            }
            if (types.contains(BiomeDictionary.Type.PLAINS)) {
                colors.add(DungeonMapTask.color(world, (Block)Blocks.field_150349_c));
            }
            if (colors.isEmpty()) {
                return 0;
            }
            int r = 0;
            int g = 0;
            int b = 0;
            for (int i = 0; i < colors.size(); ++i) {
                int c = colors.getInt(i);
                r += c >> 16 & 0xFF;
                g += c >> 8 & 0xFF;
                b += c & 0xFF;
            }
            return (r /= colors.size()) << 16 | (g /= colors.size()) << 8 | (b /= colors.size());
        });
    }

    private static int color(World world, Block block) {
        return DungeonMapTask.color(world, block.func_176223_P());
    }

    private static int color(World world, IBlockState state) {
        return state.func_185909_g((IBlockAccess)world, (BlockPos)BlockPos.field_177992_a).field_76291_p;
    }
}

