/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.util;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;

public class VectorUtil {
    public static Vec3d rotateVectorAroundY(Vec3d vector, double degrees) {
        return vector.func_178785_b((float)Math.toRadians(degrees));
    }

    public static double getAngleBetween(Vec3d axis, Vec3d vector) {
        double cosphi = axis.func_72430_b(vector);
        double phi = Math.acos(cosphi /= axis.func_72433_c() * vector.func_72433_c());
        return Math.toDegrees(phi);
    }

    public static Vec3i rotateVector(EAxis axis, Vec3i vector, Double degrees) {
        double rad = Math.toRadians(degrees);
        double currentX = vector.func_177958_n();
        double currentZ = vector.func_177952_p();
        double currentY = vector.func_177956_o();
        double cosine = Math.cos(rad);
        double sine = Math.sin(rad);
        switch (axis) {
            case AXIS_X: {
                return new Vec3i((double)vector.func_177958_n(), currentY * cosine - currentZ * sine, currentY * sine - currentZ * cosine);
            }
            case AXIS_Y: {
                return new Vec3i(cosine * currentX - sine * currentZ, (double)vector.func_177956_o(), sine * currentX + cosine * currentZ);
            }
            case AXIS_Z: {
                return new Vec3i(currentX * cosine - currentY * sine, currentX * sine - currentY * cosine, (double)vector.func_177952_p());
            }
        }
        return null;
    }

    public static Vec3i rotateVectorAroundY(Vec3i newPos, double degrees) {
        Vec3d res = VectorUtil.rotateVectorAroundY(new Vec3d((double)newPos.func_177958_n(), (double)newPos.func_177956_o(), (double)newPos.func_177952_p()), degrees);
        return new Vec3i(Math.floor(res.field_72450_a), Math.floor(res.field_72448_b), Math.floor(res.field_72449_c));
    }

    public static Vec3i vectorAdd(Vec3i start, int x, int y, int z) {
        return new Vec3i(start.func_177958_n() + x, start.func_177956_o() + y, start.func_177952_p() + z);
    }

    public static NBTTagCompound createVectorNBTTag(Vec3d vector) {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        nbttagcompound.func_74780_a("X", vector.field_72450_a);
        nbttagcompound.func_74780_a("Y", vector.field_72448_b);
        nbttagcompound.func_74780_a("Z", vector.field_72449_c);
        return nbttagcompound;
    }

    public static Vec3d getVectorFromTag(NBTTagCompound tag) {
        return new Vec3d(tag.func_74769_h("X"), tag.func_74769_h("Y"), tag.func_74769_h("Z"));
    }

    public static Vec3d rotateAroundAnyAxis(Vec3d axis, Vec3d toBeRotated, double rotationDegrees) {
        return VectorUtil.rotate(axis, toBeRotated, Math.toRadians(rotationDegrees));
    }

    public static Vec3d rotate(Vec3d axis, Vec3d vec, double radian) {
        double d = MathHelper.func_76126_a((float)((float)(radian * 0.5)));
        double i = d * axis.field_72450_a;
        double j = d * axis.field_72448_b;
        double k = d * axis.field_72449_c;
        double r = MathHelper.func_76134_b((float)((float)(radian * 0.5)));
        double i2 = 2.0 * i * i;
        double j2 = 2.0 * j * j;
        double k2 = 2.0 * k * k;
        double ij = 2.0 * i * j;
        double jk = 2.0 * j * k;
        double ik = 2.0 * i * k;
        double ir = 2.0 * i * r;
        double jr = 2.0 * j * r;
        double kr = 2.0 * k * r;
        double d00 = 1.0 - (j2 + k2);
        double d01 = ij - kr;
        double d02 = ik + jr;
        double d10 = ij + kr;
        double d11 = 1.0 - (i2 + k2);
        double d12 = jk - ir;
        double d20 = ik - jr;
        double d21 = jk + ir;
        double d22 = 1.0 - (i2 + j2);
        return new Vec3d(vec.field_72450_a * d00 + vec.field_72448_b * d01 + vec.field_72449_c * d02, vec.field_72450_a * d10 + vec.field_72448_b * d11 + vec.field_72449_c * d12, vec.field_72450_a * d20 + vec.field_72448_b * d21 + vec.field_72449_c * d22);
    }

    public static enum EAxis {
        AXIS_Y,
        AXIS_X,
        AXIS_Z;

    }
}

