/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.util;

import java.util.Random;
import javax.annotation.Nullable;
import meldexun.reflectionutil.ReflectionMethod;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.gen.ChunkGeneratorDebug;
import net.minecraft.world.gen.ChunkGeneratorEnd;
import net.minecraft.world.gen.ChunkGeneratorFlat;
import net.minecraft.world.gen.ChunkGeneratorHell;
import net.minecraft.world.gen.ChunkGeneratorOverworld;
import net.minecraft.world.gen.ChunkGeneratorSettings;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.structure.MapGenMineshaft;
import net.minecraft.world.gen.structure.MapGenStructure;
import team.cqr.cqrepoured.CQRMain;
import team.cqr.cqrepoured.integration.ancientwarfare.AW2Integration;

public class StructureHelper {
    private static final ReflectionMethod<Boolean> METHOD_CAN_SPAWN_STRUCTURE_AT_COORDS = new ReflectionMethod(MapGenStructure.class, "func_75047_a", "canSpawnStructureAtCoords", Integer.TYPE, Integer.TYPE);

    public static boolean isStructureInRange(World world, BlockPos pos, int radius, String name) {
        BlockPos structurePos;
        if (!world.func_72912_H().func_76089_r()) {
            return false;
        }
        if (name.equals("AW2")) {
            if (!CQRMain.isAW2Installed) {
                return false;
            }
            return AW2Integration.isAW2StructureInRange(world, pos, radius);
        }
        IChunkGenerator chunkGenerator = ((WorldServer)world).func_72863_F().field_186029_c;
        if (chunkGenerator instanceof ChunkGeneratorOverworld || chunkGenerator instanceof ChunkGeneratorHell || chunkGenerator instanceof ChunkGeneratorEnd || chunkGenerator instanceof ChunkGeneratorFlat || chunkGenerator instanceof ChunkGeneratorDebug) {
            MapGenStructure structureGenerator = StructureHelper.getStructureGenerator(world, name);
            if (structureGenerator != null) {
                return StructureHelper.isStructureInRange(world, structureGenerator, pos, radius);
            }
            return false;
        }
        try {
            structurePos = chunkGenerator.func_180513_a(world, name, pos, false);
            if (structurePos != null && (Math.abs(structurePos.func_177958_n() - pos.func_177958_n()) <= radius || Math.abs(structurePos.func_177952_p() - pos.func_177952_p()) <= radius)) {
                return true;
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            structurePos = chunkGenerator.func_180513_a(world, name, pos, true);
            if (structurePos != null && (Math.abs(structurePos.func_177958_n() - pos.func_177958_n()) <= radius || Math.abs(structurePos.func_177952_p() - pos.func_177952_p()) <= radius)) {
                return true;
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return false;
    }

    @Nullable
    private static MapGenStructure getStructureGenerator(World world, String name) {
        IChunkGenerator chunkGenerator = ((WorldServer)world).func_72863_F().field_186029_c;
        if (chunkGenerator instanceof ChunkGeneratorOverworld) {
            if (!((ChunkGeneratorOverworld)chunkGenerator).field_185996_o) {
                return null;
            }
            ChunkGeneratorSettings settings = ((ChunkGeneratorOverworld)chunkGenerator).field_186000_s;
            switch (name) {
                case "Stronghold": {
                    if (!settings.field_177833_u) {
                        return null;
                    }
                    return ((ChunkGeneratorOverworld)chunkGenerator).field_186004_w;
                }
                case "Village": {
                    if (!settings.field_177831_v) {
                        return null;
                    }
                    return ((ChunkGeneratorOverworld)chunkGenerator).field_186005_x;
                }
                case "Mineshaft": {
                    if (!settings.field_177829_w) {
                        return null;
                    }
                    return ((ChunkGeneratorOverworld)chunkGenerator).field_186006_y;
                }
                case "Temple": {
                    if (!settings.field_177854_x) {
                        return null;
                    }
                    return ((ChunkGeneratorOverworld)chunkGenerator).field_186007_z;
                }
                case "Monument": {
                    if (!settings.field_177852_y) {
                        return null;
                    }
                    return ((ChunkGeneratorOverworld)chunkGenerator).field_185980_B;
                }
                case "Mansion": {
                    if (!settings.field_191077_z) {
                        return null;
                    }
                    return ((ChunkGeneratorOverworld)chunkGenerator).field_191060_C;
                }
            }
        } else if (chunkGenerator instanceof ChunkGeneratorHell) {
            if (!((ChunkGeneratorHell)chunkGenerator).field_185953_o) {
                return null;
            }
            if (name.equals("Fortress")) {
                return ((ChunkGeneratorHell)chunkGenerator).field_73172_c;
            }
        } else if (chunkGenerator instanceof ChunkGeneratorEnd) {
            if (!((ChunkGeneratorEnd)chunkGenerator).field_73229_q) {
                return null;
            }
            if (name.equals("EndCity")) {
                return ((ChunkGeneratorEnd)chunkGenerator).field_185972_n;
            }
        } else if (chunkGenerator instanceof ChunkGeneratorFlat) {
            return (MapGenStructure)((ChunkGeneratorFlat)chunkGenerator).field_82696_f.get(name);
        }
        return null;
    }

    private static boolean isStructureInRange(World world, MapGenStructure structureType, BlockPos pos, int radius) {
        int x = pos.func_177958_n() >> 4;
        int z = pos.func_177952_p() >> 4;
        Random random = structureType.field_75038_b;
        structureType.field_75039_c = world;
        for (int r = 0; r <= radius; ++r) {
            for (int x1 = -r; x1 <= r; ++x1) {
                boolean flag = x1 == -r || x1 == r;
                for (int z1 = -r; z1 <= r; ++z1) {
                    if (!flag && z1 != -r && z1 != r) continue;
                    int x2 = x + x1;
                    int z2 = z + z1;
                    if (structureType instanceof MapGenMineshaft) {
                        random.setSeed((long)(x2 ^ z2) ^ world.func_72905_C());
                        random.nextInt();
                    }
                    if (!METHOD_CAN_SPAWN_STRUCTURE_AT_COORDS.invoke(structureType, x2, z2).booleanValue()) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

