/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import team.cqr.cqrepoured.CQRMain;

public class ConfigBackupHandler {
    private static final Map<String, String> CONFIG_VERSION_MAP = new HashMap<String, String>();

    public static void registerConfig(String configFile, String configVersion) {
        if (configFile == null) {
            throw new NullPointerException("Argument configFile cannot be null!");
        }
        if (configFile.isEmpty()) {
            throw new IllegalArgumentException("Argument configFile cannot be empty!");
        }
        if (configVersion == null) {
            throw new NullPointerException("Argument configVersion cannot be null!");
        }
        if (configVersion.isEmpty()) {
            throw new IllegalArgumentException("Argument configVersion cannot be empty!");
        }
        if (CONFIG_VERSION_MAP.containsKey(configFile)) {
            throw new IllegalArgumentException("Config is already registered! " + configFile);
        }
        CONFIG_VERSION_MAP.put(configFile, configVersion);
    }

    public static void checkAndBackupConfigs() {
        if (!CQRMain.CQ_CONFIG_FOLDER.exists()) {
            return;
        }
        ArrayList<File> filesToBackup = new ArrayList<File>();
        File configVersionsFile = new File(CQRMain.CQ_CONFIG_FOLDER, "configVersions.properties");
        try {
            if (!configVersionsFile.exists()) {
                configVersionsFile.createNewFile();
            }
            Properties prop = new Properties();
            Throwable throwable = null;
            try (FileInputStream in = new FileInputStream(configVersionsFile);){
                prop.load(in);
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                throw throwable2;
            }
            for (Map.Entry entry : CONFIG_VERSION_MAP.entrySet()) {
                File file;
                if (!((String)entry.getValue()).equals(prop.get(entry.getKey())) && (file = new File(CQRMain.CQ_CONFIG_FOLDER, (String)entry.getKey())).exists()) {
                    filesToBackup.add(file);
                }
                prop.setProperty((String)entry.getKey(), (String)entry.getValue());
            }
            Throwable throwable4 = null;
            try (FileOutputStream out = new FileOutputStream(configVersionsFile);){
                prop.store(out, "Do NOT modify this file unless you know what you are doing!");
            }
            catch (Throwable file) {
                Throwable throwable5 = file;
                throw file;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (!filesToBackup.isEmpty()) {
            File backupFolder = new File(CQRMain.CQ_CONFIG_FOLDER, "backup");
            backupFolder.mkdirs();
            LocalDateTime dateTime = LocalDateTime.now();
            String string = dateTime.toLocalDate() + "_" + dateTime.getHour() + "-" + dateTime.getMinute() + "-" + dateTime.getSecond();
            File backupFile = new File(backupFolder, string + ".zip");
            if (backupFile.exists()) {
                int i = 1;
                while ((backupFile = new File(backupFolder, string + "_" + i++ + ".zip")).exists()) {
                }
            }
            try {
                if (!backupFile.exists()) {
                    backupFile.createNewFile();
                }
                try (ZipOutputStream out = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(backupFile)));){
                    int i = CQRMain.CQ_CONFIG_FOLDER.getAbsolutePath().length() + 1;
                    for (File fileToBackup : filesToBackup) {
                        if (fileToBackup.isDirectory()) {
                            for (File file : FileUtils.listFiles((File)fileToBackup, null, (boolean)true)) {
                                out.putNextEntry(new ZipEntry(file.getAbsolutePath().substring(i)));
                                try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));){
                                    int b;
                                    while ((b = ((InputStream)in).read()) != -1) {
                                        out.write(b);
                                    }
                                }
                                out.closeEntry();
                            }
                            FileUtils.deleteQuietly((File)fileToBackup);
                            continue;
                        }
                        out.putNextEntry(new ZipEntry(fileToBackup.getAbsolutePath().substring(i)));
                        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(fileToBackup));){
                            int b;
                            while ((b = ((InputStream)in).read()) != -1) {
                                out.write(b);
                            }
                        }
                        out.closeEntry();
                        FileUtils.deleteQuietly((File)fileToBackup);
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        configVersionsFile.toString();
    }
}

