/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.util;

import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import team.cqr.cqrepoured.CQRMain;
import team.cqr.cqrepoured.integration.cubicchunks.CubicChunks;

public class CachedBlockAccess
implements IBlockAccess {
    private final BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
    private World level;
    private Chunk cachedChunk;
    private ExtendedBlockStorage cachedSection;

    public void setupCached(World level) {
        this.level = level;
        this.cachedChunk = null;
        this.cachedSection = null;
    }

    public void clearCache() {
        this.level = null;
        this.cachedChunk = null;
        this.cachedSection = null;
    }

    public Chunk getChunk(int chunkX, int chunkZ) {
        if (this.cachedChunk == null || this.cachedChunk.field_76635_g != chunkX || this.cachedChunk.field_76647_h != chunkZ) {
            this.cachedChunk = this.level.func_72964_e(chunkX, chunkZ);
            this.cachedSection = null;
        }
        return this.cachedChunk;
    }

    @Nullable
    public ExtendedBlockStorage getChunkSection(int chunkX, int chunkY, int chunkZ) {
        return this.getChunkSection((BlockPos)this.mutable.func_181079_c(chunkX << 4, chunkY << 4, chunkZ << 4));
    }

    @Nullable
    public ExtendedBlockStorage getChunkSection(BlockPos pos) {
        if (this.level.func_189509_E(pos)) {
            return null;
        }
        if (CQRMain.isCubicChunksInstalled && CubicChunks.isCubicWorld(this.level)) {
            this.cachedSection = CubicChunks.getBlockStorage(this.level, pos.func_177958_n() >> 4, pos.func_177956_o() >> 4, pos.func_177952_p() >> 4);
        } else {
            Chunk chunk = this.getChunk(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4);
            if (this.cachedSection == null || this.cachedSection.func_76662_d() >> 4 != pos.func_177956_o() >> 4) {
                this.cachedSection = chunk.func_76587_i()[pos.func_177956_o() >> 4];
            }
        }
        return this.cachedSection;
    }

    public TileEntity func_175625_s(BlockPos pos) {
        throw new UnsupportedOperationException();
    }

    public int func_175626_b(BlockPos pos, int lightValue) {
        throw new UnsupportedOperationException();
    }

    public IBlockState getBlockState(int x, int y, int z) {
        return this.func_180495_p((BlockPos)this.mutable.func_181079_c(x, y, z));
    }

    public IBlockState func_180495_p(BlockPos pos) {
        ExtendedBlockStorage section = this.getChunkSection(pos);
        if (section == null) {
            return Blocks.field_150350_a.func_176223_P();
        }
        return section.func_177485_a(pos.func_177958_n() & 0xF, pos.func_177956_o() & 0xF, pos.func_177952_p() & 0xF);
    }

    public boolean func_175623_d(BlockPos pos) {
        throw new UnsupportedOperationException();
    }

    public Biome func_180494_b(BlockPos pos) {
        throw new UnsupportedOperationException();
    }

    public int func_175627_a(BlockPos pos, EnumFacing direction) {
        throw new UnsupportedOperationException();
    }

    public WorldType func_175624_G() {
        throw new UnsupportedOperationException();
    }

    public boolean isSideSolid(BlockPos pos, EnumFacing side, boolean _default) {
        throw new UnsupportedOperationException();
    }
}

