/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.util;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;

public class BlockPosUtil {
    public static void forEach(World world, int x1, int y1, int z1, int horizontalRadius, int verticalRadius, boolean skipUnloadedChunks, boolean skipAirBlocks, BlockInfoConsumer action) {
        BlockPosUtil.forEach(world, x1 - horizontalRadius, y1 - verticalRadius, z1 - horizontalRadius, x1 + horizontalRadius, y1 + verticalRadius, z1 + horizontalRadius, skipUnloadedChunks, skipAirBlocks, action);
    }

    public static void forEach(World world, int x1, int y1, int z1, int x2, int y2, int z2, boolean skipUnloadedChunks, boolean skipAirBlocks, BlockInfoConsumer action) {
        if (world.func_175624_G() == WorldType.field_180272_g) {
            return;
        }
        x1 = Math.max(x1, -30000000);
        y1 = Math.max(y1, 0);
        z1 = Math.max(z1, -30000000);
        x2 = Math.min(x2, 30000000);
        y2 = Math.min(y2, 255);
        z2 = Math.min(z2, 30000000);
        if (x1 > x2 || y1 > y2 || z1 > z2) {
            return;
        }
        int chunkStartX = x1 >> 4;
        int chunkStartY = y1 >> 4;
        int chunkStartZ = z1 >> 4;
        int chunkEndX = x2 >> 4;
        int chunkEndY = y2 >> 4;
        int chunkEndZ = z2 >> 4;
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        for (int chunkX = chunkStartX; chunkX <= chunkEndX; ++chunkX) {
            for (int chunkZ = chunkStartZ; chunkZ <= chunkEndZ; ++chunkZ) {
                if (skipUnloadedChunks && !world.func_175667_e((BlockPos)mutablePos.func_181079_c(chunkX << 4, 0, chunkZ << 4))) continue;
                Chunk chunk = world.func_72964_e(chunkX, chunkZ);
                ExtendedBlockStorage[] blockStorageArray = chunk.func_76587_i();
                for (int chunkY = chunkStartY; chunkY <= chunkEndY; ++chunkY) {
                    ExtendedBlockStorage extendedBlockStorage = blockStorageArray[chunkY];
                    if (skipAirBlocks && extendedBlockStorage == Chunk.field_186036_a) continue;
                    int blockStartX = Math.max(chunkX << 4, x1);
                    int blockStartY = Math.max(chunkY << 4, y1);
                    int blockStartZ = Math.max(chunkZ << 4, z1);
                    int blockEndX = Math.min(chunkX << 4 | 0xF, x2);
                    int blockEndY = Math.min(chunkY << 4 | 0xF, y2);
                    int blockEndZ = Math.min(chunkZ << 4 | 0xF, z2);
                    for (int z5 = blockStartZ; z5 <= blockEndZ; ++z5) {
                        for (int y5 = blockStartY; y5 <= blockEndY; ++y5) {
                            for (int x5 = blockStartX; x5 <= blockEndX; ++x5) {
                                IBlockState state = extendedBlockStorage.func_177485_a(x5 & 0xF, y5 & 0xF, z5 & 0xF);
                                if (skipAirBlocks && state.func_177230_c() == Blocks.field_150350_a) continue;
                                mutablePos.func_181079_c(x5, y5, z5);
                                action.accept(mutablePos, state);
                            }
                        }
                    }
                }
            }
        }
    }

    public static List<BlockPos> getAll(World world, int x1, int y1, int z1, int horizontalRadius, int verticalRadius, boolean skipUnloadedChunks, boolean skipAirBlocks, @Nullable Block toCheck, @Nullable BlockInfoPredicate predicate) {
        return BlockPosUtil.getAll(world, x1 - horizontalRadius, y1 - verticalRadius, z1 - horizontalRadius, x1 + horizontalRadius, y1 + verticalRadius, z1 + horizontalRadius, skipUnloadedChunks, skipAirBlocks, toCheck, predicate);
    }

    public static List<BlockPos> getAll(World world, int x1, int y1, int z1, int x2, int y2, int z2, boolean skipUnloadedChunks, boolean skipAirBlocks, @Nullable Block toCheck, @Nullable BlockInfoPredicate predicate) {
        ArrayList<BlockPos> list = new ArrayList<BlockPos>();
        BlockPosUtil.forEach(world, x1, y1, z1, x2, y2, z2, skipUnloadedChunks, skipAirBlocks, (mutablePos, state) -> {
            if (!(toCheck != null && state.func_177230_c() != toCheck || predicate != null && !predicate.test(mutablePos, state))) {
                list.add(mutablePos.func_185334_h());
            }
        });
        return list;
    }

    public static BlockPos getNearest(World world, int x1, int y1, int z1, int horizontalRadius, int verticalRadius, boolean skipUnloadedChunks, boolean skipAirBlocks, @Nullable Block toCheck, @Nullable BlockInfoPredicate predicate) {
        return BlockPosUtil.getNearest(world, x1 - horizontalRadius, y1 - verticalRadius, z1 - horizontalRadius, x1 + horizontalRadius, y1 + verticalRadius, z1 + horizontalRadius, skipUnloadedChunks, skipAirBlocks, new BlockPos(x1, y1, z1), toCheck, predicate);
    }

    public static BlockPos getNearest(World world, int x1, int y1, int z1, int x2, int y2, int z2, boolean skipUnloadedChunks, boolean skipAirBlocks, BlockPos pos, @Nullable Block toCheck, @Nullable BlockInfoPredicate predicate) {
        BlockPosDistInfo blockPosDistInfo = new BlockPosDistInfo();
        blockPosDistInfo.dist = 2.147483647E9;
        BlockPosUtil.forEach(world, x1, y1, z1, x2, y2, z2, skipUnloadedChunks, skipAirBlocks, (mutablePos, state) -> {
            double dist;
            if ((toCheck == null || state.func_177230_c() == toCheck) && (predicate == null || predicate.test(mutablePos, state)) && (dist = pos.func_177951_i((Vec3i)mutablePos)) < blockPosDistInfo.dist) {
                blockPosDistInfo.mutablePos.func_189533_g((Vec3i)mutablePos);
                blockPosDistInfo.dist = dist;
                blockPosDistInfo.empty = false;
            }
        });
        return !blockPosDistInfo.empty ? blockPosDistInfo.mutablePos.func_185334_h() : null;
    }

    private static class BlockPosDistInfo {
        private final BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        private double dist;
        private boolean empty = true;

        private BlockPosDistInfo() {
        }
    }

    public static interface BlockInfoPredicate {
        public boolean test(BlockPos.MutableBlockPos var1, IBlockState var2);
    }

    public static interface BlockInfoConsumer {
        public void accept(BlockPos.MutableBlockPos var1, IBlockState var2);
    }
}

