/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.network.server.packet;

import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.Item;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class SPacketArmorCooldownSync
implements IMessage {
    private Map<Item, Integer> itemCooldownMap = new HashMap<Item, Integer>();

    public SPacketArmorCooldownSync() {
    }

    public SPacketArmorCooldownSync(Map<Item, Integer> itemCooldownMap) {
        this.itemCooldownMap = itemCooldownMap;
    }

    public void fromBytes(ByteBuf buf) {
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            Item item = (Item)ByteBufUtils.readRegistryEntry((ByteBuf)buf, (IForgeRegistry)ForgeRegistries.ITEMS);
            int cooldown = buf.readInt();
            this.itemCooldownMap.put(item, cooldown);
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.itemCooldownMap.size());
        for (Map.Entry<Item, Integer> entry : this.itemCooldownMap.entrySet()) {
            ByteBufUtils.writeRegistryEntry((ByteBuf)buf, (IForgeRegistryEntry)((IForgeRegistryEntry)entry.getKey()));
            buf.writeInt(entry.getValue().intValue());
        }
    }

    public Map<Item, Integer> getItemCooldownMap() {
        return this.itemCooldownMap;
    }
}

