/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.network.datasync;

import io.netty.buffer.ByteBuf;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.items.ItemStackHandler;
import team.cqr.cqrepoured.network.datasync.DataEntryObject;
import team.cqr.cqrepoured.network.datasync.TileEntityDataManager;

public class DataEntryItemStackHandler
extends DataEntryObject<ItemStackHandler> {
    private boolean canMarkDirty = true;
    private final boolean[] dirtySlots;

    public DataEntryItemStackHandler(String name, CustomItemStackHandler itemStackHandler, boolean isClientModificationAllowed) {
        super(name, itemStackHandler, isClientModificationAllowed);
        ((CustomItemStackHandler)((Object)this.value)).entry = this;
        this.dirtySlots = new boolean[itemStackHandler.getSlots()];
    }

    @Override
    public NBTBase write() {
        return ((ItemStackHandler)this.value).serializeNBT();
    }

    @Override
    protected void readInternal(NBTBase nbt) {
        this.canMarkDirty = false;
        if (nbt instanceof NBTTagCompound) {
            ((ItemStackHandler)this.value).deserializeNBT((NBTTagCompound)nbt);
        }
        this.canMarkDirty = true;
    }

    @Override
    public void writeChanges(ByteBuf buf) {
        int size = 0;
        for (boolean dirtySlot : this.dirtySlots) {
            if (!dirtySlot) continue;
            ++size;
        }
        buf.writeInt(size);
        for (int i = 0; i < ((ItemStackHandler)this.value).getSlots(); ++i) {
            if (!this.dirtySlots[i]) continue;
            ByteBufUtils.writeVarInt((ByteBuf)buf, (int)i, (int)5);
            ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)((ItemStackHandler)this.value).getStackInSlot(i));
        }
    }

    @Override
    protected void readChangesInternal(ByteBuf buf) {
        this.canMarkDirty = false;
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            ((ItemStackHandler)this.value).setStackInSlot(ByteBufUtils.readVarInt((ByteBuf)buf, (int)5), ByteBufUtils.readItemStack((ByteBuf)buf));
        }
        this.canMarkDirty = true;
    }

    @Override
    public void set(ItemStackHandler value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clearDirty() {
        super.clearDirty();
        for (int i = 0; i < ((ItemStackHandler)this.value).getSlots(); ++i) {
            this.dirtySlots[i] = false;
        }
    }

    public void markSlotDirty(int slot) {
        if (slot < 0 || slot >= this.dirtySlots.length) {
            return;
        }
        TileEntityDataManager dataManager = this.getDataManager();
        if (dataManager == null) {
            return;
        }
        World world = dataManager.getTileEntity().func_145831_w();
        if (world == null) {
            return;
        }
        if (world.field_72995_K && !this.isClientModificationAllowed()) {
            return;
        }
        this.isDirty = true;
        this.dirtySlots[slot] = true;
        dataManager.markDirty();
    }

    public static class CustomItemStackHandler
    extends ItemStackHandler {
        private DataEntryItemStackHandler entry;

        public CustomItemStackHandler(int size) {
            super(size);
        }

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            if (this.entry != null) {
                this.entry.onValueChanged();
                if (this.entry.canMarkDirty) {
                    this.entry.markSlotDirty(slot);
                }
            }
        }
    }
}

