/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.network.datasync;

import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagInt;
import team.cqr.cqrepoured.network.datasync.DataEntry;

public class DataEntryInt
extends DataEntry<Integer> {
    private int value;

    public DataEntryInt(String name, int defaultValue, boolean isClientModificationAllowed) {
        super(name, isClientModificationAllowed);
        this.value = defaultValue;
    }

    @Override
    public NBTBase write() {
        return new NBTTagInt(this.value);
    }

    @Override
    protected void readInternal(NBTBase nbt) {
        if (nbt instanceof NBTTagInt) {
            this.value = ((NBTTagInt)nbt).func_150287_d();
        }
    }

    @Override
    public void writeChanges(ByteBuf buf) {
        buf.writeInt(this.value);
    }

    @Override
    protected void readChangesInternal(ByteBuf buf) {
        this.value = buf.readInt();
    }

    @Override
    @Deprecated
    public void set(@Nonnull Integer value) {
        if (value == null) {
            return;
        }
        this.set(value);
    }

    @Override
    @Deprecated
    protected void setInternal(@Nonnull Integer value) {
        if (value == null) {
            return;
        }
        this.setInternal(value);
    }

    @Override
    @Deprecated
    public boolean isSavedValueEqualTo(Integer value) {
        return this.isSavedValueEqualTo(value);
    }

    @Override
    @Deprecated
    public Integer get() {
        return this.getInt();
    }

    @Override
    public void set(int value) {
        if (!this.isSavedValueEqualTo(value)) {
            this.setInternal(value);
            this.onValueChanged();
            this.markDirty();
        }
    }

    @Override
    protected void setInternal(int value) {
        this.value = value;
    }

    @Override
    public boolean isSavedValueEqualTo(int value) {
        return this.value == value;
    }

    public int getInt() {
        return this.value;
    }
}

