/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.network.datasync;

import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTBase;
import net.minecraft.world.World;
import team.cqr.cqrepoured.network.datasync.TileEntityDataManager;

public abstract class DataEntry<T> {
    private TileEntityDataManager dataManager;
    private int id = -1;
    private final String name;
    private final boolean isClientModificationAllowed;
    protected boolean isDirty = false;

    protected DataEntry(String name, boolean isClientModificationAllowed) {
        this.name = name;
        this.isClientModificationAllowed = isClientModificationAllowed;
    }

    public abstract NBTBase write();

    public void read(NBTBase nbt) {
        this.readInternal(nbt);
    }

    protected abstract void readInternal(NBTBase var1);

    public abstract void writeChanges(ByteBuf var1);

    public void readChanges(ByteBuf buf) {
        this.readChangesInternal(buf);
        this.onValueChanged();
    }

    protected abstract void readChangesInternal(ByteBuf var1);

    public void setDataManagerAndId(TileEntityDataManager dataManager, int id) {
        if (this.dataManager == null && dataManager != null) {
            this.dataManager = dataManager;
            this.id = id;
        }
    }

    public TileEntityDataManager getDataManager() {
        return this.dataManager;
    }

    public int getId() {
        return this.id;
    }

    public boolean isRegistered() {
        return this.dataManager != null;
    }

    public void set(@Nonnull T value) {
        if (value == null) {
            throw new NullPointerException();
        }
        if (!this.isSavedValueEqualTo(value)) {
            this.setInternal(value);
            this.onValueChanged();
            this.markDirty();
        }
    }

    public abstract boolean isSavedValueEqualTo(T var1);

    protected abstract void setInternal(@Nonnull T var1);

    protected void onValueChanged() {
        if (this.dataManager == null) {
            return;
        }
        this.dataManager.onDataEntryChanged(this);
    }

    public abstract T get();

    public String getName() {
        return this.name;
    }

    public boolean isClientModificationAllowed() {
        return this.isClientModificationAllowed;
    }

    public void markDirty() {
        if (this.dataManager == null) {
            return;
        }
        World world = this.dataManager.getTileEntity().func_145831_w();
        if (world == null) {
            return;
        }
        if (world.field_72995_K && !this.isClientModificationAllowed) {
            return;
        }
        this.isDirty = true;
        this.dataManager.markDirty();
    }

    public void clearDirty() {
        this.isDirty = false;
    }

    public boolean isDirty() {
        return this.isDirty;
    }
}

