/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.item.gun;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;
import team.cqr.cqrepoured.entity.EntityEquipmentExtraSlot;
import team.cqr.cqrepoured.entity.bases.AbstractEntityCQR;
import team.cqr.cqrepoured.entity.projectiles.ProjectileBullet;
import team.cqr.cqrepoured.init.CQRItems;
import team.cqr.cqrepoured.init.CQRSounds;
import team.cqr.cqrepoured.item.IRangedWeapon;
import team.cqr.cqrepoured.item.gun.ItemBullet;

public class ItemRevolver
extends Item
implements IRangedWeapon {
    public ItemRevolver() {
        this.func_77656_e(300);
        this.func_77625_d(1);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add(TextFormatting.BLUE + "5.0 " + I18n.func_135052_a((String)"description.bullet_damage.name", (Object[])new Object[0]));
        tooltip.add(TextFormatting.RED + "-30 " + I18n.func_135052_a((String)"description.fire_rate.name", (Object[])new Object[0]));
        tooltip.add(TextFormatting.RED + "-50% " + I18n.func_135052_a((String)"description.accuracy.name", (Object[])new Object[0]));
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            tooltip.add(TextFormatting.BLUE + I18n.func_135052_a((String)"description.gun.name", (Object[])new Object[0]));
        } else {
            tooltip.add(TextFormatting.BLUE + I18n.func_135052_a((String)"description.click_shift.name", (Object[])new Object[0]));
        }
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        boolean flag;
        ItemStack stack = playerIn.func_184586_b(handIn);
        boolean bl = flag = !this.findAmmo(playerIn).func_190926_b();
        if (!playerIn.field_71075_bZ.field_75098_d && !flag && this.getBulletStack(stack, playerIn) == ItemStack.field_190927_a) {
            if (flag) {
                this.shoot(stack, worldIn, playerIn);
            }
            return flag ? new ActionResult(EnumActionResult.PASS, (Object)stack) : new ActionResult(EnumActionResult.FAIL, (Object)stack);
        }
        this.shoot(stack, worldIn, playerIn);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    public void shoot(ItemStack stack, World worldIn, EntityPlayer player) {
        boolean flag = player.field_71075_bZ.field_75098_d;
        ItemStack itemstack = this.findAmmo(player);
        if (!itemstack.func_190926_b() || flag) {
            if (!worldIn.field_72995_K) {
                if (flag && itemstack.func_190926_b()) {
                    ProjectileBullet bulletE = new ProjectileBullet(worldIn, (EntityLivingBase)player, 1);
                    bulletE.func_184538_a((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, 3.5f, 5.0f);
                    player.func_184811_cZ().func_185145_a(stack.func_77973_b(), 10);
                    worldIn.func_72838_d((Entity)bulletE);
                } else {
                    ProjectileBullet bulletE = new ProjectileBullet(worldIn, (EntityLivingBase)player, this.getBulletType(itemstack));
                    bulletE.func_184538_a((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, 3.5f, 5.0f);
                    player.func_184811_cZ().func_185145_a(stack.func_77973_b(), 10);
                    worldIn.func_72838_d((Entity)bulletE);
                    stack.func_77972_a(1, (EntityLivingBase)player);
                }
            }
            worldIn.func_184134_a(player.field_70165_t, player.field_70163_u + (double)player.func_70047_e(), player.field_70161_v, this.getShootSound(), SoundCategory.MASTER, 1.0f, 0.9f + field_77697_d.nextFloat() * 0.2f, false);
            player.field_70125_A -= worldIn.field_73012_v.nextFloat() * this.getRecoil();
            if (!flag) {
                itemstack.func_190918_g(1);
                if (itemstack.func_190926_b()) {
                    player.field_71071_by.func_184437_d(itemstack);
                }
            }
        }
    }

    protected float getRecoil() {
        return 10.0f;
    }

    protected boolean isBullet(ItemStack stack) {
        return stack.func_77973_b() instanceof ItemBullet;
    }

    protected ItemStack findAmmo(EntityPlayer player) {
        if (this.isBullet(player.func_184586_b(EnumHand.OFF_HAND))) {
            return player.func_184586_b(EnumHand.OFF_HAND);
        }
        if (this.isBullet(player.func_184586_b(EnumHand.MAIN_HAND))) {
            return player.func_184586_b(EnumHand.MAIN_HAND);
        }
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack itemstack = player.field_71071_by.func_70301_a(i);
            if (!this.isBullet(itemstack)) continue;
            return itemstack;
        }
        return ItemStack.field_190927_a;
    }

    protected ItemStack getBulletStack(ItemStack stack, EntityPlayer player) {
        if (stack.func_77973_b() == CQRItems.BULLET_IRON) {
            return new ItemStack(CQRItems.BULLET_IRON);
        }
        if (stack.func_77973_b() == CQRItems.BULLET_GOLD) {
            return new ItemStack(CQRItems.BULLET_GOLD);
        }
        if (stack.func_77973_b() == CQRItems.BULLET_DIAMOND) {
            return new ItemStack(CQRItems.BULLET_DIAMOND);
        }
        if (stack.func_77973_b() == CQRItems.BULLET_FIRE) {
            return new ItemStack(CQRItems.BULLET_FIRE);
        }
        return new ItemStack(CQRItems.BULLET_IRON);
    }

    protected int getBulletType(ItemStack stack) {
        if (stack.func_77973_b() == CQRItems.BULLET_IRON) {
            return 1;
        }
        if (stack.func_77973_b() == CQRItems.BULLET_GOLD) {
            return 2;
        }
        if (stack.func_77973_b() == CQRItems.BULLET_DIAMOND) {
            return 3;
        }
        if (stack.func_77973_b() == CQRItems.BULLET_FIRE) {
            return 4;
        }
        return 1;
    }

    @Override
    public void shoot(World worldIn, EntityLivingBase shooter, Entity target, EnumHand handIn) {
        if (!worldIn.field_72995_K) {
            AbstractEntityCQR cqrEnt;
            ItemStack bullet;
            ItemStack bulletStack = new ItemStack(CQRItems.BULLET_IRON, 1);
            if (shooter instanceof AbstractEntityCQR && (bullet = (cqrEnt = (AbstractEntityCQR)shooter).getItemStackFromExtraSlot(EntityEquipmentExtraSlot.ARROW)) != null && !bullet.func_190926_b() && bullet.func_77973_b() instanceof ItemBullet) {
                bulletStack = bullet;
                bullet.func_190918_g(1);
            }
            ProjectileBullet bulletE = new ProjectileBullet(worldIn, shooter, this.getBulletType(bulletStack));
            Vec3d v = target.func_174791_d().func_178788_d(shooter.func_174791_d());
            v = v.func_72432_b();
            v = v.func_186678_a(3.5);
            bulletE.field_70159_w = v.field_72450_a;
            bulletE.field_70181_x = v.field_72448_b;
            bulletE.field_70179_y = v.field_72449_c;
            bulletE.field_70133_I = true;
            worldIn.func_72838_d((Entity)bulletE);
        }
    }

    @Override
    public SoundEvent getShootSound() {
        return CQRSounds.REVOLVER_SHOOT;
    }

    @Override
    public double getRange() {
        return 32.0;
    }

    @Override
    public int getCooldown() {
        return 60;
    }

    @Override
    public int getChargeTicks() {
        return 0;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return false;
    }

    public boolean func_77616_k(ItemStack stack) {
        return false;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }
}

