/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.item;

import com.google.common.collect.Streams;
import java.util.Arrays;
import java.util.Iterator;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import team.cqr.cqrepoured.item.ItemLore;
import team.cqr.cqrepoured.tileentity.TileEntityExporter;

public class ItemUnprotectedPositionTool
extends ItemLore {
    private static final String POSITIONS_NBT_KEY = "positions";

    public int getItemStackLimit(ItemStack stack) {
        return 1;
    }

    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!this.removePosition(stack, pos)) {
            this.addPosition(stack, pos);
        }
        return EnumActionResult.SUCCESS;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        if (playerIn.func_70093_af()) {
            ItemStack stack = playerIn.func_184586_b(handIn);
            this.clearPositions(stack);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    public boolean onBlockStartBreak(ItemStack itemstack, BlockPos pos, EntityPlayer player) {
        TileEntity tileEntity = player.field_70170_p.func_175625_s(pos);
        if (!(tileEntity instanceof TileEntityExporter)) {
            return super.onBlockStartBreak(itemstack, pos, player);
        }
        TileEntityExporter exporter = (TileEntityExporter)tileEntity;
        if (!player.func_70093_af()) {
            exporter.setUnprotectedBlocks((BlockPos[])this.getPositions(itemstack).toArray(BlockPos[]::new));
        } else {
            BlockPos[] exporterPositions = exporter.getUnprotectedBlocks();
            this.clearPositions(itemstack);
            Arrays.stream(exporterPositions).forEach(p -> this.addPosition(itemstack, (BlockPos)p));
        }
        return true;
    }

    public boolean hasPosition(ItemStack stack, BlockPos pos) {
        return this.getPositions(stack).anyMatch(arg_0 -> ((BlockPos)pos).equals(arg_0));
    }

    public void addPosition(ItemStack stack, BlockPos pos) {
        int[] data = new int[]{pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()};
        this.getOrCreatePositionTagList(stack).func_74742_a((NBTBase)new NBTTagIntArray(data));
    }

    public boolean removePosition(ItemStack stack, BlockPos pos) {
        NBTTagList tagList = this.getPositionTagList(stack);
        if (tagList == null) {
            return false;
        }
        Iterator iterator = tagList.iterator();
        while (iterator.hasNext()) {
            NBTBase tag = (NBTBase)iterator.next();
            int[] data = ((NBTTagIntArray)tag).func_150302_c();
            if (data[0] != pos.func_177958_n() || data[1] != pos.func_177956_o() || data[2] != pos.func_177952_p()) continue;
            iterator.remove();
            return true;
        }
        return false;
    }

    public void clearPositions(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return;
        }
        NBTTagCompound nbt = stack.func_77978_p();
        nbt.func_82580_o(POSITIONS_NBT_KEY);
    }

    public Stream<BlockPos> getPositions(ItemStack stack) {
        NBTTagList tagList = this.getPositionTagList(stack);
        if (tagList == null) {
            return Stream.empty();
        }
        return Streams.stream((Iterable)tagList).map(tag -> {
            int[] data = ((NBTTagIntArray)tag).func_150302_c();
            return new BlockPos(data[0], data[1], data[2]);
        });
    }

    @Nullable
    private NBTTagList getPositionTagList(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return null;
        }
        NBTTagCompound nbt = stack.func_77978_p();
        if (!nbt.func_150297_b(POSITIONS_NBT_KEY, 9)) {
            return null;
        }
        return nbt.func_150295_c(POSITIONS_NBT_KEY, 11);
    }

    private NBTTagList getOrCreatePositionTagList(ItemStack stack) {
        NBTTagCompound nbt;
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if (!(nbt = stack.func_77978_p()).func_150297_b(POSITIONS_NBT_KEY, 9)) {
            nbt.func_74782_a(POSITIONS_NBT_KEY, (NBTBase)new NBTTagList());
        }
        return nbt.func_150295_c(POSITIONS_NBT_KEY, 11);
    }
}

