/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.item;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import team.cqr.cqrepoured.entity.bases.ISummoner;
import team.cqr.cqrepoured.entity.misc.EntitySummoningCircle;

public class ItemCursedBone
extends Item {
    public ItemCursedBone() {
        this.func_77656_e(3);
        this.func_77625_d(1);
        this.setNoRepair();
    }

    public boolean isRepairable() {
        return false;
    }

    public int func_77626_a(ItemStack stack) {
        return 40;
    }

    public ItemStack func_77654_b(ItemStack stack, World worldIn, EntityLivingBase entityLiving) {
        if (!worldIn.field_72995_K && this.spawnEntity((EntityPlayer)entityLiving, worldIn, stack)) {
            stack.func_77972_a(1, entityLiving);
        }
        if (entityLiving instanceof EntityPlayerMP) {
            ((EntityPlayerMP)entityLiving).func_184811_cZ().func_185145_a((Item)this, 20);
        }
        if (stack.func_77952_i() >= stack.func_77958_k()) {
            return ItemStack.field_190927_a;
        }
        return super.func_77654_b(stack, worldIn, entityLiving);
    }

    public Optional<Entity> spawnEntity(BlockPos pos, World worldIn, ItemStack item, EntityLivingBase summoner, ISummoner isummoner) {
        if (worldIn.func_175623_d(pos.func_177967_a(EnumFacing.UP, 1)) && worldIn.func_175623_d(pos.func_177967_a(EnumFacing.UP, 2))) {
            ResourceLocation resLoc = new ResourceLocation("cqrepoured", "skeleton");
            if (ItemCursedBone.hasCursedBoneEntityTag(item)) {
                try {
                    NBTTagCompound tag = item.func_77978_p();
                    resLoc = new ResourceLocation(tag.func_74779_i("entity_to_summon"));
                    if (!EntityList.func_180125_b((ResourceLocation)resLoc)) {
                        resLoc = new ResourceLocation("cqrepoured", "skeleton");
                    }
                }
                catch (Exception ex) {
                    resLoc = new ResourceLocation("cqrepoured", "skeleton");
                }
            }
            EntitySummoningCircle circle = new EntitySummoningCircle(worldIn, resLoc, 1.0f, EntitySummoningCircle.ECircleTexture.METEOR, isummoner, summoner);
            circle.setSummon(resLoc);
            circle.func_189654_d(false);
            circle.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.0, (double)pos.func_177952_p() + 0.5);
            worldIn.func_72838_d((Entity)circle);
            return Optional.of(circle);
        }
        return Optional.empty();
    }

    public boolean spawnEntity(EntityPlayer player, World worldIn, ItemStack item) {
        Vec3d end;
        Vec3d start = player.func_174824_e(1.0f);
        RayTraceResult result = worldIn.func_72933_a(start, end = start.func_178787_e(player.func_70040_Z().func_186678_a(5.0)));
        if (result != null) {
            return this.spawnEntity(result.func_178782_a(), worldIn, item, (EntityLivingBase)player, null).isPresent();
        }
        return false;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        playerIn.func_184598_c(handIn);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)playerIn.func_184586_b(handIn));
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.BOW;
    }

    public void func_77615_a(ItemStack stack, World worldIn, EntityLivingBase entityLiving, int timeLeft) {
        super.func_77615_a(stack, worldIn, entityLiving, timeLeft);
        if (entityLiving instanceof EntityPlayer) {
            ((EntityPlayer)entityLiving).func_184811_cZ().func_185145_a((Item)this, 20);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (ItemCursedBone.hasCursedBoneEntityTag(stack)) {
            try {
                NBTTagCompound tag = stack.func_77978_p();
                tooltip.add(TextFormatting.BLUE + I18n.func_135052_a((String)"description.cursed_bone.name", (Object[])new Object[0]) + " " + this.getEntityName(tag.func_74779_i("entity_to_summon")));
            }
            catch (Exception ex) {
                tooltip.add(TextFormatting.BLUE + I18n.func_135052_a((String)"description.cursed_bone.name", (Object[])new Object[0]) + "missingNo");
            }
            return;
        }
        tooltip.add(TextFormatting.BLUE + I18n.func_135052_a((String)"description.cursed_bone.name", (Object[])new Object[0]) + " " + this.getEntityName("cqrepoured:skeleton"));
    }

    private String getEntityName(String registryName) {
        EntityEntry entityEntry = (EntityEntry)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(registryName));
        if (entityEntry != null) {
            return I18n.func_135052_a((String)("entity." + ((EntityEntry)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(registryName))).getName() + ".name"), (Object[])new Object[0]);
        }
        return "missingNO";
    }

    public static boolean hasCursedBoneEntityTag(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        return stack.func_77942_o() && stack.func_77978_p().func_150297_b("entity_to_summon", 8);
    }

    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity clickedEntity) {
        if (player.func_184812_l_() && player.func_70093_af() && !player.field_70170_p.field_72995_K && clickedEntity instanceof EntityLiving && clickedEntity.func_70089_S()) {
            if (!stack.func_77942_o()) {
                stack.func_77982_d(new NBTTagCompound());
            }
            stack.func_77978_p().func_74778_a("entity_to_summon", EntityList.func_191301_a((Entity)clickedEntity).toString());
            return true;
        }
        return super.onLeftClickEntity(stack, player, clickedEntity);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return false;
    }

    public boolean func_77616_k(ItemStack stack) {
        return false;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }
}

