/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.init;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import team.cqr.cqrepoured.CQRMain;
import team.cqr.cqrepoured.client.init.CQRParticleManager;
import team.cqr.cqrepoured.network.server.packet.SPacketSpawnParticles;

public enum CQRParticleType {
    BEAM("beam", 0),
    BLOCK_HIGHLIGHT("block_highlight", 1);

    private static final Map<String, CQRParticleType> NAME_PARTICLE_MAP;
    private static final Int2ObjectMap<CQRParticleType> ID_PARTICLE_MAP;
    private final String name;
    private final int id;
    private final int argumentCount;

    private CQRParticleType(String name, int id) {
        this(name, id, 0);
    }

    private CQRParticleType(String name, int id, int argumentCount) {
        this.name = name;
        this.id = id;
        this.argumentCount = argumentCount;
    }

    public static CQRParticleType byName(String name) {
        return NAME_PARTICLE_MAP.get(name);
    }

    public static CQRParticleType byId(int id) {
        return (CQRParticleType)((Object)ID_PARTICLE_MAP.get(id));
    }

    public String getName() {
        return this.name;
    }

    public int getId() {
        return this.id;
    }

    public int getArgumentCount() {
        return this.argumentCount;
    }

    public static void spawnParticles(int particleId, World world, double xCoord, double yCoord, double zCoord, double xSpeed, double ySpeed, double zSpeed, int count, double xOffset, double yOffset, double zOffset, int ... optionalArguments) {
        CQRParticleType particleType = (CQRParticleType)((Object)ID_PARTICLE_MAP.get(particleId));
        if (particleType == null) {
            return;
        }
        CQRParticleType.spawnParticles(particleType, world, xCoord, yCoord, zCoord, xSpeed, ySpeed, zSpeed, count, xOffset, yOffset, zOffset, optionalArguments);
    }

    public static void spawnParticles(CQRParticleType particleType, World world, double xCoord, double yCoord, double zCoord, double xSpeed, double ySpeed, double zSpeed, int count, double xOffset, double yOffset, double zOffset, int ... optionalArguments) {
        if (world.field_72995_K) {
            CQRParticleManager.spawnParticlesClient(particleType, world, xCoord, yCoord, zCoord, xSpeed, ySpeed, zSpeed, count, xOffset, yOffset, zOffset, optionalArguments);
        } else if (count == 1) {
            double x = xCoord;
            double y = yCoord;
            double z = zCoord;
            if (xOffset != 0.0) {
                x += (Math.random() - Math.random()) * xOffset;
            }
            if (yOffset != 0.0) {
                y += (Math.random() - Math.random()) * yOffset;
            }
            if (zOffset != 0.0) {
                y += (Math.random() - Math.random()) * zOffset;
            }
            CQRMain.NETWORK.sendToAllTracking((IMessage)new SPacketSpawnParticles(particleType.id, x, y, z, xSpeed, ySpeed, zSpeed, optionalArguments), new NetworkRegistry.TargetPoint(world.field_73011_w.getDimension(), x, y, z, 0.0));
        } else {
            CQRMain.NETWORK.sendToAllTracking((IMessage)new SPacketSpawnParticles(particleType.id, xCoord, yCoord, zCoord, xSpeed, ySpeed, zSpeed, count, xOffset, yOffset, zOffset, optionalArguments), new NetworkRegistry.TargetPoint(world.field_73011_w.getDimension(), xCoord, yCoord, zCoord, 0.0));
        }
    }

    static {
        NAME_PARTICLE_MAP = new HashMap<String, CQRParticleType>();
        ID_PARTICLE_MAP = new Int2ObjectOpenHashMap();
        for (CQRParticleType particleType : CQRParticleType.values()) {
            NAME_PARTICLE_MAP.put(particleType.name, particleType);
            ID_PARTICLE_MAP.put(particleType.id, (Object)particleType);
        }
    }
}

