/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.init;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDispenser;
import net.minecraft.block.BlockTNT;
import net.minecraft.block.properties.IProperty;
import net.minecraft.dispenser.IBehaviorDispenseItem;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Bootstrap;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import team.cqr.cqrepoured.entity.misc.EntityTNTPrimedCQR;
import team.cqr.cqrepoured.entity.projectiles.ProjectileBubble;
import team.cqr.cqrepoured.init.CQRBlocks;
import team.cqr.cqrepoured.init.CQRItems;
import team.cqr.cqrepoured.init.CQRSounds;
import team.cqr.cqrepoured.item.ItemSoulBottle;
import team.cqr.cqrepoured.item.gun.ItemBubblePistol;

public class CQRDispenseBehaviors {
    private static final Random rng = new Random();
    public static final IBehaviorDispenseItem DISPENSE_BEHAVIOR_BUBBLE_GUN = (source, stack) -> {
        Vec3d velocity = new Vec3d(0.0, 0.0, 0.0);
        switch ((EnumFacing)source.func_189992_e().func_177229_b((IProperty)BlockDispenser.field_176441_a)) {
            case DOWN: {
                velocity = new Vec3d(0.0, -1.0, 0.0);
                break;
            }
            case EAST: {
                velocity = new Vec3d(1.0, 0.0, 0.0);
                break;
            }
            case NORTH: {
                velocity = new Vec3d(0.0, 0.0, -1.0);
                break;
            }
            case SOUTH: {
                velocity = new Vec3d(0.0, 0.0, 1.0);
                break;
            }
            case UP: {
                velocity = new Vec3d(0.0, 1.0, 0.0);
                break;
            }
            case WEST: {
                velocity = new Vec3d(-1.0, 0.0, 0.0);
                break;
            }
        }
        IPosition disPos = BlockDispenser.func_149939_a((IBlockSource)source);
        Vec3d startLoc = new Vec3d(disPos.func_82615_a(), disPos.func_82617_b(), disPos.func_82616_c());
        Item item = stack.func_77973_b();
        double acc = 0.5;
        if (item instanceof ItemBubblePistol) {
            ItemBubblePistol pistol = (ItemBubblePistol)item;
            acc = pistol.getInaccurary();
        }
        Vec3d v = new Vec3d(-acc + velocity.field_72450_a + 2.0 * acc * rng.nextDouble(), -acc + velocity.field_72448_b + 2.0 * acc * rng.nextDouble(), -acc + velocity.field_72449_c + 2.0 * acc * rng.nextDouble());
        v = v.func_72432_b();
        v = v.func_186678_a(1.4);
        ProjectileBubble bubble = new ProjectileBubble(source.func_82618_k(), startLoc.field_72450_a, startLoc.field_72448_b, startLoc.field_72449_c);
        bubble.field_70159_w = v.field_72450_a;
        bubble.field_70181_x = v.field_72448_b;
        bubble.field_70179_y = v.field_72449_c;
        bubble.field_70133_I = true;
        source.func_82618_k().func_72838_d((Entity)bubble);
        source.func_82618_k().func_184134_a(disPos.func_82615_a(), disPos.func_82617_b(), disPos.func_82616_c(), CQRSounds.BUBBLE_BUBBLE, SoundCategory.BLOCKS, 1.0f, 0.75f + 0.5f * rng.nextFloat(), false);
        stack.func_96631_a(1, source.func_82618_k().field_73012_v, null);
        if (stack.func_77952_i() >= stack.func_77958_k()) {
            stack = ItemStack.field_190927_a;
        }
        return stack;
    };
    public static final IBehaviorDispenseItem DISPENSE_BEHAVIOR_SOUL_BOTTLE = (source, stack) -> {
        NBTTagCompound bottle;
        Vec3d velocity = new Vec3d(0.0, 0.0, 0.0);
        switch ((EnumFacing)source.func_189992_e().func_177229_b((IProperty)BlockDispenser.field_176441_a)) {
            case DOWN: {
                velocity = new Vec3d(0.0, -1.0, 0.0);
                break;
            }
            case EAST: {
                velocity = new Vec3d(1.0, 0.0, 0.0);
                break;
            }
            case NORTH: {
                velocity = new Vec3d(0.0, 0.0, -1.0);
                break;
            }
            case SOUTH: {
                velocity = new Vec3d(0.0, 0.0, 1.0);
                break;
            }
            case UP: {
                velocity = new Vec3d(0.0, 2.0, 0.0);
                break;
            }
            case WEST: {
                velocity = new Vec3d(-1.0, 0.0, 0.0);
                break;
            }
        }
        IPosition disPos = BlockDispenser.func_149939_a((IBlockSource)source);
        Vec3d pos = new Vec3d(disPos.func_82615_a(), disPos.func_82617_b(), disPos.func_82616_c()).func_178787_e(velocity);
        if (stack.func_77942_o() && (bottle = stack.func_77978_p()).func_74764_b("EntityIn") && !source.func_82618_k().field_72995_K) {
            NBTTagCompound entityTag = (NBTTagCompound)bottle.func_74781_a("EntityIn");
            ((ItemSoulBottle)stack.func_77973_b()).createEntityFromNBT(entityTag, source.func_82618_k(), pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
        }
        stack.func_190918_g(1);
        if (stack.func_190926_b()) {
            stack = ItemStack.field_190927_a;
        }
        return stack;
    };
    public static final IBehaviorDispenseItem DISPENSE_BEHAVIOR_TNT_CQR = (source, stack) -> {
        World world = source.func_82618_k();
        BlockPos blockpos = source.func_180699_d().func_177972_a((EnumFacing)source.func_189992_e().func_177229_b((IProperty)BlockDispenser.field_176441_a));
        EntityTNTPrimedCQR entitytntprimed = new EntityTNTPrimedCQR(world, (double)blockpos.func_177958_n() + 0.5, blockpos.func_177956_o(), (double)blockpos.func_177952_p() + 0.5, null);
        world.func_72838_d((Entity)entitytntprimed);
        world.func_184148_a((EntityPlayer)null, entitytntprimed.field_70165_t, entitytntprimed.field_70163_u, entitytntprimed.field_70161_v, SoundEvents.field_187904_gd, SoundCategory.BLOCKS, 1.0f, 1.0f);
        stack.func_190918_g(1);
        return stack;
    };
    public static final Bootstrap.BehaviorDispenseOptional DISPENSE_BEHAVIOR_IGNITE_TNT_CQR = new Bootstrap.BehaviorDispenseOptional(){

        protected ItemStack func_82487_b(IBlockSource source, ItemStack stack) {
            World world = source.func_82618_k();
            this.field_190911_b = true;
            BlockPos blockpos = source.func_180699_d().func_177972_a((EnumFacing)source.func_189992_e().func_177229_b((IProperty)BlockDispenser.field_176441_a));
            if (world.func_175623_d(blockpos)) {
                world.func_175656_a(blockpos, Blocks.field_150480_ab.func_176223_P());
                if (stack.func_96631_a(1, world.field_73012_v, (EntityPlayerMP)null)) {
                    stack.func_190920_e(0);
                }
            } else if (world.func_180495_p(blockpos).func_177230_c() == CQRBlocks.TNT) {
                CQRBlocks.TNT.func_176206_d(world, blockpos, CQRBlocks.TNT.func_176223_P().func_177226_a((IProperty)BlockTNT.field_176246_a, (Comparable)Boolean.valueOf(true)));
                world.func_175698_g(blockpos);
            } else {
                this.field_190911_b = false;
            }
            return stack;
        }
    };

    public static void registerDispenseBehaviors() {
        BlockDispenser.field_149943_a.func_82595_a((Object)CQRItems.BUBBLE_PISTOL, (Object)DISPENSE_BEHAVIOR_BUBBLE_GUN);
        BlockDispenser.field_149943_a.func_82595_a((Object)CQRItems.BUBBLE_RIFLE, (Object)DISPENSE_BEHAVIOR_BUBBLE_GUN);
        BlockDispenser.field_149943_a.func_82595_a((Object)CQRItems.SOUL_BOTTLE, (Object)DISPENSE_BEHAVIOR_SOUL_BOTTLE);
        BlockDispenser.field_149943_a.func_82595_a((Object)Item.func_150898_a((Block)CQRBlocks.TNT), (Object)DISPENSE_BEHAVIOR_TNT_CQR);
        BlockDispenser.field_149943_a.func_82595_a((Object)Items.field_151033_d, (Object)DISPENSE_BEHAVIOR_IGNITE_TNT_CQR);
    }
}

