/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.faction;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MultiPartEntityPart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.io.FileUtils;
import team.cqr.cqrepoured.CQRMain;
import team.cqr.cqrepoured.config.CQRConfig;
import team.cqr.cqrepoured.customtextures.TextureSet;
import team.cqr.cqrepoured.customtextures.TextureSetManager;
import team.cqr.cqrepoured.entity.bases.AbstractEntityCQR;
import team.cqr.cqrepoured.faction.DummyFaction;
import team.cqr.cqrepoured.faction.EDefaultFaction;
import team.cqr.cqrepoured.faction.EReputationState;
import team.cqr.cqrepoured.faction.Faction;
import team.cqr.cqrepoured.network.server.packet.SPacketInitialFactionInformation;
import team.cqr.cqrepoured.network.server.packet.SPacketUpdatePlayerReputation;
import team.cqr.cqrepoured.util.PropertyFileHelper;
import team.cqr.cqrepoured.util.data.FileIOUtil;

public class FactionRegistry {
    private static final FactionRegistry CLIENT_INSTANCE = new FactionRegistry();
    private static final FactionRegistry SERVER_INSTANCE = new FactionRegistry();
    public static final DummyFaction DUMMY_FACTION = new DummyFaction();
    public static final int LOWEST_REPU = EReputationState.ARCH_ENEMY.getValue();
    public static final int HIGHEST_REPU = EReputationState.MEMBER.getValue();
    private final Map<String, Faction> factions = new HashMap<String, Faction>();
    private final Map<UUID, Object2IntMap<String>> playerFactionRepuMap = new HashMap<UUID, Object2IntMap<String>>();
    private final Map<Class<? extends Entity>, Faction> entityFactionMap = new HashMap<Class<? extends Entity>, Faction>();

    public static FactionRegistry getClientInstance() {
        return CLIENT_INSTANCE;
    }

    public static FactionRegistry getServerInstance() {
        return SERVER_INSTANCE;
    }

    public static FactionRegistry instance(World world) {
        return world.field_72995_K ? CLIENT_INSTANCE : SERVER_INSTANCE;
    }

    public static FactionRegistry instance(Entity entity) {
        return FactionRegistry.instance(entity.field_70170_p);
    }

    public void loadFactions() {
        if (!this.factions.isEmpty()) {
            this.factions.clear();
        }
        if (!this.playerFactionRepuMap.isEmpty()) {
            this.playerFactionRepuMap.clear();
        }
        if (!this.entityFactionMap.isEmpty()) {
            this.entityFactionMap.clear();
        }
        this.factions.put(DUMMY_FACTION.getName(), DUMMY_FACTION);
        this.entityFactionMap.put(Entity.class, DUMMY_FACTION);
        this.loadFactionsInConfigFolder();
        this.loadDefaultFactions();
        this.loadEntityFactionRelations();
    }

    @SideOnly(value=Side.CLIENT)
    public void addFaction(Faction faction) {
        this.factions.put(faction.getName(), faction);
    }

    @SideOnly(value=Side.CLIENT)
    public void setReputation(UUID player, int reputation, Faction faction) {
        if (faction.canRepuChange()) {
            Map factionsOfPlayer = (Map)this.playerFactionRepuMap.computeIfAbsent(player, key -> new Object2IntOpenHashMap());
            factionsOfPlayer.put(faction.getName(), reputation);
        }
    }

    public void changeReputationTo(@Nonnull EntityPlayerMP player, int reputation, @Nonnull Faction faction) {
        Map factionsOfPlayer = (Map)this.playerFactionRepuMap.computeIfAbsent(player.getPersistentID(), key -> new Object2IntOpenHashMap());
        factionsOfPlayer.put(faction.getName(), reputation);
        this.sendRepuUpdatePacket(player, reputation, faction.getName());
    }

    private void loadEntityFactionRelations() {
        for (String s : CQRConfig.general.entityFactionRelation) {
            int i = s.indexOf(61);
            if (i == -1) {
                CQRMain.logger.warn("Invalid entity-faction relation \"{}\"! Format is incorrect!", (Object)s);
                continue;
            }
            ResourceLocation registryName = new ResourceLocation(s.substring(0, i).trim());
            EntityEntry entry = (EntityEntry)ForgeRegistries.ENTITIES.getValue(registryName);
            if (entry == null) {
                CQRMain.logger.warn("Invalid entity-faction relation \"{}\"! Entity does not exists!", (Object)s);
                continue;
            }
            if (this.entityFactionMap.containsKey(entry.getClass())) {
                CQRMain.logger.warn("Invalid entity-faction relation \"{}\"! Entity already has an assigned faction!", (Object)s);
                continue;
            }
            Faction faction = this.factions.get(s.substring(i + 1).trim());
            if (faction == null) {
                CQRMain.logger.warn("Invalid entity-faction relation \"{}\"! Faction does not exists!", (Object)s);
                continue;
            }
            this.entityFactionMap.put(entry.getEntityClass(), faction);
        }
    }

    private void loadFactionsInConfigFolder() {
        ArrayList files = new ArrayList(FileUtils.listFiles((File)CQRMain.CQ_FACTION_FOLDER, (String[])new String[]{"cfg", "prop", "properties"}, (boolean)true));
        int fileCount = files.size();
        if (fileCount > 0) {
            int i;
            ArrayList<String> fIDs = new ArrayList<String>(fileCount + 1);
            ArrayList allyTmp = new ArrayList();
            ArrayList enemyTmp = new ArrayList();
            boolean flag = true;
            for (i = 0; i < fileCount; ++i) {
                File file = (File)files.get(i);
                Properties prop = new Properties();
                try (FileInputStream inputStream = new FileInputStream(file);){
                    prop.load(inputStream);
                    flag = true;
                }
                catch (IOException e) {
                    CQRMain.logger.error("Failed to load file {}", (Object)file.getName(), (Object)e);
                    flag = false;
                    continue;
                }
                if (!flag) continue;
                ArrayList<String> fAlly = new ArrayList<String>();
                ArrayList<String> fEnemy = new ArrayList<String>();
                String fName = prop.getProperty("name");
                if (fName == null || this.factions.containsKey(fName)) continue;
                int repuChangeAlly = PropertyFileHelper.getIntProperty(prop, "repuChangeOnKillAlly", 2);
                int repuChangeEnemy = PropertyFileHelper.getIntProperty(prop, "repuChangeOnKillEnemy", 1);
                int repuChangeMember = PropertyFileHelper.getIntProperty(prop, "repuChangeOnKillMember", 5);
                EReputationState defRepu = EReputationState.valueOf(prop.getProperty("defaultReputation", EReputationState.NEUTRAL.toString()));
                boolean staticRepu = PropertyFileHelper.getBooleanProperty(prop, "staticReputation", false);
                for (String ally : PropertyFileHelper.getStringArrayProperty(prop, "allies", new String[0], true)) {
                    fAlly.add(ally);
                }
                for (String enemy : PropertyFileHelper.getStringArrayProperty(prop, "enemies", new String[0], true)) {
                    fEnemy.add(enemy);
                }
                fIDs.add(fName);
                allyTmp.add(fAlly);
                enemyTmp.add(fEnemy);
                Optional<Integer> optionMember = Optional.of(repuChangeMember);
                Optional<Integer> optionAlly = Optional.of(repuChangeAlly);
                Optional<Integer> optionEnemy = Optional.of(repuChangeEnemy);
                String textureSetName = prop.getProperty("textureSet", "");
                TextureSet ts = TextureSetManager.getInstance().getTextureSet(textureSetName);
                Faction f = new Faction(fName, ts, defRepu, true, !staticRepu, optionMember, optionAlly, optionEnemy);
                this.factions.put(fName, f);
            }
            for (i = 0; i < fIDs.size(); ++i) {
                String name = (String)fIDs.get(i);
                Faction fac = this.factions.get(name);
                for (String s : (List)allyTmp.get(i)) {
                    fac.addAlly(this.factions.getOrDefault(s, null));
                }
                for (String s : (List)enemyTmp.get(i)) {
                    fac.addEnemy(this.factions.getOrDefault(s, null));
                }
            }
        }
    }

    private void loadDefaultFactions() {
        String[][] allies = new String[EDefaultFaction.values().length][];
        String[][] enemies = new String[EDefaultFaction.values().length][];
        ArrayList<Integer> indices = new ArrayList<Integer>();
        for (int i = 0; i < EDefaultFaction.values().length; ++i) {
            EDefaultFaction edf = EDefaultFaction.values()[i];
            if (this.factions.containsKey(edf.name())) continue;
            indices.add(i);
            allies[i] = edf.getAllies();
            enemies[i] = edf.getEnemies();
            Optional<Integer> optionMember = Optional.empty();
            Optional<Integer> optionAlly = Optional.empty();
            Optional<Integer> optionEnemy = Optional.empty();
            Faction fac = new Faction(edf.name(), null, edf.getDefaultReputation(), false, edf.canRepuChange(), optionMember, optionAlly, optionEnemy);
            this.factions.put(edf.name(), fac);
        }
        Iterator iterator = indices.iterator();
        while (iterator.hasNext()) {
            int j;
            int i = (Integer)iterator.next();
            String name = EDefaultFaction.values()[i].name();
            Faction fac = this.factions.get(name);
            for (j = 0; j < allies[i].length; ++j) {
                fac.addAlly(this.factions.get(allies[i][j]));
            }
            for (j = 0; j < enemies[i].length; ++j) {
                fac.addEnemy(this.factions.get(enemies[i][j]));
            }
        }
        CQRMain.logger.info("Default factions loaded and initialized!");
    }

    public Faction getFactionOf(@Nullable Entity entity) {
        Faction teamFaction;
        if (entity == null) {
            return DUMMY_FACTION;
        }
        if (CQRConfig.advanced.enableOldFactionMemberTeams && entity.func_96124_cp() != null && (teamFaction = this.factions.get(entity.func_96124_cp().func_96661_b())) != null) {
            return teamFaction;
        }
        if (entity instanceof MultiPartEntityPart && ((MultiPartEntityPart)entity).field_70259_a instanceof Entity) {
            return this.getFactionOf((Entity)((MultiPartEntityPart)entity).field_70259_a);
        }
        if (entity instanceof AbstractEntityCQR) {
            return ((AbstractEntityCQR)entity).getFaction();
        }
        return this.getFactionOf(entity.getClass());
    }

    private Faction getFactionOf(Class<? extends Entity> entityClass) {
        if (entityClass == null) {
            CQRMain.logger.error("Class of entity is null! This should never happen!");
            return null;
        }
        Faction faction = this.entityFactionMap.get(entityClass);
        if (faction == null && entityClass != Entity.class) {
            faction = this.getFactionOf(entityClass.getSuperclass());
            this.entityFactionMap.put(entityClass, faction);
        }
        return faction;
    }

    @Nullable
    public Faction getFactionInstance(String factionName) {
        return this.factions.get(factionName);
    }

    public EReputationState.EReputationStateRough getReputationOf(UUID playerID, Faction faction) {
        return EReputationState.EReputationStateRough.getByRepuScore(this.getExactReputationOf(playerID, faction));
    }

    public int getExactReputationOf(UUID playerID, Faction faction) {
        if (!faction.canRepuChange()) {
            return faction.getDefaultReputation().getValue();
        }
        if (playerID != null && this.playerFactionRepuMap.containsKey(playerID) && this.playerFactionRepuMap.get(playerID).containsKey((Object)faction.getName())) {
            return (Integer)this.playerFactionRepuMap.get(playerID).get((Object)faction.getName());
        }
        return faction.getDefaultReputation().getValue();
    }

    void incrementRepuOf(EntityPlayer player, String faction, int score) {
        this.changeRepuOf(player, faction, Math.abs(score));
    }

    void decrementRepuOf(EntityPlayer player, String faction, int score) {
        this.changeRepuOf(player, faction, -Math.abs(score));
    }

    private void changeRepuOf(EntityPlayer player, String faction, int score) {
        if (this.canDecrementRepu(player, faction) || this.canIncrementRepu(player, faction)) {
            Map factionsOfPlayer = (Map)this.playerFactionRepuMap.computeIfAbsent(player.getPersistentID(), key -> new Object2IntOpenHashMap());
            int oldScore = factionsOfPlayer.getOrDefault(faction, this.factions.get(faction).getDefaultReputation().getValue());
            factionsOfPlayer.put(faction, oldScore + score);
            if (player instanceof EntityPlayerMP) {
                this.sendRepuUpdatePacket((EntityPlayerMP)player, score + oldScore, faction);
            }
        }
    }

    private void sendRepuUpdatePacket(EntityPlayerMP player, int reputation, String faction) {
        SPacketUpdatePlayerReputation packet = new SPacketUpdatePlayerReputation(player, faction, reputation);
        CQRMain.NETWORK.sendTo((IMessage)packet, player);
    }

    private boolean canDecrementRepu(EntityPlayer player, String faction) {
        if (this.canRepuChange(player)) {
            Map factionsOfPlayer = (Map)this.playerFactionRepuMap.getOrDefault(player.getPersistentID(), (Object2IntMap<String>)new Object2IntOpenHashMap());
            if (factionsOfPlayer != null) {
                if (factionsOfPlayer.containsKey(faction)) {
                    return (Integer)factionsOfPlayer.get(faction) >= LOWEST_REPU;
                }
                return true;
            }
            return true;
        }
        return false;
    }

    public boolean canIncrementRepu(EntityPlayer player, String faction) {
        if (this.canRepuChange(player)) {
            Map factionsOfPlayer = (Map)this.playerFactionRepuMap.getOrDefault(player.getPersistentID(), (Object2IntMap<String>)new Object2IntOpenHashMap());
            if (factionsOfPlayer != null) {
                if (factionsOfPlayer.containsKey(faction)) {
                    return (Integer)factionsOfPlayer.get(faction) <= HIGHEST_REPU;
                }
                return true;
            }
            return true;
        }
        return false;
    }

    private boolean canRepuChange(EntityPlayer player) {
        return player.func_130014_f_().func_175659_aa() != EnumDifficulty.PEACEFUL && !player.func_184812_l_() && !player.func_175149_v();
    }

    public void loadPlayerReputationData(EntityPlayer player) {
        CQRMain.logger.info("Loading player reputation...");
        UUID uuid = player.getPersistentID();
        File folder = new File(DimensionManager.getCurrentSaveRootDirectory(), "data/CQR/reputation");
        File file = new File(folder, uuid + ".nbt");
        if (file.exists()) {
            NBTTagCompound root = FileIOUtil.readNBTFromFile(file);
            Map mapping = (Map)this.playerFactionRepuMap.computeIfAbsent(uuid, key -> new Object2IntOpenHashMap());
            for (String factionName : root.func_150296_c()) {
                int value = root.func_74762_e(factionName);
                mapping.put(factionName, value);
            }
        }
    }

    public void syncPlayerReputationData(EntityPlayerMP player) {
        CQRMain.NETWORK.sendTo((IMessage)new SPacketInitialFactionInformation(player.getPersistentID(), this.getLoadedFactions(), this.playerFactionRepuMap.getOrDefault(player.getPersistentID(), (Object2IntMap<String>)Object2IntMaps.emptyMap())), player);
    }

    public void savePlayerReputationData(EntityPlayerMP player) {
        if (this.playerFactionRepuMap.containsKey(player.getPersistentID())) {
            CQRMain.logger.info("Saving player reputation...");
            this.savePlayerReputation(player.getPersistentID(), true);
        }
    }

    public void saveAllReputationData(boolean removeMapsFromMemory) {
        for (UUID playerID : this.playerFactionRepuMap.keySet()) {
            this.savePlayerReputation(playerID);
        }
        if (removeMapsFromMemory) {
            this.playerFactionRepuMap.clear();
        }
    }

    public void savePlayerReputation(UUID playerID) {
        this.savePlayerReputation(playerID, false);
    }

    public void savePlayerReputation(UUID playerID, boolean removeFromMap) {
        Map mapping = (Map)this.playerFactionRepuMap.get(playerID);
        NBTTagCompound root = new NBTTagCompound();
        for (Map.Entry entry : mapping.entrySet()) {
            root.func_74768_a((String)entry.getKey(), ((Integer)entry.getValue()).intValue());
        }
        File folder = new File(DimensionManager.getCurrentSaveRootDirectory(), "data/CQR/reputation");
        File file = new File(folder, playerID + ".nbt");
        FileIOUtil.writeNBTToFile(root, file);
        if (removeFromMap) {
            this.playerFactionRepuMap.remove(playerID);
        }
    }

    public Collection<Faction> getLoadedFactions() {
        return Collections.unmodifiableCollection(this.factions.values());
    }
}

