/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.event.capability;

import com.google.common.base.Predicates;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.DamageSource;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import team.cqr.cqrepoured.CQRMain;
import team.cqr.cqrepoured.capability.electric.CapabilityElectricShock;
import team.cqr.cqrepoured.capability.electric.CapabilityElectricShockProvider;
import team.cqr.cqrepoured.capability.electric.IDontSpreadElectrocution;
import team.cqr.cqrepoured.config.CQRConfig;
import team.cqr.cqrepoured.entity.IMechanical;
import team.cqr.cqrepoured.entity.ai.target.TargetUtil;
import team.cqr.cqrepoured.init.CQRCreatureAttributes;
import team.cqr.cqrepoured.network.server.packet.SPacketUpdateElectrocuteCapability;

@Mod.EventBusSubscriber(modid="cqrepoured")
public class ElectricEventHandler {
    @SubscribeEvent
    public static void onStartTracking(PlayerEvent.StartTracking event) {
        Entity entity = event.getTarget();
        if (!(entity instanceof EntityLivingBase && ElectricEventHandler.checkForCapabilityAndServerSide((EntityLivingBase)entity) && entity instanceof EntityPlayerMP)) {
            return;
        }
        CQRMain.NETWORK.sendTo((IMessage)new SPacketUpdateElectrocuteCapability((EntityLivingBase)entity), (EntityPlayerMP)event.getEntityPlayer());
    }

    @SubscribeEvent
    public static void onLogIn(PlayerEvent.PlayerLoggedInEvent event) {
        EntityPlayer entity = event.player;
        if (!ElectricEventHandler.checkForCapabilityAndServerSide((EntityLivingBase)entity) || !(entity instanceof EntityPlayerMP)) {
            return;
        }
        CQRMain.NETWORK.sendTo((IMessage)new SPacketUpdateElectrocuteCapability((EntityLivingBase)entity), (EntityPlayerMP)entity);
    }

    @SubscribeEvent
    public static void onRespawn(PlayerEvent.PlayerRespawnEvent event) {
        EntityPlayer entity = event.player;
        if (!ElectricEventHandler.checkForCapabilityAndServerSide((EntityLivingBase)entity) || !(entity instanceof EntityPlayerMP)) {
            return;
        }
        CapabilityElectricShock icapability = (CapabilityElectricShock)entity.getCapability(CapabilityElectricShockProvider.ELECTROCUTE_HANDLER_CQR, null);
        icapability.setRemainingTicks(-1);
    }

    @SubscribeEvent
    public static void onChangeDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        EntityPlayer entity = event.player;
        if (!ElectricEventHandler.checkForCapabilityAndServerSide((EntityLivingBase)entity) || !(entity instanceof EntityPlayerMP)) {
            return;
        }
        CQRMain.NETWORK.sendTo((IMessage)new SPacketUpdateElectrocuteCapability((EntityLivingBase)entity), (EntityPlayerMP)entity);
    }

    private static boolean checkForCapabilityAndServerSide(EntityLivingBase entity) {
        if (!entity.hasCapability(CapabilityElectricShockProvider.ELECTROCUTE_HANDLER_CQR, null)) {
            return false;
        }
        return !entity.field_70170_p.field_72995_K;
    }

    @SubscribeEvent
    public static void onLivingUpdateEvent(LivingEvent.LivingUpdateEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        if (!ElectricEventHandler.checkForCapabilityAndServerSide(entity)) {
            return;
        }
        CapabilityElectricShock currentCap = (CapabilityElectricShock)entity.getCapability(CapabilityElectricShockProvider.ELECTROCUTE_HANDLER_CQR, null);
        currentCap.reduceRemainingTicks();
        if (entity instanceof IMechanical || entity.func_70668_bt() == CQRCreatureAttributes.MECHANICAL) {
            if (((IMechanical)entity).canReceiveElectricDamageCurrently()) {
                currentCap.setRemainingTicks(100);
                entity.func_70097_a(DamageSource.field_180137_b, 2.0f);
            }
        } else if (currentCap.isElectrocutionActive()) {
            entity.func_70097_a(DamageSource.field_180137_b, 1.0f);
        }
        if (!entity.func_70089_S()) {
            currentCap.setTarget(null);
        }
        if (!(entity instanceof IDontSpreadElectrocution) && currentCap.canSpread() && currentCap.getTarget() == null && currentCap.getRemainignSpreads() > 0) {
            ElectricEventHandler.spreadElectrocute(entity, currentCap);
        } else if (currentCap.getTarget() != null) {
            if (!currentCap.getTarget().func_70089_S() || !entity.func_70685_l(currentCap.getTarget()) || entity.func_70032_d(currentCap.getTarget()) > 16.0f) {
                currentCap.setTarget(null);
            } else {
                CapabilityElectricShock targetCap = (CapabilityElectricShock)currentCap.getTarget().getCapability(CapabilityElectricShockProvider.ELECTROCUTE_HANDLER_CQR, null);
                if (targetCap != null) {
                    targetCap.setRemainingTicks(100);
                }
            }
        }
    }

    private static void spreadElectrocute(EntityLivingBase spreader, CapabilityElectricShock sourceCap) {
        List entities = spreader.func_130014_f_().func_175647_a(EntityLivingBase.class, spreader.func_174813_aQ().func_186662_g(12.0), Predicates.and(TargetUtil.PREDICATE_CAN_BE_ELECTROCUTED, entityLiving -> {
            if (entityLiving.getPersistentID().equals(sourceCap.getCasterID())) {
                return false;
            }
            if (!spreader.func_70685_l((Entity)entityLiving)) {
                return false;
            }
            if (spreader.func_70032_d((Entity)entityLiving) > CQRConfig.general.electricFieldEffectSpreadRange) {
                return false;
            }
            return !TargetUtil.isAllyCheckingLeaders(spreader, entityLiving);
        }));
        if (entities.isEmpty()) {
            return;
        }
        EntityLivingBase chosen = (EntityLivingBase)entities.get(spreader.field_70170_p.field_73012_v.nextInt(entities.size()));
        sourceCap.setTarget((Entity)chosen);
        sourceCap.reduceSpreads();
        CapabilityElectricShock targetCap = (CapabilityElectricShock)chosen.getCapability(CapabilityElectricShockProvider.ELECTROCUTE_HANDLER_CQR, null);
        targetCap.setRemainingTicks(100);
        targetCap.setCasterID(sourceCap.getCasterID());
        if (targetCap.getRemainignSpreads() < 0 || targetCap.getRemainignSpreads() >= sourceCap.getRemainignSpreads()) {
            targetCap.setRemainingSpreads(sourceCap.getRemainignSpreads() - 1);
        }
    }
}

