/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.entity.trade;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.inventory.Container;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import team.cqr.cqrepoured.CQRMain;
import team.cqr.cqrepoured.entity.bases.AbstractEntityCQR;
import team.cqr.cqrepoured.entity.trade.Trade;
import team.cqr.cqrepoured.faction.Faction;
import team.cqr.cqrepoured.inventory.ContainerMerchant;
import team.cqr.cqrepoured.network.server.packet.SPacketSyncTrades;

public class TraderOffer {
    private final AbstractEntityCQR entity;
    private final List<Trade> trades = new ArrayList<Trade>();

    public TraderOffer(AbstractEntityCQR trader) {
        this.entity = trader;
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.trades.clear();
        NBTTagList tradesNBT = nbt.func_150295_c("trades", 10);
        for (NBTBase tag : tradesNBT) {
            this.trades.add(Trade.createFromNBT(this, (NBTTagCompound)tag));
        }
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        NBTTagList tradesNBT = new NBTTagList();
        for (Trade trade : this.trades) {
            tradesNBT.func_74742_a((NBTBase)trade.writeToNBT());
        }
        nbt.func_74782_a("trades", (NBTBase)tradesNBT);
        return nbt;
    }

    public Faction getTraderFaction() {
        return this.entity.getFaction();
    }

    public boolean isEmpty() {
        return this.trades.isEmpty();
    }

    public Trade get(int index) {
        if (index < 0 || index >= this.trades.size()) {
            return null;
        }
        return this.trades.get(index);
    }

    public List<Trade> getTrades() {
        return Collections.unmodifiableList(this.trades);
    }

    public int size() {
        return this.trades.size();
    }

    public void onTradesUpdated() {
        if (!this.entity.field_70170_p.field_72995_K) {
            this.entity.field_70170_p.field_73010_i.stream().map(p -> p.field_71070_bA).filter(Objects::nonNull).filter(ContainerMerchant.class::isInstance).map(ContainerMerchant.class::cast).filter(c -> c.getMerchant() == this.entity).forEach(c -> c.onTradesUpdated());
            CQRMain.NETWORK.sendToAllTracking((IMessage)new SPacketSyncTrades(this.entity), (Entity)this.entity);
        } else {
            Container c2 = Minecraft.func_71410_x().field_71439_g.field_71070_bA;
            if (c2 instanceof ContainerMerchant) {
                ((ContainerMerchant)c2).onTradesUpdated();
            }
        }
    }

    public boolean updateTradeIndex(int index, int newIndex) {
        if (index < 0 || index >= this.trades.size() || newIndex < 0 || newIndex >= this.trades.size() || index == newIndex) {
            return false;
        }
        Trade trade1 = this.trades.get(index);
        this.trades.set(index, this.get(newIndex));
        this.trades.set(newIndex, trade1);
        this.onTradesUpdated();
        return true;
    }

    public boolean deleteTrade(int index) {
        if (index < 0 || index >= this.trades.size()) {
            return false;
        }
        this.trades.remove(index);
        this.onTradesUpdated();
        return true;
    }

    public boolean editTrade(int index, Trade trade) {
        if (index < 0 || index > this.trades.size() || trade.getInputItems().isEmpty() || trade.getOutput().func_190926_b()) {
            return false;
        }
        if (index == this.trades.size()) {
            this.trades.add(trade);
        } else {
            this.trades.set(index, trade);
        }
        this.onTradesUpdated();
        return true;
    }
}

