/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.entity.trade;

import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import team.cqr.cqrepoured.CQRMain;
import team.cqr.cqrepoured.entity.trade.TradeInput;
import team.cqr.cqrepoured.entity.trade.TraderOffer;
import team.cqr.cqrepoured.faction.FactionRegistry;
import team.cqr.cqrepoured.util.CraftingHelper;

public class Trade {
    private static final Random rdm = new Random();
    private final TraderOffer holder;
    private NonNullList<TradeInput> inputs = NonNullList.func_191196_a();
    private NonNullList<TradeInput> inputsCompressed = NonNullList.func_191196_a();
    private NonNullList<TradeInput> inputsCompressedMetaSorted = NonNullList.func_191196_a();
    private NonNullList<TradeInput> inputsCompressedNBTSorted = NonNullList.func_191196_a();
    private ItemStack output;
    private boolean isSimple = true;
    private int requiredReputation = Integer.MIN_VALUE;
    private ResourceLocation requiredAdvancement = null;
    private boolean hasLimitedStock = false;
    private int restockRate = 5;
    private int inStock = 10;
    private int maxStock = 20;

    public Trade(TraderOffer holder, int requiredMinReputation, @Nullable ResourceLocation requiredAdvancement, boolean hasLimitedStock, int restockRate, int inStock, int maxStock, ItemStack output, TradeInput ... inputs) {
        this.holder = holder;
        this.requiredReputation = requiredMinReputation;
        this.requiredAdvancement = requiredAdvancement;
        this.hasLimitedStock = hasLimitedStock;
        this.restockRate = restockRate;
        this.inStock = inStock;
        this.maxStock = maxStock;
        this.output = output.func_77946_l();
        for (TradeInput input : inputs) {
            if (input == null || input.getStack().func_190926_b()) continue;
            this.inputs.add((Object)input);
        }
        this.fixInput();
        this.checkIfSimple();
        this.updateInputItemsCompressed();
    }

    private Trade(TraderOffer holder) {
        this.holder = holder;
    }

    public static Trade createFromNBT(TraderOffer holder, NBTTagCompound nbt) {
        Trade trade = new Trade(holder);
        trade.readFromNBT(nbt);
        trade.updateInputItemsCompressed();
        return trade;
    }

    private void readFromNBT(NBTTagCompound nbt) {
        this.inputs.clear();
        NBTTagList inItems = nbt.func_150295_c("inputs", 10);
        for (NBTBase tag : inItems) {
            this.inputs.add((Object)new TradeInput((NBTTagCompound)tag));
        }
        this.output = new ItemStack(nbt.func_74775_l("output"));
        this.isSimple = nbt.func_74767_n("isSimple");
        this.requiredReputation = nbt.func_74762_e("requiredReputation");
        this.requiredAdvancement = nbt.func_150297_b("requiredAdvancement", 8) ? new ResourceLocation(nbt.func_74779_i("requiredAdvancement")) : null;
        this.hasLimitedStock = nbt.func_74767_n("hasLimitedStock");
        this.restockRate = nbt.func_74762_e("restockRate");
        this.inStock = nbt.func_74762_e("inStock");
        this.maxStock = nbt.func_74762_e("maxStock");
    }

    public NBTTagCompound writeToNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        NBTTagList inItems = new NBTTagList();
        for (TradeInput input : this.inputs) {
            inItems.func_74742_a((NBTBase)input.writeToNBT());
        }
        nbt.func_74782_a("inputs", (NBTBase)inItems);
        nbt.func_74782_a("output", (NBTBase)this.output.func_77955_b(new NBTTagCompound()));
        nbt.func_74757_a("isSimple", this.isSimple);
        nbt.func_74757_a("hasLimitedStock", this.hasLimitedStock);
        nbt.func_74768_a("restockRate", this.restockRate);
        nbt.func_74768_a("inStock", this.inStock);
        nbt.func_74768_a("maxStock", this.maxStock);
        nbt.func_74768_a("requiredReputation", this.requiredReputation);
        if (this.requiredAdvancement != null) {
            nbt.func_74778_a("requiredAdvancement", this.requiredAdvancement.toString());
        }
        return nbt;
    }

    private void fixInput() {
        block0: for (int i = 0; i < this.inputs.size(); ++i) {
            TradeInput input = (TradeInput)this.inputs.get(i);
            ItemStack stack = input.getStack();
            if (stack.func_190926_b()) {
                this.inputs.remove(i--);
                continue;
            }
            for (int j = 0; j < i; ++j) {
                ItemStack stack1;
                TradeInput input1 = (TradeInput)this.inputs.get(j);
                if (input.ignoreMeta() != input1.ignoreMeta() || input.ignoreNBT() != input1.ignoreNBT() || !CraftingHelper.areItemStacksEqualIgnoreCount(stack, stack1 = input1.getStack(), input.ignoreMeta(), input.ignoreNBT())) continue;
                int k = Math.min(stack.func_190916_E(), stack1.func_77976_d() - stack1.func_190916_E());
                stack1.func_190917_f(k);
                stack.func_190918_g(k);
                if (!stack.func_190926_b()) continue;
                this.inputs.remove(i--);
                continue block0;
            }
        }
    }

    private void checkIfSimple() {
        HashSet<Item> items = new HashSet<Item>();
        for (TradeInput input : this.inputs) {
            items.add(input.getStack().func_77973_b());
        }
        for (Item item : items) {
            boolean flag1 = false;
            boolean flag2 = false;
            boolean flag3 = false;
            boolean flag4 = false;
            for (TradeInput input : this.inputs) {
                if (input.getStack().func_77973_b() != item) continue;
                if (input.ignoreMeta() && input.ignoreNBT()) {
                    flag1 = true;
                    continue;
                }
                if (input.ignoreMeta()) {
                    flag2 = true;
                    continue;
                }
                if (input.ignoreNBT()) {
                    flag3 = true;
                    continue;
                }
                flag4 = true;
            }
            if ((!flag1 || !flag2 && !flag3 && !flag4) && (!flag2 || !flag3 && !flag4) && (!flag3 || !flag4)) continue;
            this.isSimple = false;
            break;
        }
    }

    private void updateInputItemsCompressed() {
        this.inputsCompressed.clear();
        this.inputsCompressedMetaSorted.clear();
        this.inputsCompressedNBTSorted.clear();
        for (TradeInput input : this.inputs) {
            TradeInput copy = input.copy();
            ItemStack stack = copy.getStack();
            for (int i = 0; i < this.inputsCompressed.size(); ++i) {
                ItemStack stack1;
                TradeInput input1 = (TradeInput)this.inputsCompressed.get(i);
                if (copy.ignoreMeta() != input1.ignoreMeta() || copy.ignoreNBT() != input1.ignoreNBT() || !CraftingHelper.areItemStacksEqualIgnoreCount(stack, stack1 = input1.getStack(), copy.ignoreMeta(), copy.ignoreNBT())) continue;
                stack1.func_190917_f(stack.func_190916_E());
                stack.func_190918_g(stack.func_190916_E());
                break;
            }
            if (stack.func_190926_b()) continue;
            this.inputsCompressed.add((Object)copy);
        }
        for (TradeInput input : this.inputsCompressed) {
            this.inputsCompressedMetaSorted.add((Object)input.copy());
        }
        for (TradeInput input : this.inputsCompressed) {
            this.inputsCompressedNBTSorted.add((Object)input.copy());
        }
        this.inputsCompressedMetaSorted.sort(TradeInput.SORT_META);
        this.inputsCompressedNBTSorted.sort(TradeInput.SORT_NBT);
    }

    public boolean doItemsMatch(ItemStack[] input) {
        if (this.isSimple) {
            NonNullList<TradeInput> tradeInputs = this.getInputItemsCompressed();
            for (TradeInput tradeInput : tradeInputs) {
                if (CraftingHelper.remove(input, tradeInput.getStack(), true, tradeInput.ignoreMeta(), tradeInput.ignoreNBT())) continue;
                return false;
            }
            return true;
        }
        NonNullList<TradeInput> tradeInputsMetaSorted = this.getInputItemsCompressedMetaSorted();
        ItemStack[] inputCopy1 = this.copyStacks(input);
        boolean flag = true;
        for (TradeInput tradeInput : tradeInputsMetaSorted) {
            if (CraftingHelper.remove(inputCopy1, tradeInput.getStack(), false, tradeInput.ignoreMeta(), tradeInput.ignoreNBT())) continue;
            flag = false;
            break;
        }
        if (flag) {
            return true;
        }
        NonNullList<TradeInput> tradeInputsNBTSorted = this.getInputItemsCompressedNBTSorted();
        ItemStack[] inputCopy2 = this.copyStacks(input);
        for (TradeInput tradeInput : tradeInputsNBTSorted) {
            if (CraftingHelper.remove(inputCopy2, tradeInput.getStack(), false, tradeInput.ignoreMeta(), tradeInput.ignoreNBT())) continue;
            return false;
        }
        return true;
    }

    public boolean doTransaction(EntityPlayer player, ItemStack[] input) {
        if (!this.isInStock()) {
            return false;
        }
        if (!this.isUnlockedFor(player)) {
            return false;
        }
        if (this.isSimple) {
            if (!this.doItemsMatch(input)) {
                return false;
            }
            NonNullList<TradeInput> tradeInputs = this.getInputItemsCompressed();
            for (TradeInput tradeInput : tradeInputs) {
                if (CraftingHelper.remove(input, tradeInput.getStack(), false, tradeInput.ignoreMeta(), tradeInput.ignoreNBT())) continue;
                return false;
            }
            if (!player.field_70170_p.field_72995_K) {
                this.decStock();
            }
            return true;
        }
        NonNullList<TradeInput> tradeInputsMetaSorted = this.getInputItemsCompressedMetaSorted();
        ItemStack[] inputCopy1 = this.copyStacks(input);
        boolean flag = true;
        for (TradeInput tradeInput : tradeInputsMetaSorted) {
            if (CraftingHelper.remove(inputCopy1, tradeInput.getStack(), false, tradeInput.ignoreMeta(), tradeInput.ignoreNBT())) continue;
            flag = false;
            break;
        }
        if (flag) {
            for (TradeInput tradeInput : tradeInputsMetaSorted) {
                CraftingHelper.remove(input, tradeInput.getStack(), false, tradeInput.ignoreMeta(), tradeInput.ignoreNBT());
            }
            this.decStock();
            return true;
        }
        flag = true;
        NonNullList<TradeInput> tradeInputsNBTSorted = this.getInputItemsCompressedNBTSorted();
        ItemStack[] inputCopy2 = this.copyStacks(input);
        for (TradeInput tradeInput : tradeInputsNBTSorted) {
            if (CraftingHelper.remove(inputCopy2, tradeInput.getStack(), false, tradeInput.ignoreMeta(), tradeInput.ignoreNBT())) continue;
            flag = false;
            break;
        }
        if (flag) {
            for (TradeInput tradeInput : tradeInputsNBTSorted) {
                CraftingHelper.remove(input, tradeInput.getStack(), false, tradeInput.ignoreMeta(), tradeInput.ignoreNBT());
            }
            this.decStock();
            return true;
        }
        return false;
    }

    private ItemStack[] copyStacks(ItemStack[] stacks) {
        ItemStack[] copy = new ItemStack[stacks.length];
        for (int i = 0; i < stacks.length; ++i) {
            copy[i] = stacks[i].func_77946_l();
        }
        return copy;
    }

    public ItemStack getOutput() {
        return this.output.func_77946_l();
    }

    @SideOnly(value=Side.CLIENT)
    public ItemStack getOutputClient() {
        return this.output;
    }

    public NonNullList<TradeInput> getInputItems() {
        NonNullList list = NonNullList.func_191196_a();
        for (TradeInput input : this.inputs) {
            list.add((Object)input.copy());
        }
        return list;
    }

    @SideOnly(value=Side.CLIENT)
    public NonNullList<TradeInput> getInputItemsClient() {
        return this.inputs;
    }

    private NonNullList<TradeInput> getInputItemsCompressed() {
        NonNullList list = NonNullList.func_191196_a();
        for (TradeInput input : this.inputsCompressed) {
            list.add((Object)input.copy());
        }
        return list;
    }

    private NonNullList<TradeInput> getInputItemsCompressedMetaSorted() {
        NonNullList list = NonNullList.func_191196_a();
        for (TradeInput input : this.inputsCompressedMetaSorted) {
            list.add((Object)input.copy());
        }
        return list;
    }

    private NonNullList<TradeInput> getInputItemsCompressedNBTSorted() {
        NonNullList list = NonNullList.func_191196_a();
        for (TradeInput input : this.inputsCompressedNBTSorted) {
            list.add((Object)input.copy());
        }
        return list;
    }

    public boolean isUnlockedFor(EntityPlayer player) {
        if (this.requiredReputation != Integer.MIN_VALUE && FactionRegistry.instance((Entity)player).getExactReputationOf(player.func_110124_au(), this.holder.getTraderFaction()) < this.requiredReputation) {
            return false;
        }
        return this.requiredAdvancement == null || CQRMain.proxy.hasAdvancement(player, this.requiredAdvancement);
    }

    public void incStock() {
        if (this.canRestock()) {
            this.inStock = Math.min(this.inStock + this.restockRate, this.maxStock);
            this.holder.onTradesUpdated();
        }
    }

    public void decStock() {
        List trades;
        if (!this.isInStock()) {
            return;
        }
        if (this.hasLimitedStock) {
            --this.inStock;
            this.holder.onTradesUpdated();
        }
        if (!(trades = this.holder.getTrades().stream().filter(Trade::canRestock).filter(trade -> trade != this).collect(Collectors.toList())).isEmpty()) {
            ((Trade)trades.get(rdm.nextInt(trades.size()))).incStock();
        }
    }

    public boolean isInStock() {
        return !this.hasLimitedStock || this.inStock > 0;
    }

    public TraderOffer getHolder() {
        return this.holder;
    }

    public int getRequiredReputation() {
        return this.requiredReputation;
    }

    public ResourceLocation getRequiredAdvancement() {
        return this.requiredAdvancement;
    }

    public boolean hasLimitedStock() {
        return this.hasLimitedStock;
    }

    public int getRestockRate() {
        return this.restockRate;
    }

    public int getInStock() {
        return this.inStock;
    }

    public int getMaxStock() {
        return this.maxStock;
    }

    public boolean canRestock() {
        return this.hasLimitedStock && this.restockRate > 0 && this.inStock < this.maxStock;
    }
}

