/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.entity.projectiles;

import io.netty.buffer.ByteBuf;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MultiPartEntityPart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import team.cqr.cqrepoured.CQRMain;
import team.cqr.cqrepoured.config.CQRConfig;
import team.cqr.cqrepoured.entity.projectiles.ProjectileBase;
import team.cqr.cqrepoured.init.CQRSerializers;
import team.cqr.cqrepoured.item.ItemHookshotBase;

public class ProjectileHookShotHook
extends ProjectileBase
implements IEntityAdditionalSpawnData {
    private static final DataParameter<Byte> HOOK_STATE = EntityDataManager.func_187226_a(ProjectileHookShotHook.class, (DataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Integer> LATCHED_ENTITY = EntityDataManager.func_187226_a(ProjectileHookShotHook.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Vec3d> LATCHED_POS = EntityDataManager.func_187226_a(ProjectileHookShotHook.class, CQRSerializers.VEC3D);
    private double range;
    private double speed;
    private Vec3d startLocation = Vec3d.field_186680_a;
    private ItemStack stack;
    private ItemHookshotBase item;
    private Entity latchedEntity;
    private Vec3d lastCheckedPosition;
    private int lastMovementCheckTick;

    public ProjectileHookShotHook(World worldIn) {
        super(worldIn);
    }

    public ProjectileHookShotHook(World worldIn, EntityLivingBase shooter, ItemHookshotBase item, ItemStack stack) {
        super(worldIn, shooter);
        this.item = item;
        this.stack = stack;
    }

    public void shootHook(EntityLivingBase shooter, double range, double speed) {
        double x = shooter.field_70165_t;
        double y = shooter.field_70163_u + (double)shooter.func_70047_e();
        double z = shooter.field_70161_v;
        float yaw = shooter.field_70177_z;
        float pitch = shooter.field_70125_A;
        this.shootHook(x, y, z, yaw, pitch, range, speed);
    }

    public void shootHook(EntityLivingBase shooter, double dirX, double dirY, double dirZ, double range, double speed) {
        double x = shooter.field_70165_t;
        double y = shooter.field_70163_u + (double)shooter.func_70047_e();
        double z = shooter.field_70161_v;
        float yaw = (float)(-Math.toDegrees(Math.atan2(dirX, dirZ)));
        double d = Math.sqrt(dirX * dirX + dirZ * dirZ);
        float pitch = (float)(-Math.toDegrees(Math.atan2(dirY, d)));
        this.shootHook(x, y, z, yaw, pitch, range, speed);
    }

    public void shootHook(double x, double y, double z, float yaw, float pitch, double range, double speed) {
        Vec3d v = Vec3d.func_189986_a((float)pitch, (float)yaw);
        this.func_70107_b(x, y, z);
        this.startLocation = new Vec3d(x, y, z);
        this.field_70177_z = yaw;
        this.field_70125_A = pitch;
        this.range = range;
        this.speed = speed;
        this.field_70159_w = v.field_72450_a;
        this.field_70181_x = v.field_72448_b;
        this.field_70179_y = v.field_72449_c;
    }

    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeInt(this.field_70192_c.func_145782_y());
        buffer.writeFloat((float)this.range);
        buffer.writeFloat((float)this.speed);
        buffer.writeFloat((float)this.startLocation.field_72450_a);
        buffer.writeFloat((float)this.startLocation.field_72448_b);
        buffer.writeFloat((float)this.startLocation.field_72449_c);
        buffer.writeFloat(this.field_70177_z);
        buffer.writeFloat(this.field_70125_A);
    }

    public void readSpawnData(ByteBuf additionalData) {
        this.field_70192_c = (EntityLivingBase)this.field_70170_p.func_73045_a(additionalData.readInt());
        this.range = additionalData.readFloat();
        this.speed = additionalData.readFloat();
        double x = additionalData.readFloat();
        double y = additionalData.readFloat();
        double z = additionalData.readFloat();
        this.startLocation = new Vec3d(x, y, z);
        this.field_70126_B = this.field_70177_z = additionalData.readFloat();
        this.field_70127_C = this.field_70125_A = additionalData.readFloat();
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(HOOK_STATE, (Object)((byte)EnumHookState.SHOOT.getIndex()));
        this.field_70180_af.func_187214_a(LATCHED_ENTITY, (Object)-1);
        this.field_70180_af.func_187214_a(LATCHED_POS, (Object)Vec3d.field_186680_a);
    }

    public void func_70037_a(NBTTagCompound compound) {
    }

    public void func_70014_b(NBTTagCompound compound) {
    }

    public boolean func_184198_c(NBTTagCompound compound) {
        return false;
    }

    public boolean func_70039_c(NBTTagCompound compound) {
        return false;
    }

    public NBTTagCompound func_189511_e(NBTTagCompound compound) {
        return compound;
    }

    private EnumHookState getHookState() {
        return EnumHookState.byIndex(((Byte)this.field_70180_af.func_187225_a(HOOK_STATE)).byteValue());
    }

    private void setHookState(EnumHookState hookState) {
        this.field_70180_af.func_187227_b(HOOK_STATE, (Object)((byte)hookState.getIndex()));
    }

    @Nullable
    private Entity getLatchedEntity() {
        int latchedEntityId = (Integer)this.field_70180_af.func_187225_a(LATCHED_ENTITY);
        if (latchedEntityId == -1) {
            this.latchedEntity = null;
            return null;
        }
        if (this.latchedEntity == null || this.latchedEntity.func_145782_y() != latchedEntityId) {
            this.latchedEntity = this.field_70170_p.func_73045_a(latchedEntityId);
        }
        return this.latchedEntity;
    }

    private void setLatchedEntity(@Nullable Entity entity) {
        int latchedEntityId = entity != null ? entity.func_145782_y() : -1;
        this.field_70180_af.func_187227_b(LATCHED_ENTITY, (Object)latchedEntityId);
    }

    private Vec3d getLatchedPos() {
        return (Vec3d)this.field_70180_af.func_187225_a(LATCHED_POS);
    }

    private void setLatchedPos(Vec3d vec) {
        this.field_70180_af.func_187227_b(LATCHED_POS, (Object)vec);
    }

    @Override
    public boolean func_189652_ae() {
        return true;
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
        if (!this.field_70170_p.field_72995_K) {
            this.setHookItemShootingTag(true);
        }
    }

    public void onRemovedFromWorld() {
        if (!this.field_70170_p.field_72995_K) {
            if (this.field_70192_c instanceof EntityPlayer) {
                ((EntityPlayer)this.field_70192_c).func_184811_cZ().func_185145_a((Item)this.item, 0);
            }
            this.setHookItemShootingTag(false);
        }
        super.onRemovedFromWorld();
    }

    private void setHookItemShootingTag(boolean isShooting) {
        NBTTagCompound tag = this.stack.func_77978_p();
        if (tag == null) {
            tag = new NBTTagCompound();
            this.stack.func_77982_d(tag);
        }
        tag.func_74757_a("isShooting", isShooting);
    }

    @Override
    public void func_70071_h_() {
        this.hookStateMachine();
        float f1 = this.field_70177_z;
        float f2 = this.field_70125_A;
        super.func_70071_h_();
        this.field_70177_z = f1;
        this.field_70126_B = f1;
        this.field_70125_A = f2;
        this.field_70127_C = f2;
    }

    private void hookStateMachine() {
        switch (this.getHookState()) {
            case SHOOT: {
                this.handleStateShoot();
                break;
            }
            case RETRACT: {
                this.handleStateRetract();
                break;
            }
            case PULL_ENTITY_TO_SHOOTER: {
                this.handleStatePullEntityToShooter();
                break;
            }
            case PULL_SHOOTER_TO_HOOK_LATCHED_TO_BLOCK: {
                this.handleStatePullShooterToHookLatchedToBlock();
                break;
            }
            case PULL_SHOOTER_TO_HOOK_LATCHED_TO_ENTITY: {
                this.handleStatePullShooterToHookLatchedToEntity();
                break;
            }
            case STOPPED: {
                this.func_70106_y();
            }
        }
    }

    private void handleStateShoot() {
        Vec3d v = Vec3d.func_189986_a((float)this.field_70125_A, (float)this.field_70177_z);
        this.field_70159_w = v.field_72450_a * this.speed;
        this.field_70181_x = v.field_72448_b * this.speed;
        this.field_70179_y = v.field_72449_c * this.speed;
        double x = this.field_70165_t - this.startLocation.field_72450_a;
        double y = this.field_70163_u - this.startLocation.field_72448_b;
        double z = this.field_70161_v - this.startLocation.field_72449_c;
        double distSqr = x * x + y * y + z * z;
        double d = this.range;
        if (distSqr > d * d && !this.field_70170_p.field_72995_K) {
            this.setHookState(EnumHookState.RETRACT);
        }
    }

    private void handleStateRetract() {
        double d;
        double z;
        double x = this.field_70192_c.field_70165_t - this.field_70165_t;
        double y = this.field_70192_c.field_70163_u + (double)this.field_70192_c.func_70047_e() - this.field_70163_u;
        double distSqr = x * x + y * y + (z = this.field_70192_c.field_70161_v - this.field_70161_v) * z;
        if (distSqr < (d = this.speed + 0.1) * d) {
            this.field_70159_w = 0.0;
            this.field_70181_x = 0.0;
            this.field_70179_y = 0.0;
            if (!this.field_70170_p.field_72995_K) {
                this.setHookState(EnumHookState.STOPPED);
            }
        } else {
            double d1 = this.speed / Math.sqrt(distSqr);
            this.field_70159_w = x * d1;
            this.field_70181_x = y * d1;
            this.field_70179_y = z * d1;
        }
    }

    private void handleStatePullEntityToShooter() {
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
        Entity latchedEntity = this.getLatchedEntity();
        if (latchedEntity == null) {
            if (!this.field_70170_p.field_72995_K) {
                this.setHookState(EnumHookState.STOPPED);
            }
            return;
        }
        if (!this.field_70170_p.field_72995_K) {
            this.checkForEntityStuck(latchedEntity);
        }
        Vec3d v = this.getLatchedPos();
        this.func_70107_b(latchedEntity.field_70165_t + v.field_72450_a, latchedEntity.field_70163_u + v.field_72448_b, latchedEntity.field_70161_v + v.field_72449_c);
        double x = this.field_70192_c.field_70165_t - this.field_70165_t;
        double y = this.field_70192_c.field_70163_u + (double)this.field_70192_c.func_70047_e() - this.field_70163_u;
        double z = this.field_70192_c.field_70161_v - this.field_70161_v;
        double distSqr = x * x + y * y + z * z;
        double d = (double)latchedEntity.field_70130_N * 0.5 + (double)this.field_70192_c.field_70130_N * 0.5 + 1.5;
        if (distSqr < d * d) {
            latchedEntity.field_70159_w = 0.0;
            latchedEntity.field_70181_x = 0.0;
            latchedEntity.field_70179_y = 0.0;
            if (!this.field_70170_p.field_72995_K) {
                this.setHookState(EnumHookState.STOPPED);
            }
        } else {
            double d1 = this.speed * this.speed < distSqr ? this.speed / Math.sqrt(distSqr) : 1.0;
            latchedEntity.field_70159_w = x * d1;
            latchedEntity.field_70181_x = y * d1;
            latchedEntity.field_70179_y = z * d1;
        }
    }

    private void handleStatePullShooterToHookLatchedToBlock() {
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
        if (!this.field_70170_p.field_72995_K) {
            this.checkForEntityStuck((Entity)this.field_70192_c);
        } else if (this.field_70192_c == null || !(this.field_70192_c instanceof EntityPlayer) || !CQRMain.proxy.isPlayerCurrentClientPlayer((EntityPlayer)this.field_70192_c)) {
            return;
        }
        Vec3d v = this.getLatchedPos();
        this.func_70107_b(v.field_72450_a, v.field_72448_b, v.field_72449_c);
        Vec3d v1 = Vec3d.func_189986_a((float)0.0f, (float)this.field_70177_z);
        double x = this.field_70165_t - this.field_70192_c.field_70165_t + v1.field_72450_a * 0.1;
        double y = this.field_70163_u - this.field_70192_c.field_70163_u + 1.0;
        double z = this.field_70161_v - this.field_70192_c.field_70161_v + v1.field_72449_c * 0.1;
        double distSqr = x * x + y * y + z * z;
        double d = 0.1;
        if (y > 0.0) {
            this.field_70192_c.field_70143_R = 0.0f;
        }
        if (distSqr < d * d) {
            this.field_70192_c.field_70159_w *= 0.1;
            this.field_70192_c.field_70181_x *= 0.1;
            this.field_70192_c.field_70179_y *= 0.1;
            if (!this.field_70170_p.field_72995_K) {
                this.setHookState(EnumHookState.STOPPED);
            }
        } else {
            double d1 = this.speed * this.speed < distSqr ? this.speed / Math.sqrt(distSqr) : 1.0;
            this.field_70192_c.field_70159_w = x * d1;
            this.field_70192_c.field_70181_x = y * d1;
            this.field_70192_c.field_70179_y = z * d1;
        }
    }

    private void handleStatePullShooterToHookLatchedToEntity() {
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
        Entity latchedEntity = this.getLatchedEntity();
        if (latchedEntity == null) {
            if (!this.field_70170_p.field_72995_K) {
                this.setHookState(EnumHookState.STOPPED);
            }
            return;
        }
        if (!this.field_70170_p.field_72995_K) {
            this.checkForEntityStuck((Entity)this.field_70192_c);
        }
        Vec3d v = this.getLatchedPos();
        this.func_70107_b(latchedEntity.field_70165_t + v.field_72450_a, latchedEntity.field_70163_u + v.field_72448_b, latchedEntity.field_70161_v + v.field_72449_c);
        double x = this.field_70165_t - this.field_70192_c.field_70165_t;
        double y = this.field_70163_u - (this.field_70192_c.field_70163_u + (double)this.field_70192_c.func_70047_e());
        double z = this.field_70161_v - this.field_70192_c.field_70161_v;
        double distSqr = x * x + y * y + z * z;
        double d = (double)latchedEntity.field_70130_N * 0.5 + (double)this.field_70192_c.field_70130_N * 0.5 + 1.5;
        if (y > 0.0) {
            this.field_70192_c.field_70143_R = 0.0f;
        }
        if (distSqr < d * d) {
            this.field_70192_c.field_70159_w *= 0.05;
            this.field_70192_c.field_70181_x *= 0.05;
            this.field_70192_c.field_70179_y *= 0.05;
            if (!this.field_70170_p.field_72995_K) {
                this.setHookState(EnumHookState.STOPPED);
            }
        } else {
            double d1 = this.speed * this.speed < distSqr ? this.speed / Math.sqrt(distSqr) : 1.0;
            this.field_70192_c.field_70159_w = x * d1;
            this.field_70192_c.field_70181_x = y * d1;
            this.field_70192_c.field_70179_y = z * d1;
        }
    }

    private void checkForEntityStuck(Entity entity) {
        if (this.field_70173_aa - this.lastMovementCheckTick >= 4) {
            double distanceTraveledSqr;
            Vec3d currentPos = entity.func_174791_d();
            if (this.lastCheckedPosition != null && (distanceTraveledSqr = currentPos.func_72436_e(this.lastCheckedPosition)) < 0.16000000000000003) {
                this.setHookState(EnumHookState.STOPPED);
            }
            this.lastMovementCheckTick = this.field_70173_aa;
            this.lastCheckedPosition = currentPos;
        }
    }

    @Override
    protected void func_70184_a(RayTraceResult result) {
        if (!this.field_70170_p.field_72995_K && this.getHookState() == EnumHookState.SHOOT) {
            if (result.field_72313_a == RayTraceResult.Type.BLOCK) {
                IBlockState state = this.field_70170_p.func_180495_p(result.func_178782_a());
                if (this.item.canLatchToBlock(state.func_177230_c())) {
                    Vec3d v = result.field_72307_f;
                    this.func_70107_b(v.field_72450_a, v.field_72448_b, v.field_72449_c);
                    this.field_70159_w = 0.0;
                    this.field_70181_x = 0.0;
                    this.field_70179_y = 0.0;
                    this.setLatchedPos(v);
                    this.setHookState(EnumHookState.PULL_SHOOTER_TO_HOOK_LATCHED_TO_BLOCK);
                } else {
                    this.field_70159_w = 0.0;
                    this.field_70181_x = 0.0;
                    this.field_70179_y = 0.0;
                    this.setHookState(EnumHookState.RETRACT);
                }
            } else if (result.field_72313_a == RayTraceResult.Type.ENTITY && result.field_72308_g != this.field_70192_c && result.field_72308_g instanceof EntityLivingBase) {
                Entity entityHit = result.field_72308_g;
                Vec3d start = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                Vec3d end = start.func_72441_c(this.field_70159_w, this.field_70181_x, this.field_70179_y);
                AxisAlignedBB aabb = entityHit.func_174813_aQ().func_186662_g(0.3);
                RayTraceResult result1 = aabb.func_72327_a(start, end);
                Vec3d v = result1.field_72307_f;
                this.func_70107_b(v.field_72450_a, v.field_72448_b, v.field_72449_c);
                this.field_70159_w = 0.0;
                this.field_70181_x = 0.0;
                this.field_70179_y = 0.0;
                this.setLatchedEntity(entityHit);
                this.setLatchedPos(v.func_178786_a(entityHit.field_70165_t, entityHit.field_70163_u, entityHit.field_70161_v));
                if (CQRConfig.general.hookOnlyPullsSmallerEntities) {
                    double sizeOwner = (double)(this.field_70192_c.field_70130_N * this.field_70192_c.field_70131_O) * 1.25;
                    double sizeHit = entityHit.field_70130_N * entityHit.field_70131_O;
                    if (sizeOwner >= sizeHit || entityHit instanceof MultiPartEntityPart) {
                        this.setHookState(EnumHookState.PULL_ENTITY_TO_SHOOTER);
                    } else {
                        this.setHookState(EnumHookState.PULL_SHOOTER_TO_HOOK_LATCHED_TO_ENTITY);
                    }
                } else {
                    this.setHookState(EnumHookState.PULL_ENTITY_TO_SHOOTER);
                }
            }
        }
    }

    private static enum EnumHookState {
        SHOOT(0),
        RETRACT(1),
        PULL_ENTITY_TO_SHOOTER(2),
        PULL_SHOOTER_TO_HOOK_LATCHED_TO_BLOCK(3),
        PULL_SHOOTER_TO_HOOK_LATCHED_TO_ENTITY(4),
        STOPPED(5);

        private final int index;

        private EnumHookState(int index) {
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }

        public static EnumHookState byIndex(int index) {
            for (EnumHookState hookState : EnumHookState.values()) {
                if (hookState.index != index) continue;
                return hookState;
            }
            return SHOOT;
        }
    }
}

