/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.entity.projectiles;

import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import team.cqr.cqrepoured.entity.projectiles.ProjectileBase;
import team.cqr.cqrepoured.util.EntityUtil;

public class ProjectileBullet
extends ProjectileBase
implements IEntityAdditionalSpawnData {
    private int type;

    public ProjectileBullet(World worldIn) {
        super(worldIn);
    }

    public ProjectileBullet(World worldIn, double x, double y, double z, int type) {
        super(worldIn, x, y, z);
        this.type = type;
    }

    public ProjectileBullet(World worldIn, EntityLivingBase shooter, int type) {
        super(worldIn, shooter);
        this.type = type;
    }

    public int getType() {
        return this.type;
    }

    @Override
    protected void func_70184_a(RayTraceResult result) {
        if (!this.field_70170_p.field_72995_K) {
            if (result.field_72313_a == RayTraceResult.Type.ENTITY) {
                if (result.field_72308_g == this.field_70192_c) {
                    return;
                }
                if (result.field_72308_g instanceof EntityLivingBase) {
                    EntityLivingBase entity = (EntityLivingBase)result.field_72308_g;
                    float damage = 5.0f;
                    if (this.type == 1) {
                        damage += 2.5f;
                    } else if (this.type == 2) {
                        damage += 3.75f;
                    } else if (this.type == 3) {
                        damage += 5.0f;
                    } else if (this.type == 4 && entity.func_70097_a(new EntityDamageSourceIndirect("onFire", (Entity)this, (Entity)this.field_70192_c).func_76361_j(), (damage += 5.0f) / 2.0f)) {
                        entity.func_70015_d(3);
                    }
                    if (EntityUtil.isEntityFlying((Entity)entity)) {
                        damage *= 2.0f;
                    }
                    entity.func_70097_a(DamageSource.func_188403_a((Entity)this, (EntityLivingBase)this.field_70192_c), damage);
                    this.func_70106_y();
                }
            }
            super.func_70184_a(result);
        }
    }

    @Override
    protected void onUpdateInAir() {
        if (this.field_70170_p.field_72995_K && this.field_70173_aa < 10) {
            this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeInt(this.type);
    }

    public void readSpawnData(ByteBuf additionalData) {
        this.type = additionalData.readInt();
    }
}

