/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.entity.boss.netherdragon;

import com.github.alexthe666.iceandfire.entity.IBlacklistedFromStatues;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.IEntityMultiPart;
import net.minecraft.entity.MultiPartEntityPart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import team.cqr.cqrepoured.entity.IDontRenderFire;
import team.cqr.cqrepoured.entity.boss.netherdragon.EntityCQRNetherDragon;

public class SubEntityNetherDragonSegment
extends MultiPartEntityPart
implements IBlacklistedFromStatues,
IDontRenderFire {
    private EntityCQRNetherDragon dragon;
    private int partIndex = 0;
    private int realID = 0;
    private boolean isSkeletal = false;

    public SubEntityNetherDragonSegment(EntityCQRNetherDragon dragon, int partID, boolean skeletal) {
        super((IEntityMultiPart)dragon, "dragonPart" + partID, 0.5f, 0.5f);
        this.func_70105_a(1.25f, 1.25f);
        this.dragon = dragon;
        this.partIndex = dragon.INITIAL_SEGMENT_COUNT - partID;
        this.realID = partID;
        this.func_82142_c(false);
    }

    public void onRemovedFromBody() {
    }

    public boolean isSkeletal() {
        return this.isSkeletal || this.dragon == null || this.dragon.getSkeleProgress() >= this.realID;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (source.func_94541_c() || source.func_76347_k() || this.dragon == null) {
            return false;
        }
        return this.dragon.func_70965_a(this, source, amount);
    }

    public boolean func_70067_L() {
        return true;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        ++this.field_70173_aa;
        if (this.dragon.getSegmentCount() < this.partIndex) {
            this.func_70106_y();
        }
        if (this.field_70170_p.field_72995_K && (this.dragon == null || this.dragon.field_70128_L)) {
            this.func_70106_y();
        }
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
    }

    public void func_70101_b(float yaw, float pitch) {
        super.func_70101_b(yaw, pitch);
    }

    public boolean func_184230_a(EntityPlayer player, EnumHand hand) {
        if (this.dragon == null || this.dragon.field_70128_L) {
            return false;
        }
        return this.dragon.func_184230_a(player, hand);
    }

    @Nullable
    public EntityCQRNetherDragon getParent() {
        return this.dragon;
    }

    public void explode() {
        if (!this.field_70170_p.field_72995_K) {
            this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, 1.0f, false);
        }
    }

    public void switchToSkeletalState() {
        if (!this.field_70170_p.field_72995_K) {
            this.isSkeletal = true;
            this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.0f, false);
        }
    }

    public void die() {
        this.explode();
    }

    protected void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74757_a("skeletal", this.isSkeletal());
        compound.func_74768_a("realID", this.realID);
        compound.func_74768_a("partIndex", this.partIndex);
    }

    protected void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.realID = compound.func_74762_e("realID");
        this.partIndex = compound.func_74762_e("partIndex");
    }

    @Override
    public boolean canBeTurnedToStone() {
        return false;
    }

    public int getPartIndex() {
        return this.partIndex;
    }
}

