/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.entity.boss.endercalamity;

import com.google.common.base.Optional;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import team.cqr.cqrepoured.config.CQRConfig;
import team.cqr.cqrepoured.entity.ai.target.TargetUtil;
import team.cqr.cqrepoured.faction.Faction;
import team.cqr.cqrepoured.faction.FactionRegistry;
import team.cqr.cqrepoured.util.DungeonGenUtils;

public class EntityCalamityCrystal
extends Entity {
    private EntityLiving owningEntity;
    private EntityLivingBase currentTarget;
    public int innerRotation;
    private int noTargetTicks = 0;
    private static final int MAX_NO_TARGET_TICKS = 100;
    private float absorbedHealth = 0.0f;
    private static final DataParameter<Optional<BlockPos>> BEAM_TARGET = EntityDataManager.func_187226_a(EntityCalamityCrystal.class, (DataSerializer)DataSerializers.field_187201_k);
    private static final DataParameter<Boolean> ABSORBING = EntityDataManager.func_187226_a(EntityCalamityCrystal.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final int EXPLOSION_EFFECT_RADIUS = 16;

    public EntityCalamityCrystal(World worldIn) {
        super(worldIn);
        this.field_70156_m = true;
        this.func_70105_a(2.0f, 2.0f);
        this.innerRotation = this.field_70146_Z.nextInt(100000);
    }

    public EntityCalamityCrystal(World world, EntityLiving owningEntity, double x, double y, double z) {
        this(world);
        this.owningEntity = owningEntity;
        this.func_70107_b(x, y, z);
    }

    protected boolean func_70041_e_() {
        return false;
    }

    protected void func_70088_a() {
        this.func_184212_Q().func_187214_a(BEAM_TARGET, (Object)Optional.absent());
        this.func_184212_Q().func_187214_a(ABSORBING, (Object)true);
    }

    public boolean func_70067_L() {
        return true;
    }

    protected void func_70037_a(NBTTagCompound compound) {
        if (compound.func_150297_b("BeamTarget", 10)) {
            this.setBeamTarget(NBTUtil.func_186861_c((NBTTagCompound)compound.func_74775_l("BeamTarget")));
        }
        if (compound.func_150297_b("Absorbing", 1)) {
            this.setAbsorbing(compound.func_74767_n("Absorbing"));
        }
    }

    protected void func_70014_b(NBTTagCompound compound) {
        if (this.getBeamTarget() != null) {
            compound.func_74782_a("BeamTarget", (NBTBase)NBTUtil.func_186859_a((BlockPos)this.getBeamTarget()));
        }
        compound.func_74757_a("Absorbing", this.isAbsorbing());
    }

    public void func_70071_h_() {
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        ++this.innerRotation;
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        this.checkCurrentTarget();
        if (this.currentTarget != null && this.currentTarget.func_70089_S()) {
            if (this.noTargetTicks != 0) {
                this.noTargetTicks = 0;
            }
            this.setBeamTarget(this.currentTarget.func_180425_c());
            if (this.field_70173_aa % 10 == 0 && this.isAbsorbing()) {
                if (this.currentTarget.func_70097_a(DamageSource.field_76376_m, 4.0f)) {
                    this.absorbedHealth += 2.0f;
                }
                if (this.absorbedHealth >= 0.5f * (float)CQRConfig.bosses.enderCalamityHealingCrystalAbsorbAmount * (float)(this.field_70170_p.func_175659_aa().func_151525_a() + 1)) {
                    this.setAbsorbing(false);
                    this.currentTarget = this.owningEntity;
                    if (this.owningEntity == null) {
                        this.setBeamTarget(null);
                    }
                }
            }
            if (!this.isAbsorbing() && this.owningEntity != null) {
                this.owningEntity.func_70691_i(1.0f);
                this.absorbedHealth -= 1.0f;
                if (this.absorbedHealth <= 0.0f) {
                    this.func_70106_y();
                    this.onCrystalDestroyed(DamageSource.field_76380_i);
                }
            } else if (!this.isAbsorbing()) {
                this.currentTarget = null;
            }
        } else {
            ++this.noTargetTicks;
            if (this.noTargetTicks >= 100) {
                if (this.isAbsorbing()) {
                    this.setAbsorbing(false);
                    this.currentTarget = this.owningEntity;
                    if (this.currentTarget == null) {
                        this.setBeamTarget(null);
                    }
                } else {
                    this.func_70106_y();
                    this.onCrystalDestroyed(DamageSource.field_76380_i);
                }
            }
        }
    }

    private void checkCurrentTarget() {
        if (this.currentTarget != null) {
            if (this.currentTarget.field_70128_L || !this.currentTarget.func_70089_S() || this.currentTarget.func_110143_aJ() / this.currentTarget.func_110138_aP() <= 0.25f) {
                this.currentTarget = null;
                this.setBeamTarget(null);
            } else if (this.func_70032_d((Entity)this.currentTarget) >= 48.0f) {
                this.currentTarget = null;
                this.setBeamTarget(null);
            }
        }
        if (this.currentTarget == null) {
            Vec3d p1 = this.func_174791_d().func_72441_c(32.0, 32.0, 32.0);
            Vec3d p2 = this.func_174791_d().func_178786_a(32.0, 32.0, 32.0);
            AxisAlignedBB aabb = new AxisAlignedBB(p1.field_72450_a, p1.field_72448_b, p1.field_72449_c, p2.field_72450_a, p2.field_72448_b, p2.field_72449_c);
            List affectedEntities = this.field_70170_p.func_175647_a(EntityLiving.class, aabb, this::doesEntityFitForAbsorbing);
            if (!affectedEntities.isEmpty()) {
                this.currentTarget = (EntityLivingBase)affectedEntities.get(DungeonGenUtils.randomBetween(0, affectedEntities.size() - 1, this.field_70146_Z));
            }
        }
    }

    public void func_174812_G() {
        this.onCrystalDestroyed(DamageSource.field_76377_j);
        super.func_174812_G();
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        if (source.func_76346_g() == this.owningEntity) {
            return false;
        }
        if (!this.field_70128_L && !this.field_70170_p.field_72995_K) {
            this.func_70106_y();
            if (!this.field_70170_p.field_72995_K) {
                if (!source.func_94541_c()) {
                    this.field_70170_p.func_72876_a((Entity)null, this.field_70165_t, this.field_70163_u, this.field_70161_v, 6.0f, true);
                }
                this.onCrystalDestroyed(source);
            }
        }
        return true;
    }

    private void onCrystalDestroyed(DamageSource source) {
        if (source != DamageSource.field_76380_i) {
            Vec3d p1 = this.func_174791_d().func_72441_c(16.0, 16.0, 16.0);
            Vec3d p2 = this.func_174791_d().func_178786_a(16.0, 16.0, 16.0);
            AxisAlignedBB aabb = new AxisAlignedBB(p1.field_72450_a, p1.field_72448_b, p1.field_72449_c, p2.field_72450_a, p2.field_72448_b, p2.field_72449_c);
            List affectedEntities = this.field_70170_p.func_72872_a(EntityLiving.class, aabb);
            if (!affectedEntities.isEmpty()) {
                float healingAmount = 4.0f * (this.absorbedHealth / (float)affectedEntities.size());
                affectedEntities.forEach(arg0 -> arg0.func_70691_i(healingAmount));
            }
        }
    }

    private void setBeamTarget(@Nullable BlockPos beamTarget) {
        this.func_184212_Q().func_187227_b(BEAM_TARGET, (Object)Optional.fromNullable((Object)beamTarget));
    }

    @Nullable
    public BlockPos getBeamTarget() {
        return (BlockPos)((Optional)this.func_184212_Q().func_187225_a(BEAM_TARGET)).orNull();
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_70112_a(double distance) {
        return super.func_70112_a(distance) || this.getBeamTarget() != null;
    }

    @Nullable
    private Faction getFaction() {
        if (this.field_70170_p.field_72995_K) {
            return null;
        }
        if (this.owningEntity != null) {
            return FactionRegistry.instance(this).getFactionOf((Entity)this.owningEntity);
        }
        return null;
    }

    private boolean doesEntityFitForAbsorbing(EntityLiving living) {
        if (living != this.owningEntity && TargetUtil.PREDICATE_LIVING.apply((Object)living)) {
            return living.func_110143_aJ() / living.func_110138_aP() >= 0.5f;
        }
        return false;
    }

    public boolean isAbsorbing() {
        return (Boolean)this.field_70180_af.func_187225_a(ABSORBING);
    }

    private void setAbsorbing(boolean value) {
        if (!this.field_70170_p.field_72995_K) {
            this.field_70180_af.func_187227_b(ABSORBING, (Object)value);
        }
    }
}

