/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.entity.boss.endercalamity;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.BossInfo;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.IAnimationTickable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.SoundKeyframeEvent;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import team.cqr.cqrepoured.CQRMain;
import team.cqr.cqrepoured.config.CQRConfig;
import team.cqr.cqrepoured.entity.ICirclingEntity;
import team.cqr.cqrepoured.entity.IServerAnimationReceiver;
import team.cqr.cqrepoured.entity.ai.boss.endercalamity.BossAIAreaLightnings;
import team.cqr.cqrepoured.entity.ai.boss.endercalamity.BossAIBlockThrower;
import team.cqr.cqrepoured.entity.ai.boss.endercalamity.BossAICalamityBuilding;
import team.cqr.cqrepoured.entity.ai.boss.endercalamity.BossAICalamityHealing;
import team.cqr.cqrepoured.entity.ai.boss.endercalamity.BossAIEndLaser;
import team.cqr.cqrepoured.entity.ai.boss.endercalamity.BossAIEnergyTennis;
import team.cqr.cqrepoured.entity.ai.boss.endercalamity.BossAIRandomTeleportEyes;
import team.cqr.cqrepoured.entity.ai.boss.endercalamity.BossAIRandomTeleportLaser;
import team.cqr.cqrepoured.entity.ai.boss.endercalamity.BossAIStunned;
import team.cqr.cqrepoured.entity.ai.boss.endercalamity.BossAISummonMinions;
import team.cqr.cqrepoured.entity.ai.boss.endercalamity.BossAITeleportAroundHome;
import team.cqr.cqrepoured.entity.ai.target.EntityAICQRNearestAttackTarget;
import team.cqr.cqrepoured.entity.ai.target.EntityAIHurtByTarget;
import team.cqr.cqrepoured.entity.ai.target.EntityAINearestAttackTargetAtHomeArea;
import team.cqr.cqrepoured.entity.bases.AbstractEntityCQRBoss;
import team.cqr.cqrepoured.entity.bases.ISummoner;
import team.cqr.cqrepoured.entity.boss.endercalamity.IEnderCalamityPhase;
import team.cqr.cqrepoured.entity.boss.endercalamity.phases.EEnderCalamityPhase;
import team.cqr.cqrepoured.entity.projectiles.ProjectileEnergyOrb;
import team.cqr.cqrepoured.faction.EDefaultFaction;
import team.cqr.cqrepoured.faction.Faction;
import team.cqr.cqrepoured.init.CQRCreatureAttributes;
import team.cqr.cqrepoured.init.CQRLoottables;
import team.cqr.cqrepoured.init.CQRSounds;
import team.cqr.cqrepoured.network.server.packet.endercalamity.SPacketCalamityUpdateHand;
import team.cqr.cqrepoured.network.server.packet.endercalamity.SPacketSyncCalamityRotation;
import team.cqr.cqrepoured.util.DungeonGenUtils;

public class EntityCQREnderCalamity
extends AbstractEntityCQRBoss
implements IAnimatable,
ISummoner,
ICirclingEntity,
IServerAnimationReceiver,
IAnimationTickable {
    private static final int HURT_DURATION = 8;
    private static final int ARENA_RADIUS = 20;
    private int cqrHurtTime = 0;
    protected static final DataParameter<Boolean> IS_HURT = EntityDataManager.func_187226_a(EntityCQREnderCalamity.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Boolean> SHIELD_ACTIVE = EntityDataManager.func_187226_a(EntityCQREnderCalamity.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> ROTATE_BODY_PITCH = EntityDataManager.func_187226_a(EntityCQREnderCalamity.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> IS_DEAD_AND_ON_THE_GROUND = EntityDataManager.func_187226_a(EntityCQREnderCalamity.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<com.google.common.base.Optional<IBlockState>> BLOCK_LEFT_UPPER = EntityDataManager.func_187226_a(EntityCQREnderCalamity.class, (DataSerializer)DataSerializers.field_187197_g);
    private static final DataParameter<com.google.common.base.Optional<IBlockState>> BLOCK_LEFT_MIDDLE = EntityDataManager.func_187226_a(EntityCQREnderCalamity.class, (DataSerializer)DataSerializers.field_187197_g);
    private static final DataParameter<com.google.common.base.Optional<IBlockState>> BLOCK_LEFT_LOWER = EntityDataManager.func_187226_a(EntityCQREnderCalamity.class, (DataSerializer)DataSerializers.field_187197_g);
    private static final DataParameter<com.google.common.base.Optional<IBlockState>> BLOCK_RIGHT_UPPER = EntityDataManager.func_187226_a(EntityCQREnderCalamity.class, (DataSerializer)DataSerializers.field_187197_g);
    private static final DataParameter<com.google.common.base.Optional<IBlockState>> BLOCK_RIGHT_MIDDLE = EntityDataManager.func_187226_a(EntityCQREnderCalamity.class, (DataSerializer)DataSerializers.field_187197_g);
    private static final DataParameter<com.google.common.base.Optional<IBlockState>> BLOCK_RIGHT_LOWER = EntityDataManager.func_187226_a(EntityCQREnderCalamity.class, (DataSerializer)DataSerializers.field_187197_g);
    private boolean isDowned = false;
    private int attackCounter = 0;
    private int currentPhaseTimer = 0;
    private int currentPhaseRunningTime = 0;
    private int noTennisCounter = 0;
    private int blockDestructionTimer = 10;
    private EEnderCalamityPhase currentPhase = EEnderCalamityPhase.PHASE_NO_TARGET;
    public float rotationPitchCQR;
    public float prevRotationPitchCQR;
    public float serverRotationPitchCQR;
    private AnimationFactory factory = new AnimationFactory((IAnimatable)this);
    private BossAITeleportAroundHome teleportAI;
    private BossAIBlockThrower blockThrowerAI;
    private BossAIEnergyTennis tennisAI;
    public static final String ANIM_NAME_PREFIX = "animation.ender_calamity.";
    public static final String ANIM_NAME_IDLE_BODY = "animation.ender_calamity.idle";
    public static final String ANIM_NAME_HURT = "animation.ender_calamity.hit";
    public static final String ANIM_NAME_SHOOT_LASER = "animation.ender_calamity.shoot_laser";
    public static final String ANIM_NAME_SHOOT_LASER_LONG = "animation.ender_calamity.shoot_laser_long";
    public static final String ANIM_NAME_DEFLECT_BALL = "animation.ender_calamity.deflectBall";
    public static final String ANIM_NAME_CHARGE_ENERGY_BALL = "animation.ender_calamity.prepareEnergyBall";
    public static final String ANIM_NAME_SHOOT_BALL = "animation.ender_calamity.shootEnergyBall";
    public static final String ANIM_NAME_SPIN_HANDS = "animation.ender_calamity.spin_hands";
    public static final String ANIM_NAME_LASER_STATIONARY = "animation.ender_calamity.laser_stationary";
    public static final String ANIM_NAME_DEATH_FALLING = "animation.ender_calamity.death";
    public static final String ANIM_NAME_DEATH_ON_GROUND = "animation.ender_calamity.death_on_ground";
    private String currentAnimation = null;
    private static final String ANIM_NAME_ARM_RU_IDLE = "animation.ender_calamity.idle_armRU";
    private static final String ANIM_NAME_ARM_RU_THROW = "animation.ender_calamity.throwBlock_RU";
    private boolean updateIndicator_Hand_RU = false;
    private static final String ANIM_NAME_ARM_RM_IDLE = "animation.ender_calamity.idle_armRM";
    private static final String ANIM_NAME_ARM_RM_THROW = "animation.ender_calamity.throwBlock_RM";
    private Boolean updateIndicator_Hand_RM = false;
    private static final String ANIM_NAME_ARM_RL_IDLE = "animation.ender_calamity.idle_armRL";
    private static final String ANIM_NAME_ARM_RL_THROW = "animation.ender_calamity.throwBlock_RL";
    private Boolean updateIndicator_Hand_RL = false;
    private static final String ANIM_NAME_ARM_LU_IDLE = "animation.ender_calamity.idle_armLU";
    private static final String ANIM_NAME_ARM_LU_THROW = "animation.ender_calamity.throwBlock_LU";
    private Boolean updateIndicator_Hand_LU = false;
    private static final String ANIM_NAME_ARM_LM_IDLE = "animation.ender_calamity.idle_armLM";
    private static final String ANIM_NAME_ARM_LM_THROW = "animation.ender_calamity.throwBlock_LM";
    private Boolean updateIndicator_Hand_LM = false;
    private static final String ANIM_NAME_ARM_LL_IDLE = "animation.ender_calamity.idle_armLL";
    private static final String ANIM_NAME_ARM_LL_THROW = "animation.ender_calamity.throwBlock_LL";
    private Boolean updateIndicator_Hand_LL = false;
    private boolean dontUpdatePhase = false;
    private List<Entity> summonedEntities = new ArrayList<Entity>();
    private com.google.common.base.Optional<String> newAnimation = com.google.common.base.Optional.absent();
    private DamageSource deathCause = null;
    private boolean isFalling = false;
    private static ResourceLocation LOOT_DROP_LOOTTABLE = CQRLoottables.CHESTS_TREASURE;

    public EEnderCalamityPhase getCurrentPhase() {
        return this.currentPhase;
    }

    public EntityCQREnderCalamity(World worldIn) {
        super(worldIn);
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.teleportAI = new BossAITeleportAroundHome(this, 40);
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)this.teleportAI);
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new BossAIStunned(this));
        this.tennisAI = new BossAIEnergyTennis(this);
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)this.tennisAI);
        this.blockThrowerAI = new BossAIBlockThrower(this);
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)this.blockThrowerAI);
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new BossAICalamityBuilding(this));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new BossAIEndLaser(this));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new BossAICalamityHealing(this));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new BossAISummonMinions(this));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new BossAIAreaLightnings(this, 20));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new BossAIRandomTeleportEyes(this));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new BossAIRandomTeleportLaser(this));
        this.field_70715_bh.field_75782_a.clear();
        this.field_70715_bh.func_75776_a(0, new EntityAINearestAttackTargetAtHomeArea<EntityCQREnderCalamity>(this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAICQRNearestAttackTarget(this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget(this));
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(IS_HURT, (Object)false);
        this.field_70180_af.func_187214_a(SHIELD_ACTIVE, (Object)true);
        this.field_70180_af.func_187214_a(ROTATE_BODY_PITCH, (Object)false);
        this.field_70180_af.func_187214_a(IS_DEAD_AND_ON_THE_GROUND, (Object)false);
        this.field_70180_af.func_187214_a(BLOCK_LEFT_UPPER, (Object)com.google.common.base.Optional.absent());
        this.field_70180_af.func_187214_a(BLOCK_LEFT_MIDDLE, (Object)com.google.common.base.Optional.absent());
        this.field_70180_af.func_187214_a(BLOCK_LEFT_LOWER, (Object)com.google.common.base.Optional.absent());
        this.field_70180_af.func_187214_a(BLOCK_RIGHT_UPPER, (Object)com.google.common.base.Optional.absent());
        this.field_70180_af.func_187214_a(BLOCK_RIGHT_MIDDLE, (Object)com.google.common.base.Optional.absent());
        this.field_70180_af.func_187214_a(BLOCK_RIGHT_LOWER, (Object)com.google.common.base.Optional.absent());
    }

    public boolean rotateBodyPitch() {
        return (Boolean)this.field_70180_af.func_187225_a(ROTATE_BODY_PITCH);
    }

    public void setRotateBodyPitch(boolean value) {
        if (this.func_70613_aW()) {
            this.field_70180_af.func_187227_b(ROTATE_BODY_PITCH, (Object)value);
        }
    }

    @Override
    public float getDefaultHeight() {
        return 4.0f;
    }

    @Override
    public float getDefaultWidth() {
        return 4.0f;
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        if (this.field_70729_aU || (double)this.func_110143_aJ() < 0.01 || this.field_70128_L || !this.func_70089_S()) {
            if (((Boolean)this.field_70180_af.func_187225_a(IS_DEAD_AND_ON_THE_GROUND)).booleanValue()) {
                event.getController().transitionLengthTicks = 0.0;
                event.getController().setAnimation(new AnimationBuilder().addAnimation(ANIM_NAME_DEATH_ON_GROUND, Boolean.valueOf(false)));
            } else {
                event.getController().setAnimation(new AnimationBuilder().addAnimation(ANIM_NAME_DEATH_FALLING, Boolean.valueOf(false)));
            }
            return PlayState.CONTINUE;
        }
        if (((Boolean)this.field_70180_af.func_187225_a(IS_HURT)).booleanValue()) {
            event.getController().transitionLengthTicks = 0.0;
            event.getController().setAnimation(new AnimationBuilder().addAnimation(ANIM_NAME_HURT, Boolean.valueOf(false)));
            return PlayState.CONTINUE;
        }
        event.getController().transitionLengthTicks = 10.0;
        if (this.newAnimation.isPresent()) {
            this.currentAnimation = (String)this.newAnimation.get();
            this.newAnimation = com.google.common.base.Optional.absent();
        }
        if (this.currentAnimation != null) {
            if (this.currentAnimation.equalsIgnoreCase(ANIM_NAME_SHOOT_BALL)) {
                event.getController().transitionLengthTicks = 0.0;
            }
            event.getController().setAnimation(new AnimationBuilder().addAnimation(this.currentAnimation).addAnimation(ANIM_NAME_IDLE_BODY, Boolean.valueOf(true)));
        }
        if (event.getController().getCurrentAnimation() == null) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation(ANIM_NAME_IDLE_BODY, Boolean.valueOf(true)));
        }
        return PlayState.CONTINUE;
    }

    private <E extends IAnimatable> void soundListenerArms(SoundKeyframeEvent<E> event) {
        SoundEvent sound = null;
        float pitch = 1.0f;
        float volume = 1.0f;
        switch (event.sound.toLowerCase()) {
            case "calamity_throw": {
                sound = CQRSounds.ENDER_CALAMITY_THROW_ITEM;
                pitch = 1.5f;
                volume = 10.0f;
                break;
            }
            default: {
                return;
            }
        }
        this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, sound, this.func_184176_by(), volume, pitch, false);
    }

    private <E extends IAnimatable> PlayState predicateArmRightUpper(AnimationEvent<E> event) {
        if (this.field_70729_aU || (double)this.func_110143_aJ() < 0.01 || this.field_70128_L || !this.func_70089_S()) {
            return PlayState.STOP;
        }
        if (event.getController().getCurrentAnimation() == null) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation(ANIM_NAME_ARM_RU_IDLE, Boolean.valueOf(true)));
        }
        if (this.updateIndicator_Hand_RU) {
            event.getController().clearAnimationCache();
            this.updateIndicator_Hand_RU = false;
            event.getController().setAnimation(new AnimationBuilder().addAnimation(ANIM_NAME_ARM_RU_THROW).addAnimation(ANIM_NAME_ARM_RU_IDLE, Boolean.valueOf(true)));
        }
        return PlayState.CONTINUE;
    }

    private <E extends IAnimatable> PlayState predicateArmRightMiddle(AnimationEvent<E> event) {
        if (this.field_70729_aU || (double)this.func_110143_aJ() < 0.01 || this.field_70128_L || !this.func_70089_S()) {
            return PlayState.STOP;
        }
        if (event.getController().getCurrentAnimation() == null) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation(ANIM_NAME_ARM_RM_IDLE, Boolean.valueOf(true)));
        }
        if (this.updateIndicator_Hand_RM.booleanValue()) {
            event.getController().clearAnimationCache();
            this.updateIndicator_Hand_RM = false;
            event.getController().setAnimation(new AnimationBuilder().addAnimation(ANIM_NAME_ARM_RM_THROW).addAnimation(ANIM_NAME_ARM_RM_IDLE, Boolean.valueOf(true)));
        }
        return PlayState.CONTINUE;
    }

    private <E extends IAnimatable> PlayState predicateArmRightLower(AnimationEvent<E> event) {
        if (this.field_70729_aU || (double)this.func_110143_aJ() < 0.01 || this.field_70128_L || !this.func_70089_S()) {
            return PlayState.STOP;
        }
        if (event.getController().getCurrentAnimation() == null) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation(ANIM_NAME_ARM_RL_IDLE, Boolean.valueOf(true)));
        }
        if (this.updateIndicator_Hand_RL.booleanValue()) {
            event.getController().clearAnimationCache();
            this.updateIndicator_Hand_RL = false;
            event.getController().setAnimation(new AnimationBuilder().addAnimation(ANIM_NAME_ARM_RL_THROW).addAnimation(ANIM_NAME_ARM_RL_IDLE, Boolean.valueOf(true)));
        }
        return PlayState.CONTINUE;
    }

    private <E extends IAnimatable> PlayState predicateArmLeftUpper(AnimationEvent<E> event) {
        if (this.field_70729_aU || (double)this.func_110143_aJ() < 0.01 || this.field_70128_L || !this.func_70089_S()) {
            return PlayState.STOP;
        }
        if (event.getController().getCurrentAnimation() == null) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation(ANIM_NAME_ARM_LU_IDLE, Boolean.valueOf(true)));
        }
        if (this.updateIndicator_Hand_LU.booleanValue()) {
            event.getController().clearAnimationCache();
            this.updateIndicator_Hand_LU = false;
            event.getController().setAnimation(new AnimationBuilder().addAnimation(ANIM_NAME_ARM_LU_THROW).addAnimation(ANIM_NAME_ARM_LU_IDLE, Boolean.valueOf(true)));
        }
        return PlayState.CONTINUE;
    }

    private <E extends IAnimatable> PlayState predicateArmLeftMiddle(AnimationEvent<E> event) {
        if (this.field_70729_aU || (double)this.func_110143_aJ() < 0.01 || this.field_70128_L || !this.func_70089_S()) {
            return PlayState.STOP;
        }
        if (event.getController().getCurrentAnimation() == null) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation(ANIM_NAME_ARM_LM_IDLE, Boolean.valueOf(true)));
        }
        if (this.updateIndicator_Hand_LM.booleanValue()) {
            event.getController().clearAnimationCache();
            this.updateIndicator_Hand_LM = false;
            event.getController().setAnimation(new AnimationBuilder().addAnimation(ANIM_NAME_ARM_LM_THROW).addAnimation(ANIM_NAME_ARM_LM_IDLE, Boolean.valueOf(true)));
        }
        return PlayState.CONTINUE;
    }

    private <E extends IAnimatable> PlayState predicateArmLeftLower(AnimationEvent<E> event) {
        if (this.field_70729_aU || (double)this.func_110143_aJ() < 0.01 || this.field_70128_L || !this.func_70089_S()) {
            return PlayState.STOP;
        }
        if (event.getController().getCurrentAnimation() == null) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation(ANIM_NAME_ARM_LL_IDLE, Boolean.valueOf(true)));
        }
        if (this.updateIndicator_Hand_LL.booleanValue()) {
            event.getController().clearAnimationCache();
            this.updateIndicator_Hand_LL = false;
            event.getController().setAnimation(new AnimationBuilder().addAnimation(ANIM_NAME_ARM_LL_THROW).addAnimation(ANIM_NAME_ARM_LL_IDLE, Boolean.valueOf(true)));
        }
        return PlayState.CONTINUE;
    }

    public boolean forceTeleport() {
        if (!this.hasAttackTarget()) {
            return false;
        }
        try {
            this.teleportAI.forceExecution();
            return true;
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
    }

    public void registerControllers(AnimationData data) {
        AnimationController[] handControllers;
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 10.0f, this::predicate));
        for (AnimationController ac : handControllers = new AnimationController[]{new AnimationController((IAnimatable)this, "controller_arm_ru", 5.0f, this::predicateArmRightUpper), new AnimationController((IAnimatable)this, "controller_arm_rm", 5.0f, this::predicateArmRightMiddle), new AnimationController((IAnimatable)this, "controller_arm_rl", 5.0f, this::predicateArmRightLower), new AnimationController((IAnimatable)this, "controller_arm_lu", 5.0f, this::predicateArmLeftUpper), new AnimationController((IAnimatable)this, "controller_arm_lm", 5.0f, this::predicateArmLeftMiddle), new AnimationController((IAnimatable)this, "controller_arm_ll", 5.0f, this::predicateArmLeftLower)}) {
            ac.registerSoundListener(this::soundListenerArms);
            data.addAnimationController(ac);
        }
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    @Override
    protected ResourceLocation func_184647_J() {
        return CQRLoottables.ENTITIES_ENDER_CALAMITY;
    }

    @Override
    public float getBaseHealth() {
        return CQRConfig.baseHealths.EnderCalamity;
    }

    @Override
    protected EDefaultFaction getDefaultFaction() {
        return EDefaultFaction.ENDERMEN;
    }

    @Override
    public boolean isSitting() {
        return false;
    }

    @Override
    public void enableBossBar() {
        super.enableBossBar();
        if (this.bossInfoServer != null) {
            this.bossInfoServer.func_186745_a(BossInfo.Color.PURPLE);
        }
    }

    public boolean func_70067_L() {
        return true;
    }

    public boolean func_70104_M() {
        return false;
    }

    public void func_70091_d(MoverType type, double x, double y, double z) {
        if (((Boolean)this.field_70180_af.func_187225_a(IS_DEAD_AND_ON_THE_GROUND)).booleanValue()) {
            return;
        }
        if (this.field_70729_aU || (double)this.func_110143_aJ() < 0.01 || this.field_70128_L || !this.func_70089_S()) {
            if (this.field_70163_u <= 1.0 + (this.func_174813_aQ().field_72337_e - this.func_174813_aQ().field_72338_b)) {
                this.isFalling = false;
                return;
            }
            super.func_70091_d(type, x, 0.125 * y, z);
        }
    }

    @Override
    public int getHealingPotions() {
        return 0;
    }

    @Override
    protected SoundEvent getDefaultHurtSound(DamageSource damageSourceIn) {
        return SoundEvents.field_187531_aU;
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187529_aS;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187530_aT;
    }

    protected float func_70599_aP() {
        return 2.0f * super.func_70599_aP();
    }

    protected float func_70647_i() {
        return 0.75f * super.func_70647_i();
    }

    public int func_70627_aG() {
        return 60;
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.0);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(12.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(10.0);
    }

    public boolean isShieldActive() {
        return (Boolean)this.field_70180_af.func_187225_a(SHIELD_ACTIVE);
    }

    private boolean canSphereDestroyShield(ProjectileEnergyOrb orb) {
        if (orb.getDeflectionCount() >= 5) {
            return true;
        }
        if (orb.getDeflectionCount() < this.field_70170_p.func_175659_aa().func_151525_a()) {
            return false;
        }
        double chance = 1.0 - 1.0 / (double)orb.getDeflectionCount();
        return DungeonGenUtils.percentageRandom(chance, this.func_70681_au());
    }

    @Override
    public boolean attackEntityFrom(DamageSource source, float amount, boolean sentFromPart) {
        if (source.func_76357_e()) {
            return super.attackEntityFrom(source, amount, sentFromPart);
        }
        if (source.func_76364_f() instanceof ProjectileEnergyOrb) {
            if (this.canSphereDestroyShield((ProjectileEnergyOrb)source.func_76364_f())) {
                this.tennisAI.calculateRemainingAttempts();
                this.field_70180_af.func_187227_b(SHIELD_ACTIVE, (Object)false);
                this.forcePhaseChangeToNextOf(EEnderCalamityPhase.PHASE_ENERGY_TENNIS.getPhaseObject());
                this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, 3.0f, false);
                this.func_184185_a(SoundEvents.field_187532_aV, 10.0f, 1.0f);
                return true;
            }
            ((ProjectileEnergyOrb)source.func_76364_f()).redirect(source.func_76346_g(), (EntityLivingBase)this);
            return false;
        }
        if (source instanceof EntityDamageSourceIndirect && !this.isDowned()) {
            if (this.teleportAI != null) {
                if (source.func_76346_g() != null && source.func_76346_g() instanceof EntityLivingBase) {
                    this.func_70624_b((EntityLivingBase)source.func_76346_g());
                }
                this.forceTeleport();
                switch (this.getCurrentPhase()) {
                    case PHASE_DYING: 
                    case PHASE_ENERGY_TENNIS: 
                    case PHASE_LASERING: 
                    case PHASE_STUNNED: 
                    case PHASE_TELEPORT_EYE_THROWER: 
                    case PHASE_TELEPORT_LASER: {
                        break;
                    }
                    default: {
                        this.forcePhaseChangeToNextOf(EEnderCalamityPhase.PHASE_TELEPORT_EYE_THROWER.getPhaseObject());
                    }
                }
            }
            return false;
        }
        if (!((Boolean)this.field_70180_af.func_187225_a(IS_HURT)).booleanValue() && !this.isShieldActive()) {
            if (!super.attackEntityFrom(source, amount, sentFromPart)) {
                return false;
            }
            if (!this.field_70170_p.field_72995_K) {
                this.field_70180_af.func_187227_b(IS_HURT, (Object)true);
                this.cqrHurtTime = 8;
                ++this.attackCounter;
                if (this.attackCounter >= 2 * this.field_70170_p.func_175659_aa().func_151525_a() && this.func_70681_au().nextBoolean()) {
                    this.field_70180_af.func_187227_b(SHIELD_ACTIVE, (Object)true);
                    this.attackCounter = 0;
                    this.forcePhaseChangeToNextOf(EEnderCalamityPhase.PHASE_IDLE.getPhaseObject());
                }
            }
            return true;
        }
        return false;
    }

    public void func_70030_z() {
        if (this.field_70148_d && !this.hasHomePositionCQR() && !this.field_70170_p.field_72995_K) {
            this.setHomePositionCQR(this.func_180425_c());
            this.forceTeleport();
        }
        super.func_70030_z();
        this.prevRotationPitchCQR = this.rotationPitchCQR;
        if (this.field_70170_p.field_72995_K) {
            this.rotationPitchCQR = this.serverRotationPitchCQR;
        } else {
            CQRMain.NETWORK.sendToAllTracking((IMessage)new SPacketSyncCalamityRotation(this), (Entity)this);
        }
    }

    protected void func_70619_bc() {
        if (this.field_70729_aU || (double)this.func_110143_aJ() < 0.01 || this.field_70128_L || !this.func_70089_S()) {
            super.func_70619_bc();
            return;
        }
        if (this.func_70026_G() && !this.getSummonedEntities().isEmpty()) {
            this.field_70170_p.func_72912_H().func_176142_i(20000);
            this.field_70170_p.func_72912_H().func_76080_g(0);
            this.field_70170_p.func_72912_H().func_76090_f(0);
            this.field_70170_p.func_72912_H().func_76084_b(false);
            this.field_70170_p.func_72912_H().func_76069_a(false);
            this.func_184185_a(SoundEvents.field_187533_aW, 2.5f, this.func_70647_i());
        }
        --this.blockDestructionTimer;
        if (this.blockDestructionTimer <= 0) {
            this.blockDestructionTimer = 10;
            boolean flag = false;
            Vec3i size = new Vec3i(this.func_174813_aQ().field_72336_d - this.func_174813_aQ().field_72340_a, this.func_174813_aQ().field_72337_e - this.func_174813_aQ().field_72338_b, this.func_174813_aQ().field_72334_f - this.func_174813_aQ().field_72339_c);
            size = new Vec3i((double)size.func_177958_n() * 0.5, (double)size.func_177956_o() * 0.5, (double)size.func_177952_p() * 0.5);
            for (BlockPos blockpos : BlockPos.func_177980_a((BlockPos)this.func_180425_c().func_177971_a(size), (BlockPos)this.func_180425_c().func_177973_b(size).func_177982_a(0, size.func_177956_o(), 0))) {
                IBlockState iblockstate = this.field_70170_p.func_180495_p(blockpos);
                Block block = iblockstate.func_177230_c();
                if (block.isAir(iblockstate, (IBlockAccess)this.field_70170_p, blockpos) || !block.canEntityDestroy(iblockstate, (IBlockAccess)this.field_70170_p, blockpos, (Entity)this) || !ForgeEventFactory.onEntityDestroyBlock((EntityLivingBase)this, (BlockPos)blockpos, (IBlockState)iblockstate)) continue;
                flag = this.field_70170_p.func_175655_b(blockpos, true) || flag;
            }
            if (flag) {
                this.field_70170_p.func_180498_a((EntityPlayer)null, 1023, new BlockPos((Entity)this), 0);
            }
        }
        super.func_70619_bc();
    }

    @Override
    public void func_70636_d() {
        if (this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 2; ++i) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.PORTAL, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O - 0.25, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, (this.field_70146_Z.nextDouble() - 0.5) * 2.0, -this.field_70146_Z.nextDouble(), (this.field_70146_Z.nextDouble() - 0.5) * 2.0, new int[0]);
            }
        } else {
            if (this.cqrHurtTime > 0) {
                --this.cqrHurtTime;
            }
            this.field_70180_af.func_187227_b(IS_HURT, (Object)(this.cqrHurtTime > 0 ? 1 : 0));
            this.handlePhases();
        }
        this.field_70703_bu = false;
        super.func_70636_d();
    }

    public int getCurrentPhaseRunningTicks() {
        return this.currentPhaseRunningTime;
    }

    private void handlePhases() {
        if (this.cantUpdatePhase()) {
            return;
        }
        IEnderCalamityPhase phase = this.currentPhase.getPhaseObject();
        if (this.currentPhase == EEnderCalamityPhase.PHASE_NO_TARGET) {
            if (this.hasAttackTarget()) {
                this.switchToNextPhaseOf(phase);
            }
            return;
        }
        ++this.currentPhaseRunningTime;
        boolean timedPhaseChange = false;
        if (phase.isPhaseTimed()) {
            --this.currentPhaseTimer;
            boolean bl = timedPhaseChange = this.currentPhaseTimer < 0;
        }
        if (timedPhaseChange) {
            this.switchToNextPhaseOf(phase);
            if (this.currentPhase == EEnderCalamityPhase.PHASE_BUILDING || this.currentPhase == EEnderCalamityPhase.PHASE_LASERING || this.currentPhase == EEnderCalamityPhase.PHASE_TELEPORT_EYE_THROWER || this.currentPhase == EEnderCalamityPhase.PHASE_TELEPORT_LASER) {
                if (this.currentPhase != EEnderCalamityPhase.PHASE_ENERGY_TENNIS) {
                    this.tennisAI.calculateRemainingAttempts();
                    ++this.noTennisCounter;
                    if (this.noTennisCounter > 5) {
                        this.switchToPhase(EEnderCalamityPhase.PHASE_ENERGY_TENNIS.getPhaseObject());
                        this.noTennisCounter = 0;
                    }
                } else {
                    this.noTennisCounter = 0;
                }
            }
        }
    }

    public void setCantUpdatePhase(boolean value) {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        this.dontUpdatePhase = value;
    }

    private boolean cantUpdatePhase() {
        if (this.field_70170_p.field_72995_K) {
            return true;
        }
        return this.dontUpdatePhase;
    }

    private void switchToPhase(IEnderCalamityPhase nextPhase) {
        this.currentPhase = EEnderCalamityPhase.getByPhaseObject(nextPhase);
        if (nextPhase.isPhaseTimed()) {
            this.currentPhaseTimer = nextPhase.getRandomExecutionTime().get();
        }
        this.currentPhaseRunningTime = 0;
        switch (this.currentPhase) {
            case PHASE_DYING: 
            case PHASE_ENERGY_TENNIS: 
            case PHASE_STUNNED: 
            case PHASE_NO_TARGET: {
                this.blockThrowerAI.forceDropAllBlocks();
                break;
            }
        }
        this.isDowned = this.currentPhase == EEnderCalamityPhase.PHASE_STUNNED;
    }

    private void switchToNextPhaseOf(IEnderCalamityPhase phase) {
        Optional<IEnderCalamityPhase> nextPhase = phase.getNextPhase(this);
        if (nextPhase.isPresent()) {
            this.switchToPhase(nextPhase.get());
        }
    }

    public void forcePhaseChange() {
        this.forcePhaseChangeToNextOf(this.currentPhase.getPhaseObject());
    }

    public void forcePhaseChangeToNextOf(IEnderCalamityPhase phase) {
        this.switchToNextPhaseOf(phase);
    }

    public boolean filterSummonLists() {
        ArrayList<Entity> tmp = new ArrayList<Entity>();
        boolean result = false;
        for (Entity ent : this.summonedEntities) {
            if (ent != null && !ent.field_70128_L) continue;
            tmp.add(ent);
        }
        for (Entity e : tmp) {
            this.summonedEntities.remove(e);
        }
        result = !tmp.isEmpty();
        tmp.clear();
        return result;
    }

    public void swingHand(E_CALAMITY_HAND hand) {
        SPacketCalamityUpdateHand packet = SPacketCalamityUpdateHand.builder(this).swingArm(hand, true).build();
        CQRMain.NETWORK.sendToAllTracking((IMessage)packet, (Entity)this);
    }

    public com.google.common.base.Optional<IBlockState> getBlockFromHand(E_CALAMITY_HAND hand) {
        if (hand == null) {
            return com.google.common.base.Optional.absent();
        }
        switch (hand) {
            case LEFT_LOWER: {
                return (com.google.common.base.Optional)this.field_70180_af.func_187225_a(BLOCK_LEFT_LOWER);
            }
            case LEFT_MIDDLE: {
                return (com.google.common.base.Optional)this.field_70180_af.func_187225_a(BLOCK_LEFT_MIDDLE);
            }
            case LEFT_UPPER: {
                return (com.google.common.base.Optional)this.field_70180_af.func_187225_a(BLOCK_LEFT_UPPER);
            }
            case RIGHT_LOWER: {
                return (com.google.common.base.Optional)this.field_70180_af.func_187225_a(BLOCK_RIGHT_LOWER);
            }
            case RIGHT_MIDDLE: {
                return (com.google.common.base.Optional)this.field_70180_af.func_187225_a(BLOCK_RIGHT_MIDDLE);
            }
            case RIGHT_UPPER: {
                return (com.google.common.base.Optional)this.field_70180_af.func_187225_a(BLOCK_RIGHT_UPPER);
            }
        }
        return com.google.common.base.Optional.absent();
    }

    public void removeHandBlock(E_CALAMITY_HAND hand) {
        com.google.common.base.Optional value = com.google.common.base.Optional.absent();
        this.equipBlock(hand, (com.google.common.base.Optional<IBlockState>)value);
    }

    public void equipBlock(E_CALAMITY_HAND hand, Block block) {
        this.equipBlock(hand, block.func_176223_P());
    }

    public void equipBlock(E_CALAMITY_HAND hand, com.google.common.base.Optional<IBlockState> value) {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        switch (hand) {
            case LEFT_LOWER: {
                this.field_70180_af.func_187227_b(BLOCK_LEFT_LOWER, value);
                break;
            }
            case LEFT_MIDDLE: {
                this.field_70180_af.func_187227_b(BLOCK_LEFT_MIDDLE, value);
                break;
            }
            case LEFT_UPPER: {
                this.field_70180_af.func_187227_b(BLOCK_LEFT_UPPER, value);
                break;
            }
            case RIGHT_LOWER: {
                this.field_70180_af.func_187227_b(BLOCK_RIGHT_LOWER, value);
                break;
            }
            case RIGHT_MIDDLE: {
                this.field_70180_af.func_187227_b(BLOCK_RIGHT_MIDDLE, value);
                break;
            }
            case RIGHT_UPPER: {
                this.field_70180_af.func_187227_b(BLOCK_RIGHT_UPPER, value);
                break;
            }
        }
    }

    public void equipBlock(E_CALAMITY_HAND hand, IBlockState blockstate) {
        this.equipBlock(hand, (com.google.common.base.Optional<IBlockState>)com.google.common.base.Optional.of((Object)blockstate));
    }

    public void func_70015_d(int seconds) {
    }

    @Override
    public Faction getSummonerFaction() {
        return this.getFaction();
    }

    @Override
    public List<Entity> getSummonedEntities() {
        return this.summonedEntities;
    }

    @Override
    public EntityLivingBase getSummoner() {
        return this;
    }

    @Override
    public void addSummonedEntityToList(Entity summoned) {
        this.summonedEntities.add(summoned);
    }

    public boolean isDowned() {
        return this.isDowned;
    }

    @Override
    public void teleport(double x, double y, double z) {
        double oldX = this.field_70165_t;
        double oldY = this.field_70163_u;
        double oldZ = this.field_70161_v;
        super.teleport(x, y, z);
        this.func_184185_a(SoundEvents.field_187791_eX, 3.0f, 0.9f + this.field_70146_Z.nextFloat() * 0.2f);
        ((WorldServer)this.field_70170_p).func_175739_a(EnumParticleTypes.PORTAL, oldX, oldY + (double)this.field_70131_O * 0.5, oldZ, 4, 0.2, 0.2, 0.2, 0.0, new int[0]);
        ((WorldServer)this.field_70170_p).func_175739_a(EnumParticleTypes.PORTAL, x, y + (double)this.field_70131_O * 0.5, z, 4, 0.2, 0.2, 0.2, 0.0, new int[0]);
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74757_a("isDowned", this.isDowned);
        compound.func_74757_a("deadAndOnGround", ((Boolean)this.field_70180_af.func_187225_a(IS_DEAD_AND_ON_THE_GROUND)).booleanValue());
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.isDowned = compound.func_74767_n("isDowned");
        this.field_70180_af.func_187227_b(IS_DEAD_AND_ON_THE_GROUND, (Object)compound.func_74767_n("deadAndOnGround"));
    }

    public static int getArenaRadius() {
        return 20;
    }

    public void processHandUpdates(byte[] handStates) {
        if (this.field_70170_p.field_72995_K) {
            block8: for (int i = 0; i < handStates.length; ++i) {
                if (handStates[i] == 0) continue;
                E_CALAMITY_HAND hand = E_CALAMITY_HAND.values()[i];
                switch (hand) {
                    case LEFT_LOWER: {
                        this.updateIndicator_Hand_LL = true;
                        continue block8;
                    }
                    case LEFT_MIDDLE: {
                        this.updateIndicator_Hand_LM = true;
                        continue block8;
                    }
                    case LEFT_UPPER: {
                        this.updateIndicator_Hand_LU = true;
                        continue block8;
                    }
                    case RIGHT_LOWER: {
                        this.updateIndicator_Hand_RL = true;
                        continue block8;
                    }
                    case RIGHT_MIDDLE: {
                        this.updateIndicator_Hand_RM = true;
                        continue block8;
                    }
                    case RIGHT_UPPER: {
                        this.updateIndicator_Hand_RU = true;
                    }
                }
            }
        }
    }

    public EnumCreatureAttribute func_70668_bt() {
        return CQRCreatureAttributes.VOID;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void processAnimationUpdate(String animationID) {
        if (this.field_70170_p.field_72995_K) {
            this.newAnimation = com.google.common.base.Optional.of((Object)animationID);
        }
    }

    @Override
    public BlockPos getCirclingCenter() {
        if (this.hasHomePositionCQR()) {
            return this.getHomePositionCQR();
        }
        return this.func_180425_c();
    }

    public boolean func_70685_l(Entity entityIn) {
        return entityIn.func_174818_b(this.getCirclingCenter()) <= 2304.0;
    }

    @Override
    public void func_70645_a(DamageSource cause) {
        this.deathCause = cause;
        this.field_70180_af.func_187227_b(SHIELD_ACTIVE, (Object)false);
        super.func_70645_a(cause);
    }

    protected void func_184231_a(double y, boolean onGroundIn, IBlockState state, BlockPos pos) {
        this.isFalling = !onGroundIn;
        super.func_184231_a(y, onGroundIn, state, pos);
    }

    @Override
    protected void func_70609_aI() {
        if (!this.func_70613_aW()) {
            return;
        }
        if (this.isFalling) {
            return;
        }
        ++this.field_70725_aQ;
        if (this.field_70725_aQ < 10) {
            return;
        }
        if (this.field_70725_aQ % 2 == 0 && this.deathCause != null) {
            this.dropSingleItemFromLoottable(LOOT_DROP_LOOTTABLE, this.field_70718_bc > 0, ForgeHooks.getLootingLevel((Entity)this, (Entity)this.deathCause.func_76346_g(), (DamageSource)this.deathCause), this.deathCause);
        }
        if (!((Boolean)this.field_70180_af.func_187225_a(IS_DEAD_AND_ON_THE_GROUND)).booleanValue()) {
            this.field_70180_af.func_187227_b(IS_DEAD_AND_ON_THE_GROUND, (Object)true);
        }
        if (this.field_70725_aQ == 53) {
            this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, 2.0f, false);
            this.setSizeVariation(0.0f);
        }
        if (this.field_70725_aQ >= 54) {
            if (this.deathCause != null) {
                this.func_184610_a(this.field_70718_bc > 0, ForgeHooks.getLootingLevel((Entity)this, (Entity)this.deathCause.func_76346_g(), (DamageSource)this.deathCause), this.deathCause);
            }
            this.func_70106_y();
            this.onFinalDeath();
        }
    }

    private void dropSingleItemFromLoottable(ResourceLocation table, boolean wasRecentlyHit, int lootingModifier, DamageSource source) {
        if (table != null) {
            List loot;
            LootTable lootTable = this.field_70170_p.func_184146_ak().func_186521_a(table);
            LootContext.Builder lootContextBuilder = new LootContext.Builder((WorldServer)this.field_70170_p).func_186472_a((Entity)this).func_186473_a(source);
            if (wasRecentlyHit && this.field_70717_bb != null) {
                lootContextBuilder = lootContextBuilder.func_186470_a(this.field_70717_bb).func_186469_a(this.field_70717_bb.func_184817_da());
            }
            if ((loot = lootTable.func_186462_a(this.field_70146_Z, lootContextBuilder.func_186471_a())).isEmpty()) {
                return;
            }
            Collections.shuffle(loot, this.func_70681_au());
            ItemStack rolledItem = (ItemStack)loot.get(0);
            EntityItem item = this.func_70099_a(rolledItem, 0.0f);
            double vy = 0.25 + 0.5 * this.func_70681_au().nextDouble();
            double vx = -0.25 + 0.5 * this.func_70681_au().nextDouble();
            double vz = -0.25 + 0.5 * this.func_70681_au().nextDouble();
            item.field_70159_w = vx;
            item.field_70181_x = vy;
            item.field_70179_y = vz;
            item.field_70133_I = true;
            item.func_184224_h(true);
        }
    }

    public void tick() {
    }

    public int tickTimer() {
        return this.field_70173_aa;
    }

    public static void reloadLootDropLoottable() {
        String configValue = CQRConfig.bosses.enderCalamityLootPool;
        LOOT_DROP_LOOTTABLE = new ResourceLocation(configValue);
    }

    public static enum E_CALAMITY_HAND {
        LEFT_UPPER("handLeftUpper"),
        LEFT_MIDDLE("handLeftMiddle"),
        LEFT_LOWER("handLeftLower"),
        RIGHT_UPPER("handRightUpper"),
        RIGHT_MIDDLE("handRightMiddle"),
        RIGHT_LOWER("handRightLower");

        private String boneName;
        private boolean isLeft;

        public String getBoneName() {
            return this.boneName;
        }

        public boolean isLeftSided() {
            return this.isLeft;
        }

        private E_CALAMITY_HAND(String bone) {
            this.boneName = bone;
            this.isLeft = this.name().startsWith("LEFT");
        }

        @Nullable
        public static E_CALAMITY_HAND getFromBoneName(String bone) {
            switch (bone) {
                case "handRightUpper": {
                    return RIGHT_UPPER;
                }
                case "handRightMiddle": {
                    return RIGHT_MIDDLE;
                }
                case "handRightLower": {
                    return RIGHT_LOWER;
                }
                case "handLeftUpper": {
                    return LEFT_UPPER;
                }
                case "handLeftMiddle": {
                    return LEFT_MIDDLE;
                }
                case "handLeftLower": {
                    return LEFT_LOWER;
                }
            }
            return null;
        }

        public int getIndex() {
            switch (this) {
                case LEFT_LOWER: {
                    return 2;
                }
                case LEFT_MIDDLE: {
                    return 1;
                }
                case LEFT_UPPER: {
                    return 0;
                }
                case RIGHT_LOWER: {
                    return 5;
                }
                case RIGHT_MIDDLE: {
                    return 4;
                }
                case RIGHT_UPPER: {
                    return 3;
                }
            }
            return 0;
        }
    }
}

