/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.entity.boss;

import net.minecraft.entity.Entity;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import team.cqr.cqrepoured.config.CQRConfig;
import team.cqr.cqrepoured.entity.Capes;
import team.cqr.cqrepoured.entity.EntityEquipmentExtraSlot;
import team.cqr.cqrepoured.entity.ai.boss.piratecaptain.BossAIPirateFleeSpell;
import team.cqr.cqrepoured.entity.ai.boss.piratecaptain.BossAIPirateSummonParrot;
import team.cqr.cqrepoured.entity.ai.boss.piratecaptain.BossAIPirateTeleportBehindEnemy;
import team.cqr.cqrepoured.entity.ai.boss.piratecaptain.BossAIPirateTurnInvisible;
import team.cqr.cqrepoured.entity.bases.AbstractEntityCQRBoss;
import team.cqr.cqrepoured.faction.EDefaultFaction;
import team.cqr.cqrepoured.init.CQRItems;
import team.cqr.cqrepoured.init.CQRLoottables;

public class EntityCQRPirateCaptain
extends AbstractEntityCQRBoss {
    private static final DataParameter<Boolean> IS_DISINTEGRATING = EntityDataManager.func_187226_a(EntityCQRPirateCaptain.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> IS_REINTEGRATING = EntityDataManager.func_187226_a(EntityCQRPirateCaptain.class, (DataSerializer)DataSerializers.field_187198_h);
    public static int TURN_INVISIBLE_ANIMATION_TIME = 15;
    private boolean spawnedParrot = false;

    public EntityCQRPirateCaptain(World worldIn) {
        super(worldIn);
    }

    @Override
    protected ResourceLocation func_184647_J() {
        return CQRLoottables.ENTITIES_PIRATE_CAPTAIN;
    }

    @Override
    public float getBaseHealth() {
        return CQRConfig.baseHealths.PirateCaptain;
    }

    @Override
    public EDefaultFaction getDefaultFaction() {
        return EDefaultFaction.PIRATE;
    }

    public boolean func_70687_e(PotionEffect potioneffectIn) {
        if (!super.func_70687_e(potioneffectIn)) {
            return false;
        }
        if (potioneffectIn.func_188419_a().field_188415_h) {
            return true;
        }
        return potioneffectIn.func_188419_a() == MobEffects.field_188423_x;
    }

    @Override
    public boolean func_70652_k(Entity entityIn) {
        this.spawnShoulderEntities();
        return super.func_70652_k(entityIn);
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.spellHandler.addSpell(1, new BossAIPirateSummonParrot(this, 0, 20, 20));
        this.spellHandler.addSpell(0, new BossAIPirateFleeSpell(this, 60, 30, 30));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new BossAIPirateTurnInvisible(this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new BossAIPirateTeleportBehindEnemy(this));
    }

    @Override
    public void setSitting(boolean sitting) {
        super.setSitting(false);
    }

    @Override
    public boolean hasCape() {
        return true;
    }

    @Override
    public ResourceLocation getResourceLocationOfCape() {
        return Capes.CAPE_PIRATE;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(IS_DISINTEGRATING, (Object)false);
        this.field_70180_af.func_187214_a(IS_REINTEGRATING, (Object)false);
    }

    @Override
    protected void func_180481_a(DifficultyInstance difficulty) {
        super.func_180481_a(difficulty);
        this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(CQRItems.CAPTAIN_REVOLVER, 1));
        this.setItemStackToExtraSlot(EntityEquipmentExtraSlot.ARROW, new ItemStack(CQRItems.BULLET_FIRE, 64));
        this.setItemStackToExtraSlot(EntityEquipmentExtraSlot.POTION, new ItemStack(CQRItems.POTION_HEALING, 2));
    }

    @Override
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, IEntityLivingData livingdata) {
        this.func_180481_a(difficulty);
        return super.func_180482_a(difficulty, livingdata);
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74757_a("spawnedParrot", this.spawnedParrot);
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.spawnedParrot = compound.func_74767_n("spawnedParrot");
    }

    public boolean hasSpawnedParrot() {
        return this.spawnedParrot;
    }

    public void setSpawnedParrot(boolean b) {
        this.spawnedParrot = b;
    }

    public void setIsDisintegrating(boolean value) {
        this.field_70180_af.func_187227_b(IS_DISINTEGRATING, (Object)value);
    }

    public void setIsReintegrating(boolean value) {
        this.field_70180_af.func_187227_b(IS_REINTEGRATING, (Object)value);
    }

    public boolean isDisintegrating() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_DISINTEGRATING);
    }

    public boolean isReintegrating() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_REINTEGRATING);
    }

    @Override
    public float getInvisibility() {
        return ((Float)this.field_70180_af.func_187225_a(INVISIBILITY)).floatValue();
    }

    @Override
    protected int getInvisibilityTurningTime() {
        return TURN_INVISIBLE_ANIMATION_TIME;
    }
}

