/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.entity.ai.spells;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import team.cqr.cqrepoured.entity.ai.spells.AbstractEntityAISpell;
import team.cqr.cqrepoured.entity.ai.spells.IEntityAISpellAnimatedVanilla;
import team.cqr.cqrepoured.entity.bases.AbstractEntityCQR;
import team.cqr.cqrepoured.entity.projectiles.ProjectileVampiricSpell;
import team.cqr.cqrepoured.util.DungeonGenUtils;
import team.cqr.cqrepoured.util.VectorUtil;

public class EntityAIVampiricSpell
extends AbstractEntityAISpell<AbstractEntityCQR>
implements IEntityAISpellAnimatedVanilla {
    protected static final int MIN_PROJECTILES = 1;
    protected static final int MAX_PROJECTILES = 5;

    public EntityAIVampiricSpell(AbstractEntityCQR entity, int cooldown, int chargingTicks) {
        super(entity, cooldown, chargingTicks, 1);
        this.setup(true, true, true, false);
    }

    @Override
    public void startCastingSpell() {
        int projectiles = DungeonGenUtils.randomBetween(1, 5, this.entity.func_70681_au());
        Vec3d vector = new Vec3d((Vec3i)this.entity.func_70638_az().func_180425_c().func_177973_b((Vec3i)this.entity.func_180425_c())).func_72432_b();
        vector = vector.func_178787_e(vector).func_178787_e(vector).func_178787_e(vector);
        double angle = 180.0 / (double)projectiles;
        vector = VectorUtil.rotateVectorAroundY(vector, 270.0 + angle / 2.0);
        Vec3d[] velocities = new Vec3d[projectiles];
        for (int i = 0; i < projectiles; ++i) {
            velocities[i] = VectorUtil.rotateVectorAroundY(vector, angle * (double)i);
        }
        for (Vec3d v : velocities) {
            ProjectileVampiricSpell proj = new ProjectileVampiricSpell(this.entity.field_70170_p, (EntityLivingBase)this.entity);
            proj.field_70159_w = v.field_72450_a * 0.5;
            proj.field_70181_x = v.field_72448_b * 0.5;
            proj.field_70179_y = v.field_72449_c * 0.5;
            proj.field_70133_I = true;
            this.entity.field_70170_p.func_72838_d((Entity)proj);
        }
    }

    @Override
    protected SoundEvent getStartChargingSound() {
        return SoundEvents.field_191247_bq;
    }

    @Override
    protected SoundEvent getStartCastingSound() {
        return SoundEvents.field_193784_dd;
    }

    @Override
    public int getWeight() {
        return 10;
    }

    @Override
    public boolean ignoreWeight() {
        return false;
    }

    @Override
    public float getRed() {
        return 1.0f;
    }

    @Override
    public float getGreen() {
        return 0.0f;
    }

    @Override
    public float getBlue() {
        return 1.0f;
    }
}

