/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.entity.ai.boss.exterminator;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.math.Vec3d;
import team.cqr.cqrepoured.entity.ai.AbstractCQREntityAI;
import team.cqr.cqrepoured.entity.boss.exterminator.EntityCQRExterminator;
import team.cqr.cqrepoured.entity.projectiles.ProjectileEarthQuake;
import team.cqr.cqrepoured.util.DungeonGenUtils;

public class BossAIExterminatorHulkSmash
extends AbstractCQREntityAI<EntityCQRExterminator> {
    protected static final int MIN_COOLDOWN = 100;
    protected static final int MAX_COOLDOWN = 200;
    protected int cooldown = 100;
    private boolean shockwaveWasSpawnedInCurrentCycle = false;

    public BossAIExterminatorHulkSmash(EntityCQRExterminator entity) {
        super(entity);
        this.func_75248_a(2);
    }

    public boolean func_75250_a() {
        if (this.entity != null && !((EntityCQRExterminator)this.entity).field_70128_L && ((EntityCQRExterminator)this.entity).hasAttackTarget()) {
            if (((EntityCQRExterminator)this.entity).isStunned()) {
                return false;
            }
            if (((EntityCQRExterminator)this.entity).isCannonRaised() && ((EntityCQRExterminator)this.entity).isCannonArmPlayingAnimation()) {
                return false;
            }
            if (((EntityCQRExterminator)this.entity).isCurrentlyPlayingAnimation()) {
                return false;
            }
            if (((EntityCQRExterminator)this.entity).isSurroundedByGroupWithMinSize(10) != null) {
                return true;
            }
            if (this.cooldown > 0) {
                --this.cooldown;
                return false;
            }
            return true;
        }
        return false;
    }

    public void func_75249_e() {
        ((EntityCQRExterminator)this.entity).sendAnimationUpdate("animation.exterminator.ground_slam");
    }

    public boolean func_75253_b() {
        if (((EntityCQRExterminator)this.entity).isStunned()) {
            return false;
        }
        return ((EntityCQRExterminator)this.entity).getCurrentAnimation() != null && ((EntityCQRExterminator)this.entity).getCurrentAnimation().equalsIgnoreCase("animation.exterminator.ground_slam");
    }

    public void func_75246_d() {
        super.func_75246_d();
        if (((EntityCQRExterminator)this.entity).isCannonRaised()) {
            ((EntityCQRExterminator)this.entity).switchCannonArmState(false);
            return;
        }
        if (((EntityCQRExterminator)this.entity).getCurrentAnimation().equalsIgnoreCase("animation.exterminator.ground_slam") && ((EntityCQRExterminator)this.entity).getCurrentAnimationTicks() <= 28 && !this.shockwaveWasSpawnedInCurrentCycle) {
            this.shockwaveWasSpawnedInCurrentCycle = true;
            Vec3d hitLocation = ((EntityCQRExterminator)this.entity).func_174791_d().func_178787_e(((EntityCQRExterminator)this.entity).func_70040_Z().func_72432_b().func_186678_a(1.5 * (double)((EntityCQRExterminator)this.entity).getSizeVariation()));
            this.world.func_72876_a((Entity)this.entity, hitLocation.field_72450_a, hitLocation.field_72448_b, hitLocation.field_72449_c, 4.0f, false);
            int quakeCount = 64;
            float angle = 5.625f;
            for (int i = 0; i < 64; ++i) {
                ProjectileEarthQuake peq = new ProjectileEarthQuake(this.world, (EntityLivingBase)this.entity);
                peq.func_184538_a((Entity)this.entity, 0.0f, angle * (float)i, 0.0f, 0.5f, 0.0f);
                peq.setThrowHeight(0.6);
                peq.func_70107_b(hitLocation.field_72450_a, hitLocation.field_72448_b, hitLocation.field_72449_c);
                this.world.func_72838_d((Entity)peq);
            }
        }
    }

    public void func_75251_c() {
        super.func_75251_c();
        this.cooldown = DungeonGenUtils.randomBetween(100, 200, ((EntityCQRExterminator)this.entity).func_70681_au());
        this.shockwaveWasSpawnedInCurrentCycle = false;
    }
}

